/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qtextboundaryfinder_wrapper.h"

// Extra includes
#include <qstring.h>
#include <qtextboundaryfinder.h>

using namespace Shiboken;

static int
SbkQTextBoundaryFinder_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QTextBoundaryFinder* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QTextBoundaryFinder", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QTextBoundaryFinder()
        cptr = new QTextBoundaryFinder();
    } else if (numArgs == 1 && Shiboken::Converter<QTextBoundaryFinder& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QTextBoundaryFinder* cpp_arg0 = Shiboken::Converter<QTextBoundaryFinder* >::toCpp(pyargs[0]);
        // QTextBoundaryFinder(QTextBoundaryFinder)
        cptr = new QTextBoundaryFinder(*cpp_arg0);
    } else if (numArgs == 2 && Shiboken::Converter<QTextBoundaryFinder::BoundaryType >::isConvertible(pyargs[0]) && Shiboken::Converter<QString& >::isConvertible(pyargs[1])) {
        QTextBoundaryFinder::BoundaryType cpp_arg0 = Shiboken::Converter<QTextBoundaryFinder::BoundaryType >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return -1;
        std::auto_ptr<QString > cpp_arg1_auto_ptr;
        QString* cpp_arg1 = Shiboken::Converter<QString* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QString >(cpp_arg1);
        // QTextBoundaryFinder(QTextBoundaryFinder::BoundaryType,QString)
        cptr = new QTextBoundaryFinder(cpp_arg0, *cpp_arg1);
    } else goto SbkQTextBoundaryFinder_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQTextBoundaryFinder_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQTextBoundaryFinder_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QTextBoundaryFinder.BoundaryType, PySide.QtCore.QString", "PySide.QtCore.QTextBoundaryFinder", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QTextBoundaryFinder", overloads);
        return -1;
}

static PyObject*
SbkQTextBoundaryFinderFunc_boundaryReasons(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // boundaryReasons()const
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    QFlags<QTextBoundaryFinder::BoundaryReason> cpp_result = cppSelf->QTextBoundaryFinder::boundaryReasons();
    py_result = Shiboken::Converter<QFlags<QTextBoundaryFinder::BoundaryReason> >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBoundaryFinderFunc_isAtBoundary(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAtBoundary()const
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextBoundaryFinder::isAtBoundary();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBoundaryFinderFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QTextBoundaryFinder::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBoundaryFinderFunc_position(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // position()const
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBoundaryFinder::position();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBoundaryFinderFunc_setPosition(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setPosition(int)
        QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
        cppSelf->QTextBoundaryFinder::setPosition(cpp_arg0);
    } else goto SbkQTextBoundaryFinderFunc_setPosition_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQTextBoundaryFinderFunc_setPosition_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QTextBoundaryFinder.setPosition", overloads);
        return 0;
}

static PyObject*
SbkQTextBoundaryFinderFunc_string(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // string()const
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QTextBoundaryFinder::string();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBoundaryFinderFunc_toEnd(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toEnd()
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    cppSelf->QTextBoundaryFinder::toEnd();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextBoundaryFinderFunc_toNextBoundary(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toNextBoundary()
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBoundaryFinder::toNextBoundary();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBoundaryFinderFunc_toPreviousBoundary(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // toPreviousBoundary()
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QTextBoundaryFinder::toPreviousBoundary();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQTextBoundaryFinderFunc_toStart(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // toStart()
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    cppSelf->QTextBoundaryFinder::toStart();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQTextBoundaryFinderFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QTextBoundaryFinder* cppSelf = Shiboken::Converter<QTextBoundaryFinder* >::toCpp((PyObject*)self);
    QTextBoundaryFinder::BoundaryType cpp_result = cppSelf->QTextBoundaryFinder::type();
    py_result = Shiboken::Converter<QTextBoundaryFinder::BoundaryType >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQTextBoundaryFinder_methods[] = {
    {"boundaryReasons", (PyCFunction)SbkQTextBoundaryFinderFunc_boundaryReasons, METH_NOARGS},
    {"isAtBoundary", (PyCFunction)SbkQTextBoundaryFinderFunc_isAtBoundary, METH_NOARGS},
    {"isValid", (PyCFunction)SbkQTextBoundaryFinderFunc_isValid, METH_NOARGS},
    {"position", (PyCFunction)SbkQTextBoundaryFinderFunc_position, METH_NOARGS},
    {"setPosition", (PyCFunction)SbkQTextBoundaryFinderFunc_setPosition, METH_O},
    {"string", (PyCFunction)SbkQTextBoundaryFinderFunc_string, METH_NOARGS},
    {"toEnd", (PyCFunction)SbkQTextBoundaryFinderFunc_toEnd, METH_NOARGS},
    {"toNextBoundary", (PyCFunction)SbkQTextBoundaryFinderFunc_toNextBoundary, METH_NOARGS},
    {"toPreviousBoundary", (PyCFunction)SbkQTextBoundaryFinderFunc_toPreviousBoundary, METH_NOARGS},
    {"toStart", (PyCFunction)SbkQTextBoundaryFinderFunc_toStart, METH_NOARGS},
    {"type", (PyCFunction)SbkQTextBoundaryFinderFunc_type, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQTextBoundaryFinder_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QTextBoundaryFinder",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QTextBoundaryFinder >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQTextBoundaryFinder_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQTextBoundaryFinder_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextBoundaryFinder::BoundaryReasons >::toPython(
        ((QTextBoundaryFinder::BoundaryReasons) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QTextBoundaryFinder::BoundaryReasons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextBoundaryFinder::BoundaryReasons >::toPython(
        ((QTextBoundaryFinder::BoundaryReasons) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QTextBoundaryFinder::BoundaryReasons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextBoundaryFinder::BoundaryReasons >::toPython(
        ((QTextBoundaryFinder::BoundaryReasons) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QTextBoundaryFinder::BoundaryReasons >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QTextBoundaryFinder::BoundaryReasons >::toPython(
        ~ Shiboken::Converter< QTextBoundaryFinder::BoundaryReasons >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BoundaryReason",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BoundaryReasons",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


static PyGetSetDef SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "BoundaryType",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QTextBoundaryFinder(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQTextBoundaryFinder_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQTextBoundaryFinder_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQTextBoundaryFinder_Type));
    PyModule_AddObject(module, "QTextBoundaryFinder",
        ((PyObject*)&SbkQTextBoundaryFinder_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: BoundaryReason
    SbkPySide_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYREASON_IDX] = &SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type);
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
            "BoundaryReason",((PyObject*)&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type));

    // init flags class: QFlags<QTextBoundaryFinder::BoundaryReason>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QTEXTBOUNDARYFINDER_BOUNDARYREASON__IDX] = &SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_Type);
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
            "BoundaryReasons",((PyObject*)&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReasons_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type,
        (long) QTextBoundaryFinder::NotAtBoundary, "NotAtBoundary");
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
        "NotAtBoundary", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type.tp_dict,
        "NotAtBoundary", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type,
        (long) QTextBoundaryFinder::StartWord, "StartWord");
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
        "StartWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type.tp_dict,
        "StartWord", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type,
        (long) QTextBoundaryFinder::EndWord, "EndWord");
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
        "EndWord", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextBoundaryFinder_BoundaryReason_Type.tp_dict,
        "EndWord", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextBoundaryFinder::BoundaryReason");

    // init enum class: BoundaryType
    SbkPySide_QtCoreTypes[SBK_QTEXTBOUNDARYFINDER_BOUNDARYTYPE_IDX] = &SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type);
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
            "BoundaryType",((PyObject*)&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type,
        (long) QTextBoundaryFinder::Grapheme, "Grapheme");
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
        "Grapheme", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type.tp_dict,
        "Grapheme", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type,
        (long) QTextBoundaryFinder::Word, "Word");
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
        "Word", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type.tp_dict,
        "Word", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type,
        (long) QTextBoundaryFinder::Line, "Line");
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
        "Line", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type.tp_dict,
        "Line", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type,
        (long) QTextBoundaryFinder::Sentence, "Sentence");
    PyDict_SetItemString(SbkQTextBoundaryFinder_Type.super.ht_type.tp_dict,
        "Sentence", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QTextBoundaryFinder_BoundaryType_Type.tp_dict,
        "Sentence", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QTextBoundaryFinder::BoundaryType");

    Shiboken::TypeResolver::createValueTypeResolver<QTextBoundaryFinder >("QTextBoundaryFinder");
    Shiboken::TypeResolver::createValueTypeResolver<QTextBoundaryFinder >(typeid(QTextBoundaryFinder).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

