/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qtconcurrent_wrapper.h"

// Extra includes
#include <qtconcurrentreducekernel.h>
#include <qtconcurrentthreadengine.h>

using namespace Shiboken;

static PyMethodDef SbkQtConcurrent_methods[] = {
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQtConcurrent_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QtConcurrent",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQtConcurrent_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

PyObject*
SbkPySide_QtCore_QtConcurrent_ReduceOption___and__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtConcurrent::ReduceOptions >::toPython(
        ((QtConcurrent::ReduceOptions) ((SbkEnumObject*)self)->ob_ival)
        & Shiboken::Converter< QtConcurrent::ReduceOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QtConcurrent_ReduceOption___or__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtConcurrent::ReduceOptions >::toPython(
        ((QtConcurrent::ReduceOptions) ((SbkEnumObject*)self)->ob_ival)
        | Shiboken::Converter< QtConcurrent::ReduceOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QtConcurrent_ReduceOption___xor__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtConcurrent::ReduceOptions >::toPython(
        ((QtConcurrent::ReduceOptions) ((SbkEnumObject*)self)->ob_ival)
        ^ Shiboken::Converter< QtConcurrent::ReduceOptions >::toCpp(arg)
    );
}

PyObject*
SbkPySide_QtCore_QtConcurrent_ReduceOption___invert__(PyObject* self, PyObject* arg)
{
    return Shiboken::Converter< QtConcurrent::ReduceOptions >::toPython(
        ~ Shiboken::Converter< QtConcurrent::ReduceOptions >::toCpp(self)
    );
}


static PyNumberMethods SbkPySide_QtCore_QtConcurrent_ReduceOption_as_number = {
    /*nb_add*/                  0,
    /*nb_subtract*/             0,
    /*nb_multiply*/             0,
    /*nb_divide*/               0,
    /*nb_remainder*/            0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             0,
    /*nb_positive*/             0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)SbkPySide_QtCore_QtConcurrent_ReduceOption___invert__,
    /*nb_lshift*/               0,
    /*nb_rshift*/               0,
    /*nb_and*/                  (binaryfunc)SbkPySide_QtCore_QtConcurrent_ReduceOption___and__,
    /*nb_xor*/                  (binaryfunc)SbkPySide_QtCore_QtConcurrent_ReduceOption___xor__,
    /*nb_or*/                   (binaryfunc)SbkPySide_QtCore_QtConcurrent_ReduceOption___or__,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          0,
    /*nb_inplace_subtract*/     0,
    /*nb_inplace_multiply*/     0,
    /*nb_inplace_divide*/       0,
    /*nb_inplace_remainder*/    0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       0,
    /*nb_inplace_rshift*/       0,
    /*nb_inplace_and*/          0,
    /*nb_inplace_xor*/          0,
    /*nb_inplace_or*/           0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};


static PyGetSetDef SbkPySide_QtCore_QtConcurrent_ReduceOption_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QtConcurrent_ReduceOption_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QtConcurrent_ReduceOption_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ReduceOption",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        &SbkPySide_QtCore_QtConcurrent_ReduceOption_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QtConcurrent_ReduceOption_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QtConcurrent_ReduceOption_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QtConcurrent_ReduceOption_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QtConcurrent_ReduceOptions_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QtConcurrent_ReduceOptions_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "ReduceOptions",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             &SbkPySide_QtCore_QtConcurrent_ReduceOption_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QtConcurrent_ReduceOptions_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QtConcurrent_ReduceOptions_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    if (!PyType_IsSubtype(type, &SbkPySide_QtCore_QtConcurrent_ReduceOptions_Type))
        return 0;

    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}



PyAPI_FUNC(void)
init_QtConcurrent(PyObject* module)
{
    if (PyType_Ready((PyTypeObject*)&SbkQtConcurrent_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQtConcurrent_Type));
    PyModule_AddObject(module, "QtConcurrent",
        ((PyObject*)&SbkQtConcurrent_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: ReduceOption
    SbkPySide_QtCoreTypes[SBK_QTCONCURRENT_REDUCEOPTION_IDX] = &SbkPySide_QtCore_QtConcurrent_ReduceOption_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QtConcurrent_ReduceOption_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QtConcurrent_ReduceOption_Type);
    PyDict_SetItemString(SbkQtConcurrent_Type.super.ht_type.tp_dict,
            "ReduceOption",((PyObject*)&SbkPySide_QtCore_QtConcurrent_ReduceOption_Type));

    // init flags class: QFlags<QtConcurrent::ReduceOption>
    SbkPySide_QtCoreTypes[SBK_QFLAGS_QTCONCURRENT_REDUCEOPTION__IDX] = &SbkPySide_QtCore_QtConcurrent_ReduceOptions_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QtConcurrent_ReduceOptions_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QtConcurrent_ReduceOptions_Type);
    PyDict_SetItemString(SbkQtConcurrent_Type.super.ht_type.tp_dict,
            "ReduceOptions",((PyObject*)&SbkPySide_QtCore_QtConcurrent_ReduceOptions_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtConcurrent_ReduceOption_Type,
        (long) QtConcurrent::UnorderedReduce, "UnorderedReduce");
    PyDict_SetItemString(SbkQtConcurrent_Type.super.ht_type.tp_dict,
        "UnorderedReduce", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtConcurrent_ReduceOption_Type.tp_dict,
        "UnorderedReduce", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtConcurrent_ReduceOption_Type,
        (long) QtConcurrent::OrderedReduce, "OrderedReduce");
    PyDict_SetItemString(SbkQtConcurrent_Type.super.ht_type.tp_dict,
        "OrderedReduce", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtConcurrent_ReduceOption_Type.tp_dict,
        "OrderedReduce", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QtConcurrent_ReduceOption_Type,
        (long) QtConcurrent::SequentialReduce, "SequentialReduce");
    PyDict_SetItemString(SbkQtConcurrent_Type.super.ht_type.tp_dict,
        "SequentialReduce", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QtConcurrent_ReduceOption_Type.tp_dict,
        "SequentialReduce", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QtConcurrent::ReduceOption");

}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

