/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qstatemachine_wrapper.h"
#include "qstatemachine_wrappedevent_wrapper.h"
#include "qstatemachine_signalevent_wrapper.h"

// Extra includes
#include <QList>
#include <QSet>
#include <qabstractanimation.h>
#include <qabstractstate.h>
#include <qabstracttransition.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsignaltransition.h>
#include <qstate.h>
#include <qstatemachine.h>
#include <qstring.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QStateMachineWrapper::QStateMachineWrapper(QObject * parent) : QStateMachine(parent), m_metaObject(0) {
    // ... middle
}

void QStateMachineWrapper::beginMicrostep(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "beginMicrostep"));
    if (py_override.isNull()) {
        return this->QStateMachine::beginMicrostep(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateMachineWrapper::beginSelectTransitions(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "beginSelectTransitions"));
    if (py_override.isNull()) {
        return this->QStateMachine::beginSelectTransitions(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateMachineWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStateMachineWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateMachineWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QStateMachineWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateMachineWrapper::endMicrostep(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endMicrostep"));
    if (py_override.isNull()) {
        return this->QStateMachine::endMicrostep(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateMachineWrapper::endSelectTransitions(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "endSelectTransitions"));
    if (py_override.isNull()) {
        return this->QStateMachine::endSelectTransitions(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QStateMachineWrapper::event(QEvent * e)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QStateMachine::event(e);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(e)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStateMachine.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QStateMachineWrapper::eventFilter(QObject * watched, QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QStateMachine::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(watched),
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QStateMachine.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QStateMachineWrapper::onEntry(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "onEntry"));
    if (py_override.isNull()) {
        return this->QStateMachine::onEntry(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateMachineWrapper::onExit(QEvent * event)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "onExit"));
    if (py_override.isNull()) {
        return this->QStateMachine::onExit(event);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(event)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QStateMachineWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QStateMachineWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QStateMachine::staticMetaObject);
}
    return m_metaObject;
}

int QStateMachineWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QStateMachine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QStateMachineWrapper::~QStateMachineWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQStateMachine_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QStateMachineWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QStateMachine", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QStateMachine(QObject*)
        cptr = new QStateMachineWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QStateMachine(QObject*)
        cptr = new QStateMachineWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQStateMachine_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQStateMachine_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQStateMachine_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStateMachine", overloads);
        return -1;
}

static PyObject*
SbkQStateMachineFunc_addDefaultAnimation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractAnimation* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractAnimation* cpp_arg0 = Shiboken::Converter<QAbstractAnimation* >::toCpp(arg);
        // addDefaultAnimation(QAbstractAnimation*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::addDefaultAnimation(cpp_arg0);
    } else goto SbkQStateMachineFunc_addDefaultAnimation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_addDefaultAnimation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.addDefaultAnimation", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_addState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractState* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractState* cpp_arg0 = Shiboken::Converter<QAbstractState* >::toCpp(arg);
        // addState(QAbstractState*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::addState(cpp_arg0);
        Shiboken::setParent(self, arg);
    } else goto SbkQStateMachineFunc_addState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_addState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.addState", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_beginMicrostep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // beginMicrostep(QEvent*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::beginMicrostep(cpp_arg0);
    } else goto SbkQStateMachineFunc_beginMicrostep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_beginMicrostep_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.beginMicrostep", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_beginSelectTransitions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // beginSelectTransitions(QEvent*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::beginSelectTransitions(cpp_arg0);
    } else goto SbkQStateMachineFunc_beginSelectTransitions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_beginSelectTransitions_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.beginSelectTransitions", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_cancelDelayedEvent(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // cancelDelayedEvent(int)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStateMachine::cancelDelayedEvent(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQStateMachineFunc_cancelDelayedEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStateMachineFunc_cancelDelayedEvent_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.cancelDelayedEvent", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_clearError(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // clearError()
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    cppSelf->QStateMachine::clearError();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQStateMachineFunc_configuration(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // configuration()
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    py_result = PySet_New(0);
    foreach(QAbstractState* abs_state, cppSelf->configuration()) {
            Shiboken::AutoDecRef obj(Shiboken::Converter<QAbstractState* >::toPython(abs_state));
            Shiboken::setParent(self, obj);
            PySet_Add(py_result, obj);
    }
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStateMachineFunc_defaultAnimations(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // defaultAnimations()
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    (void)cppSelf; // avoid warnings about unused variables
    // Begin code injection
    
    py_result = PyList_New(0);
    foreach(QAbstractAnimation* abs_anim, cppSelf->defaultAnimations()) {
            Shiboken::AutoDecRef obj(Shiboken::Converter<QAbstractAnimation* >::toPython(abs_anim));
            Shiboken::setParent(self, obj);
            PyList_Append(py_result, obj);
    }
    
    // End of code injection



    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStateMachineFunc_endMicrostep(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // endMicrostep(QEvent*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::endMicrostep(cpp_arg0);
    } else goto SbkQStateMachineFunc_endMicrostep_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_endMicrostep_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.endMicrostep", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_endSelectTransitions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // endSelectTransitions(QEvent*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::endSelectTransitions(cpp_arg0);
    } else goto SbkQStateMachineFunc_endSelectTransitions_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_endSelectTransitions_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.endSelectTransitions", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_error(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // error()const
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    QStateMachine::Error cpp_result = cppSelf->QStateMachine::error();
    py_result = Shiboken::Converter<QStateMachine::Error >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStateMachineFunc_errorString(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // errorString()const
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    QString cpp_result = cppSelf->QStateMachine::errorString();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStateMachineFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStateMachine::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQStateMachineFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStateMachineFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.event", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_eventFilter(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // eventFilter(QObject*,QEvent*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QStateMachine::eventFilter(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQStateMachineFunc_eventFilter_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStateMachineFunc_eventFilter_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStateMachine.eventFilter", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_globalRestorePolicy(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // globalRestorePolicy()const
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    QStateMachine::RestorePolicy cpp_result = cppSelf->QStateMachine::globalRestorePolicy();
    py_result = Shiboken::Converter<QStateMachine::RestorePolicy >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStateMachineFunc_isAnimated(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isAnimated()const
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStateMachine::isAnimated();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStateMachineFunc_isRunning(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRunning()const
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QStateMachine::isRunning();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQStateMachineFunc_onEntry(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // onEntry(QEvent*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::onEntry(cpp_arg0);
    } else goto SbkQStateMachineFunc_onEntry_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_onEntry_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.onEntry", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_onExit(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // onExit(QEvent*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::onExit(cpp_arg0);
    } else goto SbkQStateMachineFunc_onExit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_onExit_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.onExit", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_postDelayedEvent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "postDelayedEvent", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QEvent* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // postDelayedEvent(QEvent*,int)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        int cpp_result = cppSelf->QStateMachine::postDelayedEvent(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<int >::toPython(cpp_result);
    } else goto SbkQStateMachineFunc_postDelayedEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQStateMachineFunc_postDelayedEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStateMachine.postDelayedEvent", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_postEvent(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "postEvent", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // postEvent(QEvent*,QStateMachine::EventPriority)
            QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
            cppSelf->QStateMachine::postEvent(cpp_arg0);
        } else if (Shiboken::Converter<QStateMachine::EventPriority >::isConvertible(pyargs[1])) {
            QStateMachine::EventPriority cpp_arg1 = Shiboken::Converter<QStateMachine::EventPriority >::toCpp(pyargs[1]);
            // postEvent(QEvent*,QStateMachine::EventPriority)
            QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
            cppSelf->QStateMachine::postEvent(cpp_arg0, cpp_arg1);
        } else goto SbkQStateMachineFunc_postEvent_TypeError;
    } else goto SbkQStateMachineFunc_postEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_postEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent, PySide.QtCore.QStateMachine.EventPriority = NormalPriority", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QStateMachine.postEvent", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_removeDefaultAnimation(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractAnimation* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractAnimation* cpp_arg0 = Shiboken::Converter<QAbstractAnimation* >::toCpp(arg);
        // removeDefaultAnimation(QAbstractAnimation*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::removeDefaultAnimation(cpp_arg0);
    } else goto SbkQStateMachineFunc_removeDefaultAnimation_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_removeDefaultAnimation_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractAnimation", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.removeDefaultAnimation", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_removeState(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QAbstractState* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QAbstractState* cpp_arg0 = Shiboken::Converter<QAbstractState* >::toCpp(arg);
        // removeState(QAbstractState*)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::removeState(cpp_arg0);
        Shiboken::setParent(self, 0);
    } else goto SbkQStateMachineFunc_removeState_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_removeState_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractState", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.removeState", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_setAnimated(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        bool cpp_arg0 = Shiboken::Converter<bool >::toCpp(arg);
        // setAnimated(bool)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::setAnimated(cpp_arg0);
    } else goto SbkQStateMachineFunc_setAnimated_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_setAnimated_TypeError:
        const char* overloads[] = {"bool", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.setAnimated", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_setGlobalRestorePolicy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStateMachine::RestorePolicy >::isConvertible(arg)) {
        QStateMachine::RestorePolicy cpp_arg0 = Shiboken::Converter<QStateMachine::RestorePolicy >::toCpp(arg);
        // setGlobalRestorePolicy(QStateMachine::RestorePolicy)
        QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
        cppSelf->QStateMachine::setGlobalRestorePolicy(cpp_arg0);
    } else goto SbkQStateMachineFunc_setGlobalRestorePolicy_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQStateMachineFunc_setGlobalRestorePolicy_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStateMachine.RestorePolicy", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QStateMachine.setGlobalRestorePolicy", overloads);
        return 0;
}

static PyObject*
SbkQStateMachineFunc_start(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // start()
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    cppSelf->QStateMachine::start();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQStateMachineFunc_stop(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    // stop()
    QStateMachine* cppSelf = Shiboken::Converter<QStateMachine* >::toCpp((PyObject*)self);
    cppSelf->QStateMachine::stop();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyMethodDef SbkQStateMachine_methods[] = {
    {"addDefaultAnimation", (PyCFunction)SbkQStateMachineFunc_addDefaultAnimation, METH_O},
    {"addState", (PyCFunction)SbkQStateMachineFunc_addState, METH_O},
    {"beginMicrostep", (PyCFunction)SbkQStateMachineFunc_beginMicrostep, METH_O},
    {"beginSelectTransitions", (PyCFunction)SbkQStateMachineFunc_beginSelectTransitions, METH_O},
    {"cancelDelayedEvent", (PyCFunction)SbkQStateMachineFunc_cancelDelayedEvent, METH_O},
    {"clearError", (PyCFunction)SbkQStateMachineFunc_clearError, METH_NOARGS},
    {"configuration", (PyCFunction)SbkQStateMachineFunc_configuration, METH_NOARGS},
    {"defaultAnimations", (PyCFunction)SbkQStateMachineFunc_defaultAnimations, METH_NOARGS},
    {"endMicrostep", (PyCFunction)SbkQStateMachineFunc_endMicrostep, METH_O},
    {"endSelectTransitions", (PyCFunction)SbkQStateMachineFunc_endSelectTransitions, METH_O},
    {"error", (PyCFunction)SbkQStateMachineFunc_error, METH_NOARGS},
    {"errorString", (PyCFunction)SbkQStateMachineFunc_errorString, METH_NOARGS},
    {"event", (PyCFunction)SbkQStateMachineFunc_event, METH_O},
    {"eventFilter", (PyCFunction)SbkQStateMachineFunc_eventFilter, METH_VARARGS},
    {"globalRestorePolicy", (PyCFunction)SbkQStateMachineFunc_globalRestorePolicy, METH_NOARGS},
    {"isAnimated", (PyCFunction)SbkQStateMachineFunc_isAnimated, METH_NOARGS},
    {"isRunning", (PyCFunction)SbkQStateMachineFunc_isRunning, METH_NOARGS},
    {"onEntry", (PyCFunction)SbkQStateMachineFunc_onEntry, METH_O},
    {"onExit", (PyCFunction)SbkQStateMachineFunc_onExit, METH_O},
    {"postDelayedEvent", (PyCFunction)SbkQStateMachineFunc_postDelayedEvent, METH_VARARGS},
    {"postEvent", (PyCFunction)SbkQStateMachineFunc_postEvent, METH_VARARGS},
    {"removeDefaultAnimation", (PyCFunction)SbkQStateMachineFunc_removeDefaultAnimation, METH_O},
    {"removeState", (PyCFunction)SbkQStateMachineFunc_removeState, METH_O},
    {"setAnimated", (PyCFunction)SbkQStateMachineFunc_setAnimated, METH_O},
    {"setGlobalRestorePolicy", (PyCFunction)SbkQStateMachineFunc_setGlobalRestorePolicy, METH_O},
    {"start", (PyCFunction)SbkQStateMachineFunc_start, METH_NOARGS},
    {"stop", (PyCFunction)SbkQStateMachineFunc_stop, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQStateMachine_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QStateMachine",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QStateMachineWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQStateMachine_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQStateMachine_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtCore_QStateMachine_Error_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QStateMachine_Error_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QStateMachine_Error_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Error",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QStateMachine_Error_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QStateMachine_Error_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QStateMachine_Error_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QStateMachine_EventPriority_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QStateMachine_EventPriority_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QStateMachine_EventPriority_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "EventPriority",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QStateMachine_EventPriority_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QStateMachine_EventPriority_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QStateMachine_EventPriority_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}

static PyGetSetDef SbkPySide_QtCore_QStateMachine_RestorePolicy_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QStateMachine_RestorePolicy_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QStateMachine_RestorePolicy_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "RestorePolicy",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QStateMachine_RestorePolicy_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QStateMachine_RestorePolicy_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QStateMachine_RestorePolicy_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QStateMachine_WrappedEvent(PyObject*);
PyAPI_FUNC(void)
init_QStateMachine_SignalEvent(PyObject*);
PyAPI_FUNC(void)
init_QStateMachine(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQStateMachine_Type);

    SbkQStateMachine_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QSTATE_IDX];
    // Fill type discovery information
    SbkQStateMachine_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQStateMachine_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQStateMachine_Type));
    PyModule_AddObject(module, "QStateMachine",
        ((PyObject*)&SbkQStateMachine_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Error
    SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_ERROR_IDX] = &SbkPySide_QtCore_QStateMachine_Error_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QStateMachine_Error_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QStateMachine_Error_Type);
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
            "Error",((PyObject*)&SbkPySide_QtCore_QStateMachine_Error_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QStateMachine_Error_Type,
        (long) QStateMachine::NoError, "NoError");
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
        "NoError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QStateMachine_Error_Type.tp_dict,
        "NoError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QStateMachine_Error_Type,
        (long) QStateMachine::NoInitialStateError, "NoInitialStateError");
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
        "NoInitialStateError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QStateMachine_Error_Type.tp_dict,
        "NoInitialStateError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QStateMachine_Error_Type,
        (long) QStateMachine::NoDefaultStateInHistoryStateError, "NoDefaultStateInHistoryStateError");
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
        "NoDefaultStateInHistoryStateError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QStateMachine_Error_Type.tp_dict,
        "NoDefaultStateInHistoryStateError", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QStateMachine_Error_Type,
        (long) QStateMachine::NoCommonAncestorForTransitionError, "NoCommonAncestorForTransitionError");
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
        "NoCommonAncestorForTransitionError", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QStateMachine_Error_Type.tp_dict,
        "NoCommonAncestorForTransitionError", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStateMachine::Error");

    // init enum class: EventPriority
    SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_EVENTPRIORITY_IDX] = &SbkPySide_QtCore_QStateMachine_EventPriority_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QStateMachine_EventPriority_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QStateMachine_EventPriority_Type);
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
            "EventPriority",((PyObject*)&SbkPySide_QtCore_QStateMachine_EventPriority_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QStateMachine_EventPriority_Type,
        (long) QStateMachine::NormalPriority, "NormalPriority");
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
        "NormalPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QStateMachine_EventPriority_Type.tp_dict,
        "NormalPriority", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QStateMachine_EventPriority_Type,
        (long) QStateMachine::HighPriority, "HighPriority");
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
        "HighPriority", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QStateMachine_EventPriority_Type.tp_dict,
        "HighPriority", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStateMachine::EventPriority");

    // init enum class: RestorePolicy
    SbkPySide_QtCoreTypes[SBK_QSTATEMACHINE_RESTOREPOLICY_IDX] = &SbkPySide_QtCore_QStateMachine_RestorePolicy_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QStateMachine_RestorePolicy_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QStateMachine_RestorePolicy_Type);
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
            "RestorePolicy",((PyObject*)&SbkPySide_QtCore_QStateMachine_RestorePolicy_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QStateMachine_RestorePolicy_Type,
        (long) QStateMachine::DontRestoreProperties, "DontRestoreProperties");
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
        "DontRestoreProperties", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QStateMachine_RestorePolicy_Type.tp_dict,
        "DontRestoreProperties", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QStateMachine_RestorePolicy_Type,
        (long) QStateMachine::RestoreProperties, "RestoreProperties");
    PyDict_SetItemString(SbkQStateMachine_Type.super.ht_type.tp_dict,
        "RestoreProperties", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QStateMachine_RestorePolicy_Type.tp_dict,
        "RestoreProperties", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QStateMachine::RestorePolicy");

    Shiboken::TypeResolver::createObjectTypeResolver<QStateMachine >("QStateMachine*");
    Shiboken::TypeResolver::createObjectTypeResolver<QStateMachine >(typeid(QStateMachine).name());
    init_QStateMachine_WrappedEvent(SbkQStateMachine_Type.super.ht_type.tp_dict);
    init_QStateMachine_SignalEvent(SbkQStateMachine_Type.super.ht_type.tp_dict);
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

