/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qpoint_wrapper.h"

// Extra includes
#include <qpoint.h>

using namespace Shiboken;

static int
SbkQPoint_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QPoint* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QPoint", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QPoint()
        cptr = new QPoint();
    } else if (numArgs == 2 && PyNumber_Check(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // QPoint(int,int)
        cptr = new QPoint(cpp_arg0, cpp_arg1);
    } else if (numArgs == 1 && PyObject_Check(pyargs[0])) {
        // QPoint(PyObject*)
        // Begin code injection
        
        QPoint ptr = Shiboken::Converter<QPoint >::toCpp(pyargs[0]);
        cptr = new QPoint(ptr.x(), ptr.y());
        
        // End of code injection

    } else goto SbkQPoint_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQPoint_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQPoint_Init_TypeError:
        const char* overloads[] = {"", "PyObject", "int, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QPoint", overloads);
        return -1;
}

static PyObject*
SbkQPointFunc_isNull(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isNull()const
    QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QPoint::isNull();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPointFunc_manhattanLength(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // manhattanLength()const
    QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPoint::manhattanLength();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPointFunc_setX(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setX(int)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        cppSelf->QPoint::setX(cpp_arg0);
    } else goto SbkQPointFunc_setX_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPointFunc_setX_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.setX", overloads);
        return 0;
}

static PyObject*
SbkQPointFunc_setY(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // setY(int)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        cppSelf->QPoint::setY(cpp_arg0);
    } else goto SbkQPointFunc_setY_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQPointFunc_setY_TypeError:
        const char* overloads[] = {"int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.setY", overloads);
        return 0;
}

static PyObject*
SbkQPointFunc_x(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // x()const
    QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPoint::x();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPointFunc_y(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // y()const
    QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QPoint::y();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQPoint_methods[] = {
    {"isNull", (PyCFunction)SbkQPointFunc_isNull, METH_NOARGS},
    {"manhattanLength", (PyCFunction)SbkQPointFunc_manhattanLength, METH_NOARGS},
    {"setX", (PyCFunction)SbkQPointFunc_setX, METH_O},
    {"setY", (PyCFunction)SbkQPointFunc_setY, METH_O},
    {"x", (PyCFunction)SbkQPointFunc_x, METH_NOARGS},
    {"y", (PyCFunction)SbkQPointFunc_y, METH_NOARGS},
    {0} // Sentinel
};

static PyObject*
SbkQPointFunc___mul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPoint_Check(arg) && !SbkQPoint_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(QPoint,qreal)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        const QPoint cpp_result = (*cppSelf) * cpp_arg0;
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else if (isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*(qreal,QPoint) [reverse operator]
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        const QPoint cpp_result = cpp_arg0 * (*cppSelf);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQPointFunc___mul___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPointFunc___mul___TypeError:
        const char* overloads[] = {"float", "float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.__mul__", overloads);
        return 0;
}

static PyObject*
SbkQPointFunc___imul__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPoint_Check(arg) && !SbkQPoint_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator*=(qreal)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        (*cppSelf) *= cpp_arg0;
    } else goto SbkQPointFunc___imul___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPointFunc___imul___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.__imul__", overloads);
        return 0;
}

static PyObject*
SbkQPointFunc___add__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPoint_Check(arg) && !SbkQPoint_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // operator+(QPoint,QPoint)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        const QPoint cpp_result = (*cppSelf) + (*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQPointFunc___add___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPointFunc___add___TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.__add__", overloads);
        return 0;
}

static PyObject*
SbkQPointFunc___iadd__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPoint_Check(arg) && !SbkQPoint_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // operator+=(QPoint)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        (*cppSelf) += (*cpp_arg0);
    } else goto SbkQPointFunc___iadd___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPointFunc___iadd___TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.__iadd__", overloads);
        return 0;
}

static PyObject*
SbkQPointFunc___neg__(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // operator-(QPoint)
    QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
    const QPoint cpp_result = - (*cppSelf);
    py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQPointFunc___sub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPoint_Check(arg) && !SbkQPoint_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // operator-(QPoint,QPoint)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        const QPoint cpp_result = (*cppSelf) - (*cpp_arg0);
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQPointFunc___sub___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPointFunc___sub___TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.__sub__", overloads);
        return 0;
}

static PyObject*
SbkQPointFunc___isub__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPoint_Check(arg) && !SbkQPoint_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && Shiboken::Converter<QPoint& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QPoint > cpp_arg0_auto_ptr;
        QPoint* cpp_arg0 = Shiboken::Converter<QPoint* >::toCpp(arg);
        if (!Shiboken::Converter<QPoint& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QPoint >(cpp_arg0);
        // operator-=(QPoint)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        (*cppSelf) -= (*cpp_arg0);
    } else goto SbkQPointFunc___isub___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPointFunc___isub___TypeError:
        const char* overloads[] = {"PySide.QtCore.QPoint", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.__isub__", overloads);
        return 0;
}

static PyObject*
SbkQPointFunc___div__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPoint_Check(arg) && !SbkQPoint_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/(QPoint,qreal)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        const QPoint cpp_result = (*cppSelf) / cpp_arg0;
        py_result = Shiboken::Converter<QPoint >::toPython(cpp_result);
    } else goto SbkQPointFunc___div___TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQPointFunc___div___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.__div__", overloads);
        return 0;
}

static PyObject*
SbkQPointFunc___idiv__(PyObject* self, PyObject* arg)
{
    // FIXME: Optimize this: Only do this when there is a reverse operator in this function group
    bool isReverse = SbkQPoint_Check(arg) && !SbkQPoint_Check(self);
    if (isReverse)
        std::swap(self, arg);

    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (!isReverse && PyNumber_Check(arg)) {
        qreal cpp_arg0 = Shiboken::Converter<qreal >::toCpp(arg);
        // operator/=(qreal)
        QPoint* cppSelf = Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);
        (*cppSelf) /= cpp_arg0;
    } else goto SbkQPointFunc___idiv___TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
        Py_INCREF(self);
    return self;
;

    SbkQPointFunc___idiv___TypeError:
        const char* overloads[] = {"float", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QPoint.__idiv__", overloads);
        return 0;
}

// type has number operators
static PyNumberMethods SbkQPoint_as_number = {
    /*nb_add*/                  (binaryfunc)SbkQPointFunc___add__,
    /*nb_subtract*/             (binaryfunc)SbkQPointFunc___sub__,
    /*nb_multiply*/             (binaryfunc)SbkQPointFunc___mul__,
    /*nb_divide*/               (binaryfunc)SbkQPointFunc___div__,
    /*nb_remainder*/            (binaryfunc)0,
    /*nb_divmod*/               0,
    /*nb_power*/                0,
    /*nb_negative*/             (unaryfunc)SbkQPointFunc___neg__,
    /*nb_positive*/             (unaryfunc)0,
    /*nb_absolute*/             0,
    /*nb_nonzero*/              0,
    /*nb_invert*/               (unaryfunc)0,
    /*nb_lshift*/               (binaryfunc)0,
    /*nb_rshift*/               (binaryfunc)0,
    /*nb_and*/                  (binaryfunc)0,
    /*nb_xor*/                  (binaryfunc)0,
    /*nb_or*/                   (binaryfunc)0,
    /*nb_coerce*/               0,
    /*nb_int*/                  0,
    /*nb_long*/                 0,
    /*nb_float*/                0,
    /*nb_oct*/                  0,
    /*nb_hex*/                  0,
    /*nb_inplace_add*/          (binaryfunc)SbkQPointFunc___iadd__,
    /*nb_inplace_subtract*/     (binaryfunc)SbkQPointFunc___isub__,
    /*nb_inplace_multiply*/     (binaryfunc)SbkQPointFunc___imul__,
    /*nb_inplace_divide*/       (binaryfunc)SbkQPointFunc___idiv__,
    /*nb_inplace_remainder*/    (binaryfunc)0,
    /*nb_inplace_power*/        0,
    /*nb_inplace_lshift*/       (binaryfunc)0,
    /*nb_inplace_rshift*/       (binaryfunc)0,
    /*nb_inplace_and*/          (binaryfunc)0,
    /*nb_inplace_xor*/          (binaryfunc)0,
    /*nb_inplace_or*/           (binaryfunc)0,
    /*nb_floor_divide*/         0,
    /*nb_true_divide*/          0,
    /*nb_inplace_floor_divide*/ 0,
    /*nb_inplace_true_divide*/  0,
    /*nb_index*/                0
};

// Rich comparison
static PyObject*
SbkQPoint_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QPoint& cpp_self = *Shiboken::Converter<QPoint* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QPoint& >::isConvertible(other)) {
                QPoint* cpp_other = Shiboken::Converter<QPoint* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QPoint >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPoint > cpp_other_auto_ptr;
                QPoint* cpp_other = Shiboken::Converter<QPoint* >::toCpp(other);
                if (!Shiboken::Converter<QPoint >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPoint >(cpp_other);
                result = (cpp_self != (*cpp_other));
            } else goto SbkQPoint_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QPoint& >::isConvertible(other)) {
                QPoint* cpp_other = Shiboken::Converter<QPoint* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QPoint >::isConvertible(other)) {
                if (Shiboken::cppObjectIsInvalid(other))
                    return 0;
                std::auto_ptr<QPoint > cpp_other_auto_ptr;
                QPoint* cpp_other = Shiboken::Converter<QPoint* >::toCpp(other);
                if (!Shiboken::Converter<QPoint >::isConvertible(other))
                    cpp_other_auto_ptr = std::auto_ptr<QPoint >(cpp_other);
                result = (cpp_self == (*cpp_other));
            } else goto SbkQPoint_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQPoint_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQPoint_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QPoint",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QPoint >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        &SbkQPoint_as_number,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQPoint_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQPoint_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQPoint_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QPoint(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QPOINT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQPoint_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQPoint_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQPoint_Type));
    PyModule_AddObject(module, "QPoint",
        ((PyObject*)&SbkQPoint_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QPoint >("QPoint");
    Shiboken::TypeResolver::createValueTypeResolver<QPoint >(typeid(QPoint).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

