/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qmetaproperty_wrapper.h"

// Extra includes
#include <qmetaobject.h>
#include <qobject.h>
#include <qvariant.h>

using namespace Shiboken;

static int
SbkQMetaProperty_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QMetaProperty* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);
    // QMetaProperty()
    cptr = new QMetaProperty();

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;
}

static PyObject*
SbkQMetaPropertyFunc_enumerator(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // enumerator()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    QMetaEnum cpp_result = cppSelf->QMetaProperty::enumerator();
    py_result = Shiboken::Converter<QMetaEnum >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_hasNotifySignal(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasNotifySignal()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::hasNotifySignal();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_hasStdCppSet(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // hasStdCppSet()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::hasStdCppSet();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_isConstant(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isConstant()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::isConstant();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_isDesignable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // isDesignable(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isDesignable();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // isDesignable(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isDesignable(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMetaPropertyFunc_isDesignable_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaPropertyFunc_isDesignable_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaProperty.isDesignable", overloads);
        return 0;
}

static PyObject*
SbkQMetaPropertyFunc_isEditable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // isEditable(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isEditable();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // isEditable(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isEditable(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMetaPropertyFunc_isEditable_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaPropertyFunc_isEditable_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaProperty.isEditable", overloads);
        return 0;
}

static PyObject*
SbkQMetaPropertyFunc_isEnumType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isEnumType()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::isEnumType();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_isFinal(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFinal()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::isFinal();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_isFlagType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isFlagType()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::isFlagType();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_isReadable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isReadable()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::isReadable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_isResettable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isResettable()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::isResettable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_isScriptable(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // isScriptable(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isScriptable();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // isScriptable(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isScriptable(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMetaPropertyFunc_isScriptable_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaPropertyFunc_isScriptable_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaProperty.isScriptable", overloads);
        return 0;
}

static PyObject*
SbkQMetaPropertyFunc_isStored(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // isStored(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isStored();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // isStored(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isStored(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMetaPropertyFunc_isStored_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaPropertyFunc_isStored_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaProperty.isStored", overloads);
        return 0;
}

static PyObject*
SbkQMetaPropertyFunc_isUser(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // isUser(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isUser();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // isUser(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::isUser(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMetaPropertyFunc_isUser_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaPropertyFunc_isUser_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaProperty.isUser", overloads);
        return 0;
}

static PyObject*
SbkQMetaPropertyFunc_isValid(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isValid()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::isValid();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_isWritable(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isWritable()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QMetaProperty::isWritable();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    const char * cpp_result = cppSelf->QMetaProperty::name();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_notifySignalIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // notifySignalIndex()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaProperty::notifySignalIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_propertyIndex(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // propertyIndex()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaProperty::propertyIndex();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_read(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // read(const QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        QVariant cpp_result = cppSelf->QMetaProperty::read(cpp_arg0);
        py_result = Shiboken::Converter<QVariant >::toPython(cpp_result);
    } else goto SbkQMetaPropertyFunc_read_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaPropertyFunc_read_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaProperty.read", overloads);
        return 0;
}

static PyObject*
SbkQMetaPropertyFunc_reset(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QObject* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(arg);
        // reset(QObject*)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::reset(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMetaPropertyFunc_reset_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaPropertyFunc_reset_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QMetaProperty.reset", overloads);
        return 0;
}

static PyObject*
SbkQMetaPropertyFunc_type(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // type()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    QVariant::Type cpp_result = cppSelf->QMetaProperty::type();
    py_result = Shiboken::Converter<QVariant::Type >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_typeName(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // typeName()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    const char * cpp_result = cppSelf->QMetaProperty::typeName();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_userType(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // userType()const
    QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QMetaProperty::userType();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQMetaPropertyFunc_write(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "write", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<QVariant& >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QVariant > cpp_arg1_auto_ptr;
        QVariant* cpp_arg1 = Shiboken::Converter<QVariant* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QVariant& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QVariant >(cpp_arg1);
        // write(QObject*,QVariant)const
        QMetaProperty* cppSelf = Shiboken::Converter<QMetaProperty* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QMetaProperty::write(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQMetaPropertyFunc_write_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQMetaPropertyFunc_write_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QVariant", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QMetaProperty.write", overloads);
        return 0;
}

static PyMethodDef SbkQMetaProperty_methods[] = {
    {"enumerator", (PyCFunction)SbkQMetaPropertyFunc_enumerator, METH_NOARGS},
    {"hasNotifySignal", (PyCFunction)SbkQMetaPropertyFunc_hasNotifySignal, METH_NOARGS},
    {"hasStdCppSet", (PyCFunction)SbkQMetaPropertyFunc_hasStdCppSet, METH_NOARGS},
    {"isConstant", (PyCFunction)SbkQMetaPropertyFunc_isConstant, METH_NOARGS},
    {"isDesignable", (PyCFunction)SbkQMetaPropertyFunc_isDesignable, METH_NOARGS|METH_O},
    {"isEditable", (PyCFunction)SbkQMetaPropertyFunc_isEditable, METH_NOARGS|METH_O},
    {"isEnumType", (PyCFunction)SbkQMetaPropertyFunc_isEnumType, METH_NOARGS},
    {"isFinal", (PyCFunction)SbkQMetaPropertyFunc_isFinal, METH_NOARGS},
    {"isFlagType", (PyCFunction)SbkQMetaPropertyFunc_isFlagType, METH_NOARGS},
    {"isReadable", (PyCFunction)SbkQMetaPropertyFunc_isReadable, METH_NOARGS},
    {"isResettable", (PyCFunction)SbkQMetaPropertyFunc_isResettable, METH_NOARGS},
    {"isScriptable", (PyCFunction)SbkQMetaPropertyFunc_isScriptable, METH_NOARGS|METH_O},
    {"isStored", (PyCFunction)SbkQMetaPropertyFunc_isStored, METH_NOARGS|METH_O},
    {"isUser", (PyCFunction)SbkQMetaPropertyFunc_isUser, METH_NOARGS|METH_O},
    {"isValid", (PyCFunction)SbkQMetaPropertyFunc_isValid, METH_NOARGS},
    {"isWritable", (PyCFunction)SbkQMetaPropertyFunc_isWritable, METH_NOARGS},
    {"name", (PyCFunction)SbkQMetaPropertyFunc_name, METH_NOARGS},
    {"notifySignalIndex", (PyCFunction)SbkQMetaPropertyFunc_notifySignalIndex, METH_NOARGS},
    {"propertyIndex", (PyCFunction)SbkQMetaPropertyFunc_propertyIndex, METH_NOARGS},
    {"read", (PyCFunction)SbkQMetaPropertyFunc_read, METH_O},
    {"reset", (PyCFunction)SbkQMetaPropertyFunc_reset, METH_O},
    {"type", (PyCFunction)SbkQMetaPropertyFunc_type, METH_NOARGS},
    {"typeName", (PyCFunction)SbkQMetaPropertyFunc_typeName, METH_NOARGS},
    {"userType", (PyCFunction)SbkQMetaPropertyFunc_userType, METH_NOARGS},
    {"write", (PyCFunction)SbkQMetaPropertyFunc_write, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQMetaProperty_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QMetaProperty",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QMetaProperty >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQMetaProperty_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQMetaProperty_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QMetaProperty(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QMETAPROPERTY_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQMetaProperty_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQMetaProperty_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQMetaProperty_Type));
    PyModule_AddObject(module, "QMetaProperty",
        ((PyObject*)&SbkQMetaProperty_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QMetaProperty >("QMetaProperty");
    Shiboken::TypeResolver::createValueTypeResolver<QMetaProperty >(typeid(QMetaProperty).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

