/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qlatin1string_wrapper.h"

// Extra includes
#include <qstring.h>

using namespace Shiboken;

static int
SbkQLatin1String_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QLatin1String* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QLatin1String", 1, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 1 && Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        // QLatin1String(const char*)
        cptr = new QLatin1String(cpp_arg0);
    } else goto SbkQLatin1String_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQLatin1String_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQLatin1String_Init_TypeError:
        const char* overloads[] = {"str", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QLatin1String", overloads);
        return -1;
}

static PyObject*
SbkQLatin1StringFunc_latin1(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // latin1()const
    QLatin1String* cppSelf = Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)self);
    const char * cpp_result = cppSelf->QLatin1String::latin1();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQLatin1String_methods[] = {
    {"latin1", (PyCFunction)SbkQLatin1StringFunc_latin1, METH_NOARGS},
    {0} // Sentinel
};

// Rich comparison
static PyObject*
SbkQLatin1String_richcompare(PyObject* self, PyObject* other, int op)
{
    bool result;
    QLatin1String& cpp_self = *Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)self);

    switch (op) {
        case Py_NE:
            if (Shiboken::Converter<QLatin1String& >::isConvertible(other)) {
                QLatin1String* cpp_other = Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<QStringRef& >::isConvertible(other)) {
                QStringRef* cpp_other = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)other);
                result = (cpp_self != (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self != cpp_other);
            } else goto SbkQLatin1String_RichComparison_TypeError;

            break;
        case Py_LT:
            if (Shiboken::Converter<QLatin1String& >::isConvertible(other)) {
                QLatin1String* cpp_other = Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self < (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self < cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self < cpp_other);
            } else goto SbkQLatin1String_RichComparison_TypeError;

            break;
        case Py_LE:
            if (Shiboken::Converter<QLatin1String& >::isConvertible(other)) {
                QLatin1String* cpp_other = Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)other);
                result = (cpp_self <= (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self <= (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self <= cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self <= cpp_other);
            } else goto SbkQLatin1String_RichComparison_TypeError;

            break;
        case Py_EQ:
            if (Shiboken::Converter<QLatin1String& >::isConvertible(other)) {
                QLatin1String* cpp_other = Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<QStringRef& >::isConvertible(other)) {
                QStringRef* cpp_other = Shiboken::Converter<QStringRef* >::toCpp((PyObject*)other);
                result = (cpp_self == (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self == cpp_other);
            } else goto SbkQLatin1String_RichComparison_TypeError;

            break;
        case Py_GT:
            if (Shiboken::Converter<QLatin1String& >::isConvertible(other)) {
                QLatin1String* cpp_other = Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)other);
                result = (cpp_self > (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self > (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self > cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self > cpp_other);
            } else goto SbkQLatin1String_RichComparison_TypeError;

            break;
        case Py_GE:
            if (Shiboken::Converter<QLatin1String& >::isConvertible(other)) {
                QLatin1String* cpp_other = Shiboken::Converter<QLatin1String* >::toCpp((PyObject*)other);
                result = (cpp_self >= (*cpp_other));
            } else if (Shiboken::Converter<QString& >::isConvertible(other)) {
                QString* cpp_other = Shiboken::Converter<QString* >::toCpp((PyObject*)other);
                result = (cpp_self >= (*cpp_other));
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self >= cpp_other);
            } else if (Shiboken::Converter<const char * >::isConvertible(other)) {
                const char * cpp_other = Shiboken::Converter<const char * >::toCpp(other);
                result = (cpp_self >= cpp_other);
            } else goto SbkQLatin1String_RichComparison_TypeError;

            break;
        default:
            PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
            return 0;
    }

    if (result)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;

    SbkQLatin1String_RichComparison_TypeError:
        Py_RETURN_FALSE;
}

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQLatin1String_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QLatin1String",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QLatin1String >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      SbkQLatin1String_richcompare,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQLatin1String_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQLatin1String_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QLatin1String(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QLATIN1STRING_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQLatin1String_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQLatin1String_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQLatin1String_Type));
    PyModule_AddObject(module, "QLatin1String",
        ((PyObject*)&SbkQLatin1String_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QLatin1String >("QLatin1String");
    Shiboken::TypeResolver::createValueTypeResolver<QLatin1String >(typeid(QLatin1String).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

