/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qgenericargument_wrapper.h"

// Extra includes

using namespace Shiboken;

static int
SbkQGenericArgument_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QGenericArgument* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QGenericArgument", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QGenericArgument(const char*,const void*)
        cptr = new QGenericArgument();
    } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[0])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // QGenericArgument(const char*,const void*)
            cptr = new QGenericArgument(cpp_arg0);
        } else if (Shiboken::Converter<void * >::isConvertible(pyargs[1])) {
            const void * cpp_arg1 = Shiboken::Converter<const void * >::toCpp(pyargs[1]);
            // QGenericArgument(const char*,const void*)
            cptr = new QGenericArgument(cpp_arg0, cpp_arg1);
        } else goto SbkQGenericArgument_Init_TypeError;
    } else goto SbkQGenericArgument_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQGenericArgument_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQGenericArgument_Init_TypeError:
        const char* overloads[] = {"str = None, void = 0", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QGenericArgument", overloads);
        return -1;
}

static PyObject*
SbkQGenericArgumentFunc_data(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // data()const
    QGenericArgument* cppSelf = Shiboken::Converter<QGenericArgument* >::toCpp((PyObject*)self);
    void * cpp_result = cppSelf->QGenericArgument::data();
    py_result = Shiboken::Converter<void * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQGenericArgumentFunc_name(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // name()const
    QGenericArgument* cppSelf = Shiboken::Converter<QGenericArgument* >::toCpp((PyObject*)self);
    const char * cpp_result = cppSelf->QGenericArgument::name();
    py_result = Shiboken::Converter<const char * >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyMethodDef SbkQGenericArgument_methods[] = {
    {"data", (PyCFunction)SbkQGenericArgumentFunc_data, METH_NOARGS},
    {"name", (PyCFunction)SbkQGenericArgumentFunc_name, METH_NOARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQGenericArgument_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QGenericArgument",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QGenericArgument >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQGenericArgument_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             reinterpret_cast<PyTypeObject*>(&Shiboken::SbkBaseWrapper_Type),
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQGenericArgument_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QGenericArgument(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QGENERICARGUMENT_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQGenericArgument_Type);

    if (PyType_Ready((PyTypeObject*)&SbkQGenericArgument_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQGenericArgument_Type));
    PyModule_AddObject(module, "QGenericArgument",
        ((PyObject*)&SbkQGenericArgument_Type));

    Shiboken::TypeResolver::createValueTypeResolver<QGenericArgument >("QGenericArgument");
    Shiboken::TypeResolver::createValueTypeResolver<QGenericArgument >(typeid(QGenericArgument).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

