/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include "pyside_qtcore_python.h"

#include "qfsfileengine_wrapper.h"

// Extra includes
#include <QDateTime>
#include <QList>
#include <qabstractfileengine.h>
#include <qdatetime.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qstringlist.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QFSFileEngineWrapper::QFSFileEngineWrapper() : QFSFileEngine() {
    // ... middle
}

QFSFileEngineWrapper::QFSFileEngineWrapper(const QString & file) : QFSFileEngine(file) {
    // ... middle
}

bool QFSFileEngineWrapper::caseSensitive() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "caseSensitive"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::caseSensitive();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.caseSensitive");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::close()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "close"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::close();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.close");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::copy(const QString & newName)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "copy"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::copy(newName);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(newName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.copy");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QStringList QFSFileEngineWrapper::entryList(QFlags<QDir::Filter> filters, const QStringList & filterNames) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "entryList"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::entryList(filters, filterNames);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QFlags<QDir::Filter> >::toPython(filters),
        Shiboken::Converter<QStringList& >::toPython(filterNames)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QStringList();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QStringList >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.entryList");
        return QStringList()        ;
    }
    QStringList cpp_result(Shiboken::Converter<QStringList >::toCpp(py_result));
    return cpp_result;
}

QFlags<QAbstractFileEngine::FileFlag> QFSFileEngineWrapper::fileFlags(QFlags<QAbstractFileEngine::FileFlag> type) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fileFlags"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::fileFlags(type);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<QAbstractFileEngine::FileFlag> >::toPython(type)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QFlags<QAbstractFileEngine::FileFlag>();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QFlags<QAbstractFileEngine::FileFlag> >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.fileFlags");
        return QFlags<QAbstractFileEngine::FileFlag>()        ;
    }
    QFlags<QAbstractFileEngine::FileFlag> cpp_result(Shiboken::Converter<QFlags<QAbstractFileEngine::FileFlag> >::toCpp(py_result));
    return cpp_result;
}

QString QFSFileEngineWrapper::fileName(QAbstractFileEngine::FileName file) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fileName"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::fileName(file);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractFileEngine::FileName >::toPython(file)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.fileName");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

QDateTime QFSFileEngineWrapper::fileTime(QAbstractFileEngine::FileTime time) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "fileTime"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::fileTime(time);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractFileEngine::FileTime >::toPython(time)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QDateTime();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QDateTime >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.fileTime");
        return QDateTime()        ;
    }
    QDateTime cpp_result(Shiboken::Converter<QDateTime >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::flush()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "flush"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::flush();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.flush");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

int QFSFileEngineWrapper::handle() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "handle"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::handle();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return int(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.handle");
        return int(0)        ;
    }
    int cpp_result(Shiboken::Converter<int >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::isRelativePath() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isRelativePath"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::isRelativePath();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.isRelativePath");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::isSequential() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "isSequential"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::isSequential();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.isSequential");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::link(const QString & newName)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "link"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::link(newName);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(newName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.link");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::mkdir(const QString & dirName, bool createParentDirectories) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "mkdir"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::mkdir(dirName, createParentDirectories);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(dirName),
        Shiboken::Converter<bool >::toPython(createParentDirectories)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.mkdir");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::open(QFlags<QIODevice::OpenModeFlag> openMode)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "open"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::open(openMode);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toPython(openMode)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.open");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

QString QFSFileEngineWrapper::owner(QAbstractFileEngine::FileOwner arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "owner"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::owner(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractFileEngine::FileOwner >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return QString();
    }
    // Check return type
    bool typeIsValid = Shiboken::Converter<QString >::isConvertible(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.owner");
        return QString()        ;
    }
    QString cpp_result(Shiboken::Converter<QString >::toCpp(py_result));
    return cpp_result;
}

uint QFSFileEngineWrapper::ownerId(QAbstractFileEngine::FileOwner arg__1) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "ownerId"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::ownerId(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractFileEngine::FileOwner >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return uint(0);
    }
    // Check return type
    bool typeIsValid = PyInt_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.ownerId");
        return uint(0)        ;
    }
    uint cpp_result(Shiboken::Converter<unsigned int >::toCpp(py_result));
    return cpp_result;
}

qint64 QFSFileEngineWrapper::pos() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "pos"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::pos();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.pos");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::remove()
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "remove"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::remove();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.remove");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::rename(const QString & newName)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rename"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::rename(newName);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(newName)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.rename");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::rmdir(const QString & dirName, bool recurseParentDirectories) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "rmdir"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::rmdir(dirName, recurseParentDirectories);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QString& >::toPython(dirName),
        Shiboken::Converter<bool >::toPython(recurseParentDirectories)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.rmdir");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::seek(qint64 arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "seek"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::seek(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.seek");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

void QFSFileEngineWrapper::setFileName(const QString & file)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setFileName"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::setFileName(file);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QString& >::toPython(file)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QFSFileEngineWrapper::setPermissions(uint perms)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setPermissions"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::setPermissions(perms);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(I)",
        Shiboken::Converter<unsigned int >::toPython(perms)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.setPermissions");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::setSize(qint64 size)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "setSize"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::setSize(size);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(L)",
        Shiboken::Converter<long long >::toPython(size)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.setSize");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QFSFileEngineWrapper::size() const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "size"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::size();
    }

    Shiboken::AutoDecRef pyargs(PyTuple_New(0));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.size");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

bool QFSFileEngineWrapper::supportsExtension(QAbstractFileEngine::Extension extension) const
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "supportsExtension"));
    if (py_override.isNull()) {
        return this->QFSFileEngine::supportsExtension(extension);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QAbstractFileEngine::Extension >::toPython(extension)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.supportsExtension");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

qint64 QFSFileEngineWrapper::write(const char * data, qint64 len)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "write"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QFSFileEngine::write(data, len);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(zL)",
        data,
        Shiboken::Converter<long long >::toPython(len)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return qint64(0);
    }
    // Check return type
    bool typeIsValid = PyLong_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFSFileEngine.write");
        return qint64(0)        ;
    }
    qint64 cpp_result(Shiboken::Converter<long long >::toCpp(py_result));
    return cpp_result;
}

QFSFileEngineWrapper::~QFSFileEngineWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
}

// Target ---------------------------------------------------------

static int
SbkQFSFileEngine_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFSFileEngineWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0};

    if (!PyArg_UnpackTuple(args, "QFSFileEngine", 0, 1, &(pyargs[0])))
        return -1;

    if (numArgs == 0) {
        // QFSFileEngine()
        cptr = new QFSFileEngineWrapper();
    } else if (numArgs == 1 && Shiboken::Converter<QString& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // QFSFileEngine(QString)
        cptr = new QFSFileEngineWrapper(*cpp_arg0);
    } else goto SbkQFSFileEngine_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFSFileEngine_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQFSFileEngine_Init_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFSFileEngine", overloads);
        return -1;
}

static PyObject*
SbkQFSFileEngineFunc_beginEntryList(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "beginEntryList", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && SbkPySide_QtCore_QDir_Filter_Check(pyargs[0]) && Shiboken::Converter<QStringList& >::isConvertible(pyargs[1])) {
        QFlags<QDir::Filter> cpp_arg0 = Shiboken::Converter<QFlags<QDir::Filter> >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
        QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
        // beginEntryList(QFlags<QDir::Filter>,QStringList)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        QAbstractFileEngineIterator * cpp_result = cppSelf->QFSFileEngine::beginEntryList(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QAbstractFileEngineIterator* >::toPython(cpp_result);
        Shiboken::setParent(self, py_result);
    } else goto SbkQFSFileEngineFunc_beginEntryList_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_beginEntryList_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir.Filters, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFSFileEngine.beginEntryList", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_caseSensitive(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // caseSensitive()const
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFSFileEngine::caseSensitive();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_close(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // close()
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QFSFileEngine::close();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_copy(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // copy(QString)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QFSFileEngine::copy(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_copy_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_copy_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.copy", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_currentPath(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // currentPath(QString)
        QString cpp_result = QFSFileEngine::currentPath();
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // currentPath(QString)
        QString cpp_result = QFSFileEngine::currentPath(*cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_currentPath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_currentPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString = QString()", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.currentPath", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_drives(PyObject* self)
{
    PyObject* py_result = 0;

    // drives()
    QList<QFileInfo > cpp_result = QFSFileEngine::drives();
    py_result = Shiboken::Converter<QList<QFileInfo > >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_endEntryList(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // endEntryList()
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    QAbstractFileEngineIterator * cpp_result = cppSelf->QFSFileEngine::endEntryList();
    py_result = Shiboken::Converter<QAbstractFileEngineIterator* >::toPython(cpp_result);
    Shiboken::setParent(self, py_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_entryList(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "entryList", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && SbkPySide_QtCore_QDir_Filter_Check(pyargs[0]) && Shiboken::Converter<QStringList& >::isConvertible(pyargs[1])) {
        QFlags<QDir::Filter> cpp_arg0 = Shiboken::Converter<QFlags<QDir::Filter> >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        std::auto_ptr<QStringList > cpp_arg1_auto_ptr;
        QStringList* cpp_arg1 = Shiboken::Converter<QStringList* >::toCpp(pyargs[1]);
        if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[1]))
            cpp_arg1_auto_ptr = std::auto_ptr<QStringList >(cpp_arg1);
        // entryList(QFlags<QDir::Filter>,QStringList)const
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        QStringList cpp_result = cppSelf->QFSFileEngine::entryList(cpp_arg0, *cpp_arg1);
        py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_entryList_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_entryList_TypeError:
        const char* overloads[] = {"PySide.QtCore.QDir.Filters, PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFSFileEngine.entryList", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_fileFlags(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (SbkPySide_QtCore_QAbstractFileEngine_FileFlag_Check(arg)) {
        QFlags<QAbstractFileEngine::FileFlag> cpp_arg0 = Shiboken::Converter<QFlags<QAbstractFileEngine::FileFlag> >::toCpp(arg);
        // fileFlags(QFlags<QAbstractFileEngine::FileFlag>)const
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        QFlags<QAbstractFileEngine::FileFlag> cpp_result = cppSelf->QFSFileEngine::fileFlags(cpp_arg0);
        py_result = Shiboken::Converter<QFlags<QAbstractFileEngine::FileFlag> >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_fileFlags_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_fileFlags_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractFileEngine.FileFlags", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.fileFlags", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_fileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractFileEngine::FileName >::isConvertible(arg)) {
        QAbstractFileEngine::FileName cpp_arg0 = Shiboken::Converter<QAbstractFileEngine::FileName >::toCpp(arg);
        // fileName(QAbstractFileEngine::FileName)const
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QFSFileEngine::fileName(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_fileName_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_fileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractFileEngine.FileName", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.fileName", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_fileTime(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractFileEngine::FileTime >::isConvertible(arg)) {
        QAbstractFileEngine::FileTime cpp_arg0 = Shiboken::Converter<QAbstractFileEngine::FileTime >::toCpp(arg);
        // fileTime(QAbstractFileEngine::FileTime)const
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        QDateTime cpp_result = cppSelf->QFSFileEngine::fileTime(cpp_arg0);
        py_result = Shiboken::Converter<QDateTime >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_fileTime_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_fileTime_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractFileEngine.FileTime", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.fileTime", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_flush(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // flush()
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QFSFileEngine::flush();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_handle(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // handle()const
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    int cpp_result = cppSelf->QFSFileEngine::handle();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_homePath(PyObject* self)
{
    PyObject* py_result = 0;

    // homePath()
    QString cpp_result = QFSFileEngine::homePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_isRelativePath(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isRelativePath()const
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFSFileEngine::isRelativePath();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_isSequential(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // isSequential()const
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    bool cpp_result = cppSelf->QFSFileEngine::isSequential();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_link(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // link(QString)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QFSFileEngine::link(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_link_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_link_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.link", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_mkdir(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "mkdir", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // mkdir(QString,bool)const
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QFSFileEngine::mkdir(*cpp_arg0, cpp_arg1);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_mkdir_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_mkdir_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFSFileEngine.mkdir", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_open(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "open", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (SbkPySide_QtCore_QIODevice_OpenModeFlag_Check(pyargs[0])) {
        QFlags<QIODevice::OpenModeFlag> cpp_arg0 = Shiboken::Converter<QFlags<QIODevice::OpenModeFlag> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // open(QFlags<QIODevice::OpenModeFlag>)
            QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
            thread_state_saver.save();
            bool cpp_result = cppSelf->QFSFileEngine::open(cpp_arg0);
            thread_state_saver.restore();
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // open(QFlags<QIODevice::OpenModeFlag>,int)
            QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
            bool cpp_result = cppSelf->QFSFileEngine::open(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<bool >::toPython(cpp_result);
        } else goto SbkQFSFileEngineFunc_open_TypeError;
    } else goto SbkQFSFileEngineFunc_open_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_open_TypeError:
        const char* overloads[] = {"PySide.QtCore.QIODevice.OpenMode, int", "PySide.QtCore.QIODevice.OpenMode", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFSFileEngine.open", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_owner(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractFileEngine::FileOwner >::isConvertible(arg)) {
        QAbstractFileEngine::FileOwner cpp_arg0 = Shiboken::Converter<QAbstractFileEngine::FileOwner >::toCpp(arg);
        // owner(QAbstractFileEngine::FileOwner)const
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        QString cpp_result = cppSelf->QFSFileEngine::owner(cpp_arg0);
        py_result = Shiboken::Converter<QString >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_owner_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_owner_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractFileEngine.FileOwner", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.owner", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_ownerId(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractFileEngine::FileOwner >::isConvertible(arg)) {
        QAbstractFileEngine::FileOwner cpp_arg0 = Shiboken::Converter<QAbstractFileEngine::FileOwner >::toCpp(arg);
        // ownerId(QAbstractFileEngine::FileOwner)const
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        uint cpp_result = cppSelf->QFSFileEngine::ownerId(cpp_arg0);
        py_result = Shiboken::Converter<unsigned int >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_ownerId_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_ownerId_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractFileEngine.FileOwner", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.ownerId", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_pos(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // pos()const
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QFSFileEngine::pos();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_read(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "read", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // read(char*,qint64)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QFSFileEngine::read(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_read_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_read_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFSFileEngine.read", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_readLine(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "readLine", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        char * cpp_arg0 = Shiboken::Converter<char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // readLine(char*,qint64)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        qint64 cpp_result = cppSelf->QFSFileEngine::readLine(cpp_arg0, cpp_arg1);
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_readLine_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_readLine_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFSFileEngine.readLine", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_remove(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // remove()
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    thread_state_saver.save();
    bool cpp_result = cppSelf->QFSFileEngine::remove();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_rename(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // rename(QString)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QFSFileEngine::rename(*cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_rename_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_rename_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.rename", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_rmdir(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "rmdir", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QString& >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QString& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
        // rmdir(QString,bool)const
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QFSFileEngine::rmdir(*cpp_arg0, cpp_arg1);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_rmdir_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_rmdir_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString, bool", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFSFileEngine.rmdir", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_rootPath(PyObject* self)
{
    PyObject* py_result = 0;

    // rootPath()
    QString cpp_result = QFSFileEngine::rootPath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_seek(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // seek(qint64)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QFSFileEngine::seek(cpp_arg0);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_seek_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_seek_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.seek", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_setCurrentPath(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setCurrentPath(QString)
        bool cpp_result = QFSFileEngine::setCurrentPath(*cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_setCurrentPath_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_setCurrentPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.setCurrentPath", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_setFileName(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setFileName(QString)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        cppSelf->QFSFileEngine::setFileName(*cpp_arg0);
    } else goto SbkQFSFileEngineFunc_setFileName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFSFileEngineFunc_setFileName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.setFileName", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_setPermissions(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        uint cpp_arg0 = Shiboken::Converter<uint >::toCpp(arg);
        // setPermissions(uint)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFSFileEngine::setPermissions(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_setPermissions_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_setPermissions_TypeError:
        const char* overloads[] = {"unsigned int", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.setPermissions", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_setSize(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (PyNumber_Check(arg)) {
        qint64 cpp_arg0 = Shiboken::Converter<qint64 >::toCpp(arg);
        // setSize(qint64)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFSFileEngine::setSize(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_setSize_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_setSize_TypeError:
        const char* overloads[] = {"long long", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.setSize", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_size(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // size()const
    QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
    qint64 cpp_result = cppSelf->QFSFileEngine::size();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_supportsExtension(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QAbstractFileEngine::Extension >::isConvertible(arg)) {
        QAbstractFileEngine::Extension cpp_arg0 = Shiboken::Converter<QAbstractFileEngine::Extension >::toCpp(arg);
        // supportsExtension(QAbstractFileEngine::Extension)const
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QFSFileEngine::supportsExtension(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_supportsExtension_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_supportsExtension_TypeError:
        const char* overloads[] = {"PySide.QtCore.QAbstractFileEngine.Extension", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFSFileEngine.supportsExtension", overloads);
        return 0;
}

static PyObject*
SbkQFSFileEngineFunc_tempPath(PyObject* self)
{
    PyObject* py_result = 0;

    // tempPath()
    QString cpp_result = QFSFileEngine::tempPath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFSFileEngineFunc_write(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "write", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        qint64 cpp_arg1 = Shiboken::Converter<qint64 >::toCpp(pyargs[1]);
        // write(const char*,qint64)
        QFSFileEngine* cppSelf = Shiboken::Converter<QFSFileEngine* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        qint64 cpp_result = cppSelf->QFSFileEngine::write(cpp_arg0, cpp_arg1);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<long long >::toPython(cpp_result);
    } else goto SbkQFSFileEngineFunc_write_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQFSFileEngineFunc_write_TypeError:
        const char* overloads[] = {"str, long long", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFSFileEngine.write", overloads);
        return 0;
}

static PyMethodDef SbkQFSFileEngine_methods[] = {
    {"beginEntryList", (PyCFunction)SbkQFSFileEngineFunc_beginEntryList, METH_VARARGS},
    {"caseSensitive", (PyCFunction)SbkQFSFileEngineFunc_caseSensitive, METH_NOARGS},
    {"close", (PyCFunction)SbkQFSFileEngineFunc_close, METH_NOARGS},
    {"copy", (PyCFunction)SbkQFSFileEngineFunc_copy, METH_O},
    {"currentPath", (PyCFunction)SbkQFSFileEngineFunc_currentPath, METH_NOARGS|METH_O|METH_STATIC},
    {"drives", (PyCFunction)SbkQFSFileEngineFunc_drives, METH_NOARGS|METH_STATIC},
    {"endEntryList", (PyCFunction)SbkQFSFileEngineFunc_endEntryList, METH_NOARGS},
    {"entryList", (PyCFunction)SbkQFSFileEngineFunc_entryList, METH_VARARGS},
    {"fileFlags", (PyCFunction)SbkQFSFileEngineFunc_fileFlags, METH_O},
    {"fileName", (PyCFunction)SbkQFSFileEngineFunc_fileName, METH_O},
    {"fileTime", (PyCFunction)SbkQFSFileEngineFunc_fileTime, METH_O},
    {"flush", (PyCFunction)SbkQFSFileEngineFunc_flush, METH_NOARGS},
    {"handle", (PyCFunction)SbkQFSFileEngineFunc_handle, METH_NOARGS},
    {"homePath", (PyCFunction)SbkQFSFileEngineFunc_homePath, METH_NOARGS|METH_STATIC},
    {"isRelativePath", (PyCFunction)SbkQFSFileEngineFunc_isRelativePath, METH_NOARGS},
    {"isSequential", (PyCFunction)SbkQFSFileEngineFunc_isSequential, METH_NOARGS},
    {"link", (PyCFunction)SbkQFSFileEngineFunc_link, METH_O},
    {"mkdir", (PyCFunction)SbkQFSFileEngineFunc_mkdir, METH_VARARGS},
    {"open", (PyCFunction)SbkQFSFileEngineFunc_open, METH_VARARGS},
    {"owner", (PyCFunction)SbkQFSFileEngineFunc_owner, METH_O},
    {"ownerId", (PyCFunction)SbkQFSFileEngineFunc_ownerId, METH_O},
    {"pos", (PyCFunction)SbkQFSFileEngineFunc_pos, METH_NOARGS},
    {"read", (PyCFunction)SbkQFSFileEngineFunc_read, METH_VARARGS},
    {"readLine", (PyCFunction)SbkQFSFileEngineFunc_readLine, METH_VARARGS},
    {"remove", (PyCFunction)SbkQFSFileEngineFunc_remove, METH_NOARGS},
    {"rename", (PyCFunction)SbkQFSFileEngineFunc_rename, METH_O},
    {"rmdir", (PyCFunction)SbkQFSFileEngineFunc_rmdir, METH_VARARGS},
    {"rootPath", (PyCFunction)SbkQFSFileEngineFunc_rootPath, METH_NOARGS|METH_STATIC},
    {"seek", (PyCFunction)SbkQFSFileEngineFunc_seek, METH_O},
    {"setCurrentPath", (PyCFunction)SbkQFSFileEngineFunc_setCurrentPath, METH_O|METH_STATIC},
    {"setFileName", (PyCFunction)SbkQFSFileEngineFunc_setFileName, METH_O},
    {"setPermissions", (PyCFunction)SbkQFSFileEngineFunc_setPermissions, METH_O},
    {"setSize", (PyCFunction)SbkQFSFileEngineFunc_setSize, METH_O},
    {"size", (PyCFunction)SbkQFSFileEngineFunc_size, METH_NOARGS},
    {"supportsExtension", (PyCFunction)SbkQFSFileEngineFunc_supportsExtension, METH_O},
    {"tempPath", (PyCFunction)SbkQFSFileEngineFunc_tempPath, METH_NOARGS|METH_STATIC},
    {"write", (PyCFunction)SbkQFSFileEngineFunc_write, METH_VARARGS},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFSFileEngine_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QFSFileEngine",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QFSFileEngineWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFSFileEngine_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFSFileEngine_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QFSFileEngine(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QFSFILEENGINE_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFSFileEngine_Type);

    SbkQFSFileEngine_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_IDX];
    // Fill type discovery information
    SbkQFSFileEngine_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QABSTRACTFILEENGINE_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQFSFileEngine_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFSFileEngine_Type));
    PyModule_AddObject(module, "QFSFileEngine",
        ((PyObject*)&SbkQFSFileEngine_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QFSFileEngine >("QFSFileEngine*");
    Shiboken::TypeResolver::createObjectTypeResolver<QFSFileEngine >(typeid(QFSFileEngine).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

