/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qfilesystemwatcher_wrapper.h"

// Extra includes
#include <QList>
#include <QStringList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qvariant.h>

using namespace Shiboken;

// Native ---------------------------------------------------------

QFileSystemWatcherWrapper::QFileSystemWatcherWrapper(QObject * parent) : QFileSystemWatcher(parent), m_metaObject(0) {
    // ... middle
}

QFileSystemWatcherWrapper::QFileSystemWatcherWrapper(const QStringList & paths, QObject * parent) : QFileSystemWatcher(paths, parent), m_metaObject(0) {
    // ... middle
}

void QFileSystemWatcherWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileSystemWatcherWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QFileSystemWatcherWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QFileSystemWatcherWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QFileSystemWatcherWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QObject::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileSystemWatcher.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
    return cpp_result;
}

bool QFileSystemWatcherWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QFileSystemWatcher.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QFileSystemWatcherWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QFileSystemWatcherWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QFileSystemWatcher::staticMetaObject);
}
    return m_metaObject;
}

int QFileSystemWatcherWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QFileSystemWatcher::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QFileSystemWatcherWrapper::~QFileSystemWatcherWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static int
SbkQFileSystemWatcher_Init(PyObject* self, PyObject* args, PyObject* kwds)
{
    QFileSystemWatcherWrapper* cptr = 0;
    SbkBaseWrapper* sbkSelf = reinterpret_cast<SbkBaseWrapper*>(self);
    assert(!sbkSelf->cptr);

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "QFileSystemWatcher", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return -1;

    if (numArgs == 0) {
        // QFileSystemWatcher(QObject*)
        cptr = new QFileSystemWatcherWrapper();
        Shiboken::setParent(pyargs[0], self);
    } else if (Shiboken::Converter<QStringList& >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(pyargs[0]);
        if (!Shiboken::Converter<QStringList& >::isConvertible(pyargs[0]))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        if (numArgs == 1) {
            // QFileSystemWatcher(QStringList,QObject*)
            cptr = new QFileSystemWatcherWrapper(*cpp_arg0);
            Shiboken::setParent(pyargs[1], self);
        } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[1])) {
            if (Shiboken::cppObjectIsInvalid(pyargs[1]))
                return -1;
            QObject* cpp_arg1 = Shiboken::Converter<QObject* >::toCpp(pyargs[1]);
            // QFileSystemWatcher(QStringList,QObject*)
            cptr = new QFileSystemWatcherWrapper(*cpp_arg0, cpp_arg1);
            Shiboken::setParent(pyargs[1], self);
        } else goto SbkQFileSystemWatcher_Init_TypeError;
    } else if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return -1;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        // QFileSystemWatcher(QObject*)
        cptr = new QFileSystemWatcherWrapper(cpp_arg0);
        Shiboken::setParent(pyargs[0], self);
    } else goto SbkQFileSystemWatcher_Init_TypeError;

    if (PyErr_Occurred()) {
        delete cptr;
        return -1;
    }
    if (!cptr) goto SbkQFileSystemWatcher_Init_TypeError;

    sbkSelf->cptr = cptr;
    sbkSelf->validCppObject = 1;
    sbkSelf->containsCppWrapper = 1;
    BindingManager::instance().registerWrapper(sbkSelf);

    return 1;

    SbkQFileSystemWatcher_Init_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject = None", "PySide.QtCore.QStringList, PySide.QtCore.QObject = None", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QFileSystemWatcher", overloads);
        return -1;
}

static PyObject*
SbkQFileSystemWatcherFunc_addPath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addPath(QString)
        QFileSystemWatcher* cppSelf = Shiboken::Converter<QFileSystemWatcher* >::toCpp((PyObject*)self);
        cppSelf->QFileSystemWatcher::addPath(*cpp_arg0);
    } else goto SbkQFileSystemWatcherFunc_addPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileSystemWatcherFunc_addPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFileSystemWatcher.addPath", overloads);
        return 0;
}

static PyObject*
SbkQFileSystemWatcherFunc_addPaths(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // addPaths(QStringList)
        QFileSystemWatcher* cppSelf = Shiboken::Converter<QFileSystemWatcher* >::toCpp((PyObject*)self);
        cppSelf->QFileSystemWatcher::addPaths(*cpp_arg0);
    } else goto SbkQFileSystemWatcherFunc_addPaths_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileSystemWatcherFunc_addPaths_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFileSystemWatcher.addPaths", overloads);
        return 0;
}

static PyObject*
SbkQFileSystemWatcherFunc_directories(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // directories()const
    QFileSystemWatcher* cppSelf = Shiboken::Converter<QFileSystemWatcher* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QFileSystemWatcher::directories();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileSystemWatcherFunc_files(PyObject* self)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    // files()const
    QFileSystemWatcher* cppSelf = Shiboken::Converter<QFileSystemWatcher* >::toCpp((PyObject*)self);
    QStringList cpp_result = cppSelf->QFileSystemWatcher::files();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQFileSystemWatcherFunc_removePath(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removePath(QString)
        QFileSystemWatcher* cppSelf = Shiboken::Converter<QFileSystemWatcher* >::toCpp((PyObject*)self);
        cppSelf->QFileSystemWatcher::removePath(*cpp_arg0);
    } else goto SbkQFileSystemWatcherFunc_removePath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileSystemWatcherFunc_removePath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFileSystemWatcher.removePath", overloads);
        return 0;
}

static PyObject*
SbkQFileSystemWatcherFunc_removePaths(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;


    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // removePaths(QStringList)
        QFileSystemWatcher* cppSelf = Shiboken::Converter<QFileSystemWatcher* >::toCpp((PyObject*)self);
        cppSelf->QFileSystemWatcher::removePaths(*cpp_arg0);
    } else goto SbkQFileSystemWatcherFunc_removePaths_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQFileSystemWatcherFunc_removePaths_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QFileSystemWatcher.removePaths", overloads);
        return 0;
}

static PyMethodDef SbkQFileSystemWatcher_methods[] = {
    {"addPath", (PyCFunction)SbkQFileSystemWatcherFunc_addPath, METH_O},
    {"addPaths", (PyCFunction)SbkQFileSystemWatcherFunc_addPaths, METH_O},
    {"directories", (PyCFunction)SbkQFileSystemWatcherFunc_directories, METH_NOARGS},
    {"files", (PyCFunction)SbkQFileSystemWatcherFunc_files, METH_NOARGS},
    {"removePath", (PyCFunction)SbkQFileSystemWatcherFunc_removePath, METH_O},
    {"removePaths", (PyCFunction)SbkQFileSystemWatcherFunc_removePaths, METH_O},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQFileSystemWatcher_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QFileSystemWatcher",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QFileSystemWatcherWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQFileSystemWatcher_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQFileSystemWatcher_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};


PyAPI_FUNC(void)
init_QFileSystemWatcher(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QFILESYSTEMWATCHER_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQFileSystemWatcher_Type);

    SbkQFileSystemWatcher_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQFileSystemWatcher_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQFileSystemWatcher_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQFileSystemWatcher_Type));
    PyModule_AddObject(module, "QFileSystemWatcher",
        ((PyObject*)&SbkQFileSystemWatcher_Type));

    Shiboken::TypeResolver::createObjectTypeResolver<QFileSystemWatcher >("QFileSystemWatcher*");
    Shiboken::TypeResolver::createObjectTypeResolver<QFileSystemWatcher >(typeid(QFileSystemWatcher).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken

