/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#include <typeresolver.h>
#include <typeinfo>
#include <signalmanager.h>
#include <dynamicqmetaobject.h>
#include "pyside_qtcore_python.h"

#include "qcoreapplication_wrapper.h"

// Extra includes
#include <QList>
#include <QStringList>
#include <QTranslator>
#include <qbytearray.h>
#include <qcoreapplication.h>
#include <qcoreevent.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qthread.h>
#include <qtranslator.h>
#include <qvariant.h>

using namespace Shiboken;

// Begin code injection
// ========================================================================
// START of custom code block [file: glue/qcoreapplication_init.cpp]
// Global variables used to store argc and argv values
static int QCoreApplicationArgCount;
static char** QCoreApplicationArgValues;

/**
 * Called at QtCore module exit
 */
void DeleteQCoreApplicationAtExit() {
    if (QCoreApplication::instance()) {
        delete QCoreApplication::instance();
        for (int i = 0; i < QCoreApplicationArgCount; ++i)
            delete[] QCoreApplicationArgValues[i];
    }
}

int SbkQCoreApplication_Init(PyObject* self, PyObject* args, PyObject*)
{
    if (QCoreApplication::instance()) {
        PyErr_SetString(PyExc_RuntimeError, "A QCoreApplication instance already exists.");
        return -1;
    }

    int numArgs = PyTuple_GET_SIZE(args);
    if (numArgs != 1) {
        PyErr_BadArgument();
        return -1;
    }

    if (!PySequenceToArgcArgv(PyTuple_GET_ITEM(args, 0), &QCoreApplicationArgCount, &QCoreApplicationArgValues, "PySideApp")) {
        PyErr_BadArgument();
        return -1;
    }

    SbkBaseWrapper_setCptr(self, new QCoreApplication(QCoreApplicationArgCount, QCoreApplicationArgValues));
    SbkBaseWrapper_setValidCppObject(self, 1);
    Shiboken::BindingManager::instance().registerWrapper(reinterpret_cast<SbkBaseWrapper*>(self));

    Py_INCREF(self);
    Py_AtExit(DeleteQCoreApplicationAtExit);
    return 1;
}

// END of custom code block [file: glue/qcoreapplication_init.cpp]
// ========================================================================

// End of code injection

// Native ---------------------------------------------------------

void QCoreApplicationWrapper::childEvent(QChildEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "childEvent"));
    if (py_override.isNull()) {
        return this->QObject::childEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QChildEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCoreApplicationWrapper::connectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "connectNotify"));
    if (py_override.isNull()) {
        return this->QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

void QCoreApplicationWrapper::customEvent(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "customEvent"));
    if (py_override.isNull()) {
        return this->QObject::customEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

void QCoreApplicationWrapper::disconnectNotify(const char * signal)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "disconnectNotify"));
    if (py_override.isNull()) {
        return this->QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(z)",
        signal
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
}

bool QCoreApplicationWrapper::event(QEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "event"));
    if (py_override.isNull()) {
        return this->QCoreApplication::event(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCoreApplication.event");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    return cpp_result;
}

bool QCoreApplicationWrapper::eventFilter(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "eventFilter"));
    if (py_override.isNull()) {
        return this->QObject::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCoreApplication.eventFilter");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

bool QCoreApplicationWrapper::notify(QObject * arg__1, QEvent * arg__2)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "notify"));
    if (py_override.isNull()) {
        Shiboken::ThreadStateSaver thread_state_saver;
        thread_state_saver.save();
        return this->QCoreApplication::notify(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(OO)",
        Shiboken::Converter<QObject* >::toPython(arg__1),
        Shiboken::Converter<QEvent* >::toPython(arg__2)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    // An error happened in python code!
    if (py_result.isNull()) {
        PyErr_Print();
        return bool(0);
    }
    // Check return type
    bool typeIsValid = PyBool_Check(py_result);
    if (!typeIsValid) {
        PyErr_SetString(PyExc_TypeError, "Invalid return value in function QCoreApplication.notify");
        return bool(0)        ;
    }
    bool cpp_result(Shiboken::Converter<bool >::toCpp(py_result));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 1));
    return cpp_result;
}

void QCoreApplicationWrapper::timerEvent(QTimerEvent * arg__1)
{
    Shiboken::GilState gil;
    Shiboken::AutoDecRef py_override(BindingManager::instance().getOverride(this, "timerEvent"));
    if (py_override.isNull()) {
        return this->QObject::timerEvent(arg__1);
    }

    Shiboken::AutoDecRef pyargs(Py_BuildValue("(O)",
        Shiboken::Converter<QTimerEvent* >::toPython(arg__1)
    ));

    Shiboken::AutoDecRef py_result(PyObject_Call(py_override, pyargs, NULL));
    BindingManager::instance().invalidateWrapper(PyTuple_GET_ITEM(pyargs, 0));
}

const QMetaObject* QCoreApplicationWrapper::metaObject() const
{
    if (!m_metaObject) {
        PyObject *pySelf = BindingManager::instance().retrieveWrapper(this);
        QString className(pySelf->ob_type->tp_name);
        className = className.mid(className.lastIndexOf(".")+1);
        m_metaObject = new PySide::DynamicQMetaObject(className.toAscii(), &QCoreApplication::staticMetaObject);
}
    return m_metaObject;
}

int QCoreApplicationWrapper::qt_metacall(QMetaObject::Call call, int id, void** args)
{
    int result = QCoreApplication::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

QCoreApplicationWrapper::~QCoreApplicationWrapper()
{
    BindingManager::instance().invalidateWrapper(this);
    delete m_metaObject;
}

// Target ---------------------------------------------------------

static PyObject*
SbkQCoreApplicationFunc_addLibraryPath(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // addLibraryPath(QString)
        QCoreApplication::addLibraryPath(*cpp_arg0);
    } else goto SbkQCoreApplicationFunc_addLibraryPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_addLibraryPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.addLibraryPath", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_applicationDirPath(PyObject* self)
{
    PyObject* py_result = 0;

    // applicationDirPath()
    QString cpp_result = QCoreApplication::applicationDirPath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_applicationFilePath(PyObject* self)
{
    PyObject* py_result = 0;

    // applicationFilePath()
    QString cpp_result = QCoreApplication::applicationFilePath();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_applicationName(PyObject* self)
{
    PyObject* py_result = 0;

    // applicationName()
    QString cpp_result = QCoreApplication::applicationName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_applicationPid(PyObject* self)
{
    PyObject* py_result = 0;

    // applicationPid()
    qint64 cpp_result = QCoreApplication::applicationPid();
    py_result = Shiboken::Converter<long long >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_applicationVersion(PyObject* self)
{
    PyObject* py_result = 0;

    // applicationVersion()
    QString cpp_result = QCoreApplication::applicationVersion();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_closingDown(PyObject* self)
{
    PyObject* py_result = 0;

    // closingDown()
    bool cpp_result = QCoreApplication::closingDown();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_event(PyObject* self, PyObject* arg)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;

    if (Shiboken::Converter<QEvent* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QEvent* cpp_arg0 = Shiboken::Converter<QEvent* >::toCpp(arg);
        // event(QEvent*)
        QCoreApplication* cppSelf = Shiboken::Converter<QCoreApplication* >::toCpp((PyObject*)self);
        bool cpp_result = cppSelf->QCoreApplication::event(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQCoreApplicationFunc_event_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCoreApplicationFunc_event_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.event", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_exec_(PyObject* self)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    // exec()
    thread_state_saver.save();
    int cpp_result = QCoreApplication::exec();
    thread_state_saver.restore();
    py_result = Shiboken::Converter<int >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_exit(PyObject* self, PyObject* arg)
{

    int numArgs = (arg == 0 ? 0 : 1);
    if (numArgs == 0) {
        // exit(int)
        QCoreApplication::exit();
    } else if (PyNumber_Check(arg)) {
        int cpp_arg0 = Shiboken::Converter<int >::toCpp(arg);
        // exit(int)
        QCoreApplication::exit(cpp_arg0);
    } else goto SbkQCoreApplicationFunc_exit_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_exit_TypeError:
        const char* overloads[] = {"int = 0", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.exit", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_flush(PyObject* self)
{
    Shiboken::ThreadStateSaver thread_state_saver;

    // flush()
    thread_state_saver.save();
    QCoreApplication::flush();
    thread_state_saver.restore();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQCoreApplicationFunc_hasPendingEvents(PyObject* self)
{
    PyObject* py_result = 0;

    // hasPendingEvents()
    bool cpp_result = QCoreApplication::hasPendingEvents();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_installTranslator(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QTranslator* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTranslator* cpp_arg0 = Shiboken::Converter<QTranslator* >::toCpp(arg);
        // installTranslator(QTranslator*)
        QCoreApplication::installTranslator(cpp_arg0);
    } else goto SbkQCoreApplicationFunc_installTranslator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_installTranslator_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTranslator", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.installTranslator", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_instance(PyObject* self)
{
    PyObject* py_result = 0;

    // instance()
    QCoreApplication * cpp_result = QCoreApplication::instance();
    py_result = Shiboken::Converter<QCoreApplication* >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_libraryPaths(PyObject* self)
{
    PyObject* py_result = 0;

    // libraryPaths()
    QStringList cpp_result = QCoreApplication::libraryPaths();
    py_result = Shiboken::Converter<QStringList >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_notify(PyObject* self, PyObject* args)
{
    if (Shiboken::cppObjectIsInvalid(self))
        return 0;

    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "notify", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // notify(QObject*,QEvent*)
        QCoreApplication* cppSelf = Shiboken::Converter<QCoreApplication* >::toCpp((PyObject*)self);
        thread_state_saver.save();
        bool cpp_result = cppSelf->QCoreApplication::notify(cpp_arg0, cpp_arg1);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQCoreApplicationFunc_notify_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCoreApplicationFunc_notify_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCoreApplication.notify", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_organizationDomain(PyObject* self)
{
    PyObject* py_result = 0;

    // organizationDomain()
    QString cpp_result = QCoreApplication::organizationDomain();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_organizationName(PyObject* self)
{
    PyObject* py_result = 0;

    // organizationName()
    QString cpp_result = QCoreApplication::organizationName();
    py_result = Shiboken::Converter<QString >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_postEvent(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0};

    if (!PyArg_UnpackTuple(args, "postEvent", 2, 3, &(pyargs[0]), &(pyargs[1]), &(pyargs[2])))
        return 0;

    if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // postEvent(QObject*,QEvent*)
            QCoreApplication::postEvent(cpp_arg0, cpp_arg1);

            // Ownership transferences.
            BindingManager::instance().transferOwnershipToCpp(pyargs[1]);
        } else if (numArgs == 3 && PyNumber_Check(pyargs[2])) {
            int cpp_arg2 = Shiboken::Converter<int >::toCpp(pyargs[2]);
            // postEvent(QObject*,QEvent*,int)
            QCoreApplication::postEvent(cpp_arg0, cpp_arg1, cpp_arg2);

            // Ownership transferences.
            BindingManager::instance().transferOwnershipToCpp(pyargs[1]);
        } else goto SbkQCoreApplicationFunc_postEvent_TypeError;
    } else goto SbkQCoreApplicationFunc_postEvent_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_postEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", "PySide.QtCore.QObject, PySide.QtCore.QEvent, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCoreApplication.postEvent", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_processEvents(PyObject* self, PyObject* args)
{
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "processEvents", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
        thread_state_saver.save();
        QCoreApplication::processEvents();
        thread_state_saver.restore();
    } else if (SbkPySide_QtCore_QEventLoop_ProcessEventsFlag_Check(pyargs[0])) {
        QFlags<QEventLoop::ProcessEventsFlag> cpp_arg0 = Shiboken::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // processEvents(QFlags<QEventLoop::ProcessEventsFlag>)
            thread_state_saver.save();
            QCoreApplication::processEvents(cpp_arg0);
            thread_state_saver.restore();
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // processEvents(QFlags<QEventLoop::ProcessEventsFlag>,int)
            thread_state_saver.save();
            QCoreApplication::processEvents(cpp_arg0, cpp_arg1);
            thread_state_saver.restore();
        } else goto SbkQCoreApplicationFunc_processEvents_TypeError;
    } else goto SbkQCoreApplicationFunc_processEvents_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_processEvents_TypeError:
        const char* overloads[] = {"PySide.QtCore.QEventLoop.ProcessEventsFlags = QEventLoop.AllEvents", "PySide.QtCore.QEventLoop.ProcessEventsFlags, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCoreApplication.processEvents", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_quit(PyObject* self)
{

    // quit()
    QCoreApplication::quit();

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;
}

static PyObject*
SbkQCoreApplicationFunc_removeLibraryPath(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // removeLibraryPath(QString)
        QCoreApplication::removeLibraryPath(*cpp_arg0);
    } else goto SbkQCoreApplicationFunc_removeLibraryPath_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_removeLibraryPath_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.removeLibraryPath", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_removePostedEvents(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "removePostedEvents", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<QObject* >::isConvertible(pyargs[0])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // removePostedEvents(QObject*)
            QCoreApplication::removePostedEvents(cpp_arg0);
        } else if (numArgs == 2 && PyNumber_Check(pyargs[1])) {
            int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
            // removePostedEvents(QObject*,int)
            QCoreApplication::removePostedEvents(cpp_arg0, cpp_arg1);
        } else goto SbkQCoreApplicationFunc_removePostedEvents_TypeError;
    } else goto SbkQCoreApplicationFunc_removePostedEvents_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_removePostedEvents_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject", "PySide.QtCore.QObject, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCoreApplication.removePostedEvents", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_removeTranslator(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QTranslator* >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        QTranslator* cpp_arg0 = Shiboken::Converter<QTranslator* >::toCpp(arg);
        // removeTranslator(QTranslator*)
        QCoreApplication::removeTranslator(cpp_arg0);
    } else goto SbkQCoreApplicationFunc_removeTranslator_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_removeTranslator_TypeError:
        const char* overloads[] = {"PySide.QtCore.QTranslator", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.removeTranslator", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_sendEvent(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "sendEvent", 2, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && Shiboken::Converter<QEvent* >::isConvertible(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        if (Shiboken::cppObjectIsInvalid(pyargs[1]))
            return 0;
        QEvent* cpp_arg1 = Shiboken::Converter<QEvent* >::toCpp(pyargs[1]);
        // sendEvent(QObject*,QEvent*)
        thread_state_saver.save();
        bool cpp_result = QCoreApplication::sendEvent(cpp_arg0, cpp_arg1);
        thread_state_saver.restore();
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQCoreApplicationFunc_sendEvent_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCoreApplicationFunc_sendEvent_TypeError:
        const char* overloads[] = {"PySide.QtCore.QObject, PySide.QtCore.QEvent", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCoreApplication.sendEvent", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_sendPostedEvents(PyObject* self, PyObject* args)
{
    Shiboken::ThreadStateSaver thread_state_saver;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto SbkQCoreApplicationFunc_sendPostedEvents_TypeError;

    if (!PyArg_UnpackTuple(args, "sendPostedEvents", 0, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (numArgs == 0) {
        // sendPostedEvents()
        thread_state_saver.save();
        QCoreApplication::sendPostedEvents();
        thread_state_saver.restore();
    } else if (numArgs == 2 && Shiboken::Converter<QObject* >::isConvertible(pyargs[0]) && PyNumber_Check(pyargs[1])) {
        if (Shiboken::cppObjectIsInvalid(pyargs[0]))
            return 0;
        QObject* cpp_arg0 = Shiboken::Converter<QObject* >::toCpp(pyargs[0]);
        int cpp_arg1 = Shiboken::Converter<int >::toCpp(pyargs[1]);
        // sendPostedEvents(QObject*,int)
        thread_state_saver.save();
        QCoreApplication::sendPostedEvents(cpp_arg0, cpp_arg1);
        thread_state_saver.restore();
    } else goto SbkQCoreApplicationFunc_sendPostedEvents_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_sendPostedEvents_TypeError:
        const char* overloads[] = {"", "PySide.QtCore.QObject, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCoreApplication.sendPostedEvents", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_setApplicationName(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setApplicationName(QString)
        QCoreApplication::setApplicationName(*cpp_arg0);
    } else goto SbkQCoreApplicationFunc_setApplicationName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_setApplicationName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.setApplicationName", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_setApplicationVersion(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setApplicationVersion(QString)
        QCoreApplication::setApplicationVersion(*cpp_arg0);
    } else goto SbkQCoreApplicationFunc_setApplicationVersion_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_setApplicationVersion_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.setApplicationVersion", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_setAttribute(PyObject* self, PyObject* args)
{

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0};

    if (!PyArg_UnpackTuple(args, "setAttribute", 1, 2, &(pyargs[0]), &(pyargs[1])))
        return 0;

    if (Shiboken::Converter<Qt::ApplicationAttribute >::isConvertible(pyargs[0])) {
        Qt::ApplicationAttribute cpp_arg0 = Shiboken::Converter<Qt::ApplicationAttribute >::toCpp(pyargs[0]);
        if (numArgs == 1) {
            // setAttribute(Qt::ApplicationAttribute,bool)
            QCoreApplication::setAttribute(cpp_arg0);
        } else if (PyNumber_Check(pyargs[1])) {
            bool cpp_arg1 = Shiboken::Converter<bool >::toCpp(pyargs[1]);
            // setAttribute(Qt::ApplicationAttribute,bool)
            QCoreApplication::setAttribute(cpp_arg0, cpp_arg1);
        } else goto SbkQCoreApplicationFunc_setAttribute_TypeError;
    } else goto SbkQCoreApplicationFunc_setAttribute_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_setAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ApplicationAttribute, bool = true", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCoreApplication.setAttribute", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_setLibraryPaths(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QStringList& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QStringList > cpp_arg0_auto_ptr;
        QStringList* cpp_arg0 = Shiboken::Converter<QStringList* >::toCpp(arg);
        if (!Shiboken::Converter<QStringList& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QStringList >(cpp_arg0);
        // setLibraryPaths(QStringList)
        QCoreApplication::setLibraryPaths(*cpp_arg0);
    } else goto SbkQCoreApplicationFunc_setLibraryPaths_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_setLibraryPaths_TypeError:
        const char* overloads[] = {"PySide.QtCore.QStringList", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.setLibraryPaths", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_setOrganizationDomain(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setOrganizationDomain(QString)
        QCoreApplication::setOrganizationDomain(*cpp_arg0);
    } else goto SbkQCoreApplicationFunc_setOrganizationDomain_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_setOrganizationDomain_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.setOrganizationDomain", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_setOrganizationName(PyObject* self, PyObject* arg)
{

    if (Shiboken::Converter<QString& >::isConvertible(arg)) {
        if (Shiboken::cppObjectIsInvalid(arg))
            return 0;
        std::auto_ptr<QString > cpp_arg0_auto_ptr;
        QString* cpp_arg0 = Shiboken::Converter<QString* >::toCpp(arg);
        if (!Shiboken::Converter<QString& >::isConvertible(arg))
            cpp_arg0_auto_ptr = std::auto_ptr<QString >(cpp_arg0);
        // setOrganizationName(QString)
        QCoreApplication::setOrganizationName(*cpp_arg0);
    } else goto SbkQCoreApplicationFunc_setOrganizationName_TypeError;

    if (PyErr_Occurred()) {
        return 0;
    }
    Py_RETURN_NONE;

    SbkQCoreApplicationFunc_setOrganizationName_TypeError:
        const char* overloads[] = {"PySide.QtCore.QString", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.setOrganizationName", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_startingUp(PyObject* self)
{
    PyObject* py_result = 0;

    // startingUp()
    bool cpp_result = QCoreApplication::startingUp();
    py_result = Shiboken::Converter<bool >::toPython(cpp_result);

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;
}

static PyObject*
SbkQCoreApplicationFunc_testAttribute(PyObject* self, PyObject* arg)
{
    PyObject* py_result = 0;

    if (Shiboken::Converter<Qt::ApplicationAttribute >::isConvertible(arg)) {
        Qt::ApplicationAttribute cpp_arg0 = Shiboken::Converter<Qt::ApplicationAttribute >::toCpp(arg);
        // testAttribute(Qt::ApplicationAttribute)
        bool cpp_result = QCoreApplication::testAttribute(cpp_arg0);
        py_result = Shiboken::Converter<bool >::toPython(cpp_result);
    } else goto SbkQCoreApplicationFunc_testAttribute_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCoreApplicationFunc_testAttribute_TypeError:
        const char* overloads[] = {"PySide.QtCore.Qt.ApplicationAttribute", 0};
        Shiboken::setErrorAboutWrongArguments(arg, "PySide.QtCore.QCoreApplication.testAttribute", overloads);
        return 0;
}

static PyObject*
SbkQCoreApplicationFunc_translate(PyObject* self, PyObject* args)
{
    PyObject* py_result = 0;

    int numArgs = PyTuple_GET_SIZE(args);
    PyObject* pyargs[] = {0, 0, 0, 0, 0};

    if (!PyArg_UnpackTuple(args, "translate", 2, 5, &(pyargs[0]), &(pyargs[1]), &(pyargs[2]), &(pyargs[3]), &(pyargs[4])))
        return 0;

    if (Shiboken::Converter<const char * >::isConvertible(pyargs[0]) && Shiboken::Converter<const char * >::isConvertible(pyargs[1])) {
        const char * cpp_arg0 = Shiboken::Converter<const char * >::toCpp(pyargs[0]);
        const char * cpp_arg1 = Shiboken::Converter<const char * >::toCpp(pyargs[1]);
        if (numArgs == 2) {
            // translate(const char*,const char*,const char*,QCoreApplication::Encoding)
            QString cpp_result = QCoreApplication::translate(cpp_arg0, cpp_arg1);
            py_result = Shiboken::Converter<QString >::toPython(cpp_result);
        } else if (Shiboken::Converter<const char * >::isConvertible(pyargs[2])) {
            const char * cpp_arg2 = Shiboken::Converter<const char * >::toCpp(pyargs[2]);
            if (numArgs == 3) {
                // translate(const char*,const char*,const char*,QCoreApplication::Encoding)
                QString cpp_result = QCoreApplication::translate(cpp_arg0, cpp_arg1, cpp_arg2);
                py_result = Shiboken::Converter<QString >::toPython(cpp_result);
            } else if (Shiboken::Converter<QCoreApplication::Encoding >::isConvertible(pyargs[3])) {
                QCoreApplication::Encoding cpp_arg3 = Shiboken::Converter<QCoreApplication::Encoding >::toCpp(pyargs[3]);
                if (numArgs == 4) {
                    // translate(const char*,const char*,const char*,QCoreApplication::Encoding)
                    QString cpp_result = QCoreApplication::translate(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3);
                    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                } else if (numArgs == 5 && PyNumber_Check(pyargs[4])) {
                    int cpp_arg4 = Shiboken::Converter<int >::toCpp(pyargs[4]);
                    // translate(const char*,const char*,const char*,QCoreApplication::Encoding,int)
                    QString cpp_result = QCoreApplication::translate(cpp_arg0, cpp_arg1, cpp_arg2, cpp_arg3, cpp_arg4);
                    py_result = Shiboken::Converter<QString >::toPython(cpp_result);
                } else goto SbkQCoreApplicationFunc_translate_TypeError;
            } else goto SbkQCoreApplicationFunc_translate_TypeError;
        } else goto SbkQCoreApplicationFunc_translate_TypeError;
    } else goto SbkQCoreApplicationFunc_translate_TypeError;

    if (PyErr_Occurred() || !py_result) {
        Py_XDECREF(py_result);
        return 0;
    }
        return py_result;
;

    SbkQCoreApplicationFunc_translate_TypeError:
        const char* overloads[] = {"str, str, str = None, PySide.QtCore.QCoreApplication.Encoding = CodecForTr", "str, str, str, PySide.QtCore.QCoreApplication.Encoding, int", 0};
        Shiboken::setErrorAboutWrongArguments(args, "PySide.QtCore.QCoreApplication.translate", overloads);
        return 0;
}

static PyMethodDef SbkQCoreApplication_methods[] = {
    {"addLibraryPath", (PyCFunction)SbkQCoreApplicationFunc_addLibraryPath, METH_O|METH_STATIC},
    {"applicationDirPath", (PyCFunction)SbkQCoreApplicationFunc_applicationDirPath, METH_NOARGS|METH_STATIC},
    {"applicationFilePath", (PyCFunction)SbkQCoreApplicationFunc_applicationFilePath, METH_NOARGS|METH_STATIC},
    {"applicationName", (PyCFunction)SbkQCoreApplicationFunc_applicationName, METH_NOARGS|METH_STATIC},
    {"applicationPid", (PyCFunction)SbkQCoreApplicationFunc_applicationPid, METH_NOARGS|METH_STATIC},
    {"applicationVersion", (PyCFunction)SbkQCoreApplicationFunc_applicationVersion, METH_NOARGS|METH_STATIC},
    {"closingDown", (PyCFunction)SbkQCoreApplicationFunc_closingDown, METH_NOARGS|METH_STATIC},
    {"event", (PyCFunction)SbkQCoreApplicationFunc_event, METH_O},
    {"exec_", (PyCFunction)SbkQCoreApplicationFunc_exec_, METH_NOARGS|METH_STATIC},
    {"exit", (PyCFunction)SbkQCoreApplicationFunc_exit, METH_NOARGS|METH_O|METH_STATIC},
    {"flush", (PyCFunction)SbkQCoreApplicationFunc_flush, METH_NOARGS|METH_STATIC},
    {"hasPendingEvents", (PyCFunction)SbkQCoreApplicationFunc_hasPendingEvents, METH_NOARGS|METH_STATIC},
    {"installTranslator", (PyCFunction)SbkQCoreApplicationFunc_installTranslator, METH_O|METH_STATIC},
    {"instance", (PyCFunction)SbkQCoreApplicationFunc_instance, METH_NOARGS|METH_STATIC},
    {"libraryPaths", (PyCFunction)SbkQCoreApplicationFunc_libraryPaths, METH_NOARGS|METH_STATIC},
    {"notify", (PyCFunction)SbkQCoreApplicationFunc_notify, METH_VARARGS},
    {"organizationDomain", (PyCFunction)SbkQCoreApplicationFunc_organizationDomain, METH_NOARGS|METH_STATIC},
    {"organizationName", (PyCFunction)SbkQCoreApplicationFunc_organizationName, METH_NOARGS|METH_STATIC},
    {"postEvent", (PyCFunction)SbkQCoreApplicationFunc_postEvent, METH_VARARGS|METH_STATIC},
    {"processEvents", (PyCFunction)SbkQCoreApplicationFunc_processEvents, METH_VARARGS|METH_STATIC},
    {"quit", (PyCFunction)SbkQCoreApplicationFunc_quit, METH_NOARGS|METH_STATIC},
    {"removeLibraryPath", (PyCFunction)SbkQCoreApplicationFunc_removeLibraryPath, METH_O|METH_STATIC},
    {"removePostedEvents", (PyCFunction)SbkQCoreApplicationFunc_removePostedEvents, METH_VARARGS|METH_STATIC},
    {"removeTranslator", (PyCFunction)SbkQCoreApplicationFunc_removeTranslator, METH_O|METH_STATIC},
    {"sendEvent", (PyCFunction)SbkQCoreApplicationFunc_sendEvent, METH_VARARGS|METH_STATIC},
    {"sendPostedEvents", (PyCFunction)SbkQCoreApplicationFunc_sendPostedEvents, METH_VARARGS|METH_STATIC},
    {"setApplicationName", (PyCFunction)SbkQCoreApplicationFunc_setApplicationName, METH_O|METH_STATIC},
    {"setApplicationVersion", (PyCFunction)SbkQCoreApplicationFunc_setApplicationVersion, METH_O|METH_STATIC},
    {"setAttribute", (PyCFunction)SbkQCoreApplicationFunc_setAttribute, METH_VARARGS|METH_STATIC},
    {"setLibraryPaths", (PyCFunction)SbkQCoreApplicationFunc_setLibraryPaths, METH_O|METH_STATIC},
    {"setOrganizationDomain", (PyCFunction)SbkQCoreApplicationFunc_setOrganizationDomain, METH_O|METH_STATIC},
    {"setOrganizationName", (PyCFunction)SbkQCoreApplicationFunc_setOrganizationName, METH_O|METH_STATIC},
    {"startingUp", (PyCFunction)SbkQCoreApplicationFunc_startingUp, METH_NOARGS|METH_STATIC},
    {"testAttribute", (PyCFunction)SbkQCoreApplicationFunc_testAttribute, METH_O|METH_STATIC},
    {"translate", (PyCFunction)SbkQCoreApplicationFunc_translate, METH_VARARGS|METH_STATIC},
    {0} // Sentinel
};

extern "C"
{

// Class Definition -----------------------------------------------
static SbkBaseWrapperType SbkQCoreApplication_Type = { { {
    PyObject_HEAD_INIT(&Shiboken::SbkBaseWrapperType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "PySide.QtCore.QCoreApplication",
    /*tp_basicsize*/        sizeof(Shiboken::SbkBaseWrapper),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          &Shiboken::SbkBaseWrapper_Dealloc< QCoreApplicationWrapper >,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             0,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              0,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          SbkQCoreApplication_methods,
    /*tp_members*/          0,
    /*tp_getset*/           0,
    /*tp_base*/             0,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             SbkQCoreApplication_Init,
    /*tp_alloc*/            0,
    /*tp_new*/              Shiboken::SbkBaseWrapper_TpNew,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
}, },
    /*mi_offsets*/          0,
    /*mi_init*/             0,
    /*mi_specialcast*/      0,
    /*type_discovery*/      0,
    /*obj_copier*/          0,
    /*ext_isconvertible*/   0,
    /*ext_tocpp*/           0
};

static PyGetSetDef SbkPySide_QtCore_QCoreApplication_Encoding_getsetlist[] = {
    {const_cast<char*>("name"), (getter)Shiboken::SbkEnumObject_name},
    {0}  // Sentinel
};

// forward declaration of new function
static PyObject* SbkPySide_QtCore_QCoreApplication_Encoding_New(PyTypeObject*, PyObject*, PyObject*);

static PyTypeObject SbkPySide_QtCore_QCoreApplication_Encoding_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    /*ob_size*/             0,
    /*tp_name*/             "Encoding",
    /*tp_basicsize*/        sizeof(Shiboken::SbkEnumObject),
    /*tp_itemsize*/         0,
    /*tp_dealloc*/          0,
    /*tp_print*/            0,
    /*tp_getattr*/          0,
    /*tp_setattr*/          0,
    /*tp_compare*/          0,
    /*tp_repr*/             Shiboken::SbkEnumObject_repr,
    /*tp_as_number*/        0,
    /*tp_as_sequence*/      0,
    /*tp_as_mapping*/       0,
    /*tp_hash*/             0,
    /*tp_call*/             0,
    /*tp_str*/              Shiboken::SbkEnumObject_repr,
    /*tp_getattro*/         0,
    /*tp_setattro*/         0,
    /*tp_as_buffer*/        0,
    /*tp_flags*/            Py_TPFLAGS_DEFAULT,
    /*tp_doc*/              0,
    /*tp_traverse*/         0,
    /*tp_clear*/            0,
    /*tp_richcompare*/      0,
    /*tp_weaklistoffset*/   0,
    /*tp_iter*/             0,
    /*tp_iternext*/         0,
    /*tp_methods*/          0,
    /*tp_members*/          0,
    /*tp_getset*/           SbkPySide_QtCore_QCoreApplication_Encoding_getsetlist,
    /*tp_base*/             &PyInt_Type,
    /*tp_dict*/             0,
    /*tp_descr_get*/        0,
    /*tp_descr_set*/        0,
    /*tp_dictoffset*/       0,
    /*tp_init*/             0,
    /*tp_alloc*/            0,
    /*tp_new*/              SbkPySide_QtCore_QCoreApplication_Encoding_New,
    /*tp_free*/             0,
    /*tp_is_gc*/            0,
    /*tp_bases*/            0,
    /*tp_mro*/              0,
    /*tp_cache*/            0,
    /*tp_subclasses*/       0,
    /*tp_weaklist*/         0
};

static PyObject*
SbkPySide_QtCore_QCoreApplication_Encoding_New(PyTypeObject* type, PyObject* args, PyObject* kwds)
{
    int item_value = 0;
    if (!PyArg_ParseTuple(args, "|i:__new__", &item_value))
        return 0;
    PyObject* self = Shiboken::SbkEnumObject_New(type, item_value);

    if (!self)
        return 0;
    return self;
}


PyAPI_FUNC(void)
init_QCoreApplication(PyObject* module)
{
    SbkPySide_QtCoreTypes[SBK_QCOREAPPLICATION_IDX] = reinterpret_cast<PyTypeObject*>(&SbkQCoreApplication_Type);


    SbkQCoreApplication_Type.super.ht_type.tp_base = SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX];
    // Fill type discovery information
    SbkQCoreApplication_Type.type_discovery = reinterpret_cast<SbkBaseWrapperType*>(SbkPySide_QtCoreTypes[SBK_QOBJECT_IDX])->type_discovery;

    if (PyType_Ready((PyTypeObject*)&SbkQCoreApplication_Type) < 0)
        return;

    Py_INCREF(reinterpret_cast<PyObject*>(&SbkQCoreApplication_Type));
    PyModule_AddObject(module, "QCoreApplication",
        ((PyObject*)&SbkQCoreApplication_Type));

    // Initialize enums
    PyObject* enum_item;

    // init enum class: Encoding
    SbkPySide_QtCoreTypes[SBK_QCOREAPPLICATION_ENCODING_IDX] = &SbkPySide_QtCore_QCoreApplication_Encoding_Type;
    if (PyType_Ready((PyTypeObject*)&SbkPySide_QtCore_QCoreApplication_Encoding_Type) < 0)
        return;
    Py_INCREF(&SbkPySide_QtCore_QCoreApplication_Encoding_Type);
    PyDict_SetItemString(SbkQCoreApplication_Type.super.ht_type.tp_dict,
            "Encoding",((PyObject*)&SbkPySide_QtCore_QCoreApplication_Encoding_Type));

    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QCoreApplication_Encoding_Type,
        (long) QCoreApplication::CodecForTr, "CodecForTr");
    PyDict_SetItemString(SbkQCoreApplication_Type.super.ht_type.tp_dict,
        "CodecForTr", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QCoreApplication_Encoding_Type.tp_dict,
        "CodecForTr", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QCoreApplication_Encoding_Type,
        (long) QCoreApplication::UnicodeUTF8, "UnicodeUTF8");
    PyDict_SetItemString(SbkQCoreApplication_Type.super.ht_type.tp_dict,
        "UnicodeUTF8", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QCoreApplication_Encoding_Type.tp_dict,
        "UnicodeUTF8", enum_item);
    enum_item = Shiboken::SbkEnumObject_New(&SbkPySide_QtCore_QCoreApplication_Encoding_Type,
        (long) QCoreApplication::DefaultCodec, "DefaultCodec");
    PyDict_SetItemString(SbkQCoreApplication_Type.super.ht_type.tp_dict,
        "DefaultCodec", enum_item);
    PyDict_SetItemString(SbkPySide_QtCore_QCoreApplication_Encoding_Type.tp_dict,
        "DefaultCodec", enum_item);
    Shiboken::TypeResolver::createValueTypeResolver<int>("QCoreApplication::Encoding");


    Shiboken::TypeResolver::createObjectTypeResolver<QCoreApplication >("QCoreApplication*");
    Shiboken::TypeResolver::createObjectTypeResolver<QCoreApplication >(typeid(QCoreApplication).name());
}


} // extern "C"

namespace Shiboken
{
// Copy C++ object implementation
// Converter implementations
} // namespace Shiboken


