/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "wrapper_manager.hpp"
#include "type_manager.hpp"
#include "type_details.hpp"

using namespace boost;

namespace PySide
{

namespace detail
{

python::object
get_override_from_python(PyObject *wrapper,
                         const char* base_class_name,
                         const char* method_name)
{
    if (wrapper && (wrapper->ob_refcnt))   {
        type_manager& tm = type_manager::instance();
        Q_ASSERT(tm.get_type_details(base_class_name));
        const PyTypeObject* base_class =
                tm.get_type_details(base_class_name)->get_python_type_object();

        PyObject *attr = PyObject_GetAttrString(wrapper, method_name);

        if (PyMethod_Check(attr)) {
            PyMethodObject* methodObj = reinterpret_cast<PyMethodObject*>(attr);
            PyObject* default_method = 0;

            if (methodObj->im_self == wrapper && base_class->tp_dict) {
                default_method =
                        PyDict_GetItemString(base_class->tp_dict,
                                             const_cast<char*>(method_name));
                if (methodObj->im_func != default_method) {
                    return python::object(python::handle<>(attr));
                }
            }
        }

        Py_XDECREF(attr);
    }
    return python::object();
}

} // namespace detail

} // namespace PySide

