#include <qapplication_policy.hpp>
#include <QtCore/QCoreApplication>

using namespace boost;

namespace PySide
{

bool
check_qApp_instance()
{
   return (qApp != 0);
}

void
set_qApp_macro(PyObject *qApp_value, bool initialize)
{
    static PyObject *module_scope = 0;
    static const char* QAPP_MACRO_NAME = "qApp";

    if (module_scope == 0 && initialize) {
        module_scope = boost::python::scope().ptr();
    } else if (module_scope == 0) {
        //not initialize
        return;
    }

    //verify if qApp is in main module
    bool found_in_locals = false;
    PyObject *locals_dict =  PyEval_GetLocals();
    if (locals_dict) {
        PyObject *qapp_dict = PyDict_GetItemString(locals_dict,
                                                   QAPP_MACRO_NAME);
        if (qapp_dict) {
            found_in_locals = true;
            PyDict_SetItemString(locals_dict, QAPP_MACRO_NAME,
                                 qApp_value);
        }
    }

    if (!found_in_locals) {
        PyObject_SetAttrString(module_scope, QAPP_MACRO_NAME,
                               qApp_value);
    }
}

}

