/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __BOOST_HEADERS_HPP__
#define __BOOST_HEADERS_HPP__

# include <boost/python/detail/prefix.hpp>
# include <boost/type_traits/is_polymorphic.hpp>
# include <boost/mpl/bool.hpp>

//WORKAROUND: need export wrapper_base with default visibility always
#pragma GCC visibility push(default)
# include <boost/python/detail/wrapper_base.hpp>
#pragma GCC visibility pop

#include <boost/python.hpp>
#include <boost/python/object/py_function.hpp>
#include <boost/python/raw_function.hpp>
#include <boost/python/slice.hpp>
//Index suite
#include <boost/python/suite/indexing/indexing_suite.hpp>
#include <boost/python/suite/indexing/container_utils.hpp>
#include <boost/python/iterator.hpp>

#endif
