static void
qstandarditemmodel_remove_parent_from_list(QStandardItemModel *model,
                                           const QList<QStandardItem *> &lst)
{
    PySide::qptr<QStandardItemModel> ptr_parent(model);
    foreach(QStandardItem *i, lst)
    {
        PySide::qptr<QStandardItem> ptr_child(i);
        ptr_parent.remove_child(ptr_child);
    }
}

static void
qstandarditemmodel_add_parent_from_list(QStandardItemModel *model,
                                        const QList<QStandardItem *> &lst)
{
    PySide::qptr<QStandardItemModel> ptr_parent(model);

    foreach(QStandardItem *i, lst)
    {
        PySide::qptr<QStandardItem> ptr_child(i);
        ptr_parent.add_child(ptr_child);
    }
}

static QList<QStandardItem *>
qstandarditemmodel_take_column(QStandardItemModel *self, int col)
{
    QList<QStandardItem *> items = self->takeColumn(col);
    qstandarditemmodel_remove_parent_from_list(self, items);
    return items;
}


static QList<QStandardItem *>
qstandarditemmodel_take_row(QStandardItemModel *self, int row)
{
    QList<QStandardItem *> items = self->takeRow(row);
    qstandarditemmodel_remove_parent_from_list(self, items);
    return items;
}

static QList<QStandardItem *>
qstandarditemmodel_find_items(QStandardItemModel *self,
                              const QString &text,
                              Qt::MatchFlags flags,
                              int column)
{
    QList<QStandardItem *> items = self->findItems(text, flags, column);
    qstandarditemmodel_add_parent_from_list(self, items);
    return items;
}

static void
qstandarditemmodel_insert_column(QStandardItemModel *self,
                                 int col,
                                 const QList<QStandardItem *> &items)
{
    self->insertColumn(col, items);
    qstandarditemmodel_add_parent_from_list(self, items);
}

static void
qstandarditemmodel_insert_row(QStandardItemModel *self,
                              int row,
                              const QList<QStandardItem *> &items)
{
    self->insertRow(row, items);
    qstandarditemmodel_add_parent_from_list(self, items);
}

static void
qstandarditemmodel_append_column(QStandardItemModel *self,
                                 const QList<QStandardItem *> &items)
{
    self->appendColumn(items);
    qstandarditemmodel_add_parent_from_list(self, items);
}

static void
qstandarditemmodel_append_row(QStandardItemModel *self,
                              const QList<QStandardItem *> &items)
{
    self->appendRow(items);
    qstandarditemmodel_add_parent_from_list(self, items);
}

static void
qstandarditemmodel_clear(QStandardItemModel *self)
{
    for(int r=0; r < self->rowCount(); r++) {
        QList<QStandardItem *> items = self->takeRow(r);
        qstandarditemmodel_remove_parent_from_list(self, items);
    }
    self->clear();
}
