/**
 * Help function to add a menu action
 **/
static python::object
qmenu_add_action_full(QMenu *self,
                      QAction **action,
                      const QString &text,
                      const QKeySequence &shortcut,
                      const QIcon &icon)
{
    *action = self->addAction(text);
    python::object py_action(PySide::ptr(*action));

    if (!shortcut.isEmpty())
    {
        (*action)->setShortcut(shortcut);
    }

    if (!icon.isNull())
    {
        (*action)->setIcon(icon);
    }

    PySide::qptr<QMenu> ptr_self(self);
    PySide::qptr<QAction> ptr_action(py_action.ptr());

    ptr_self.add_child(ptr_action);

    return py_action;
}

/**
 * Enable support a pythonic way to add menu action
 * Ex: menu.add_action("action-name", python-callback, shortcut = None, icon =None)
 **/
static python::object
qmenu_add_action_full(QMenu *self,
                      const QString &text,
                      python::object &callback,
                      const QKeySequence &shortcut,
                      QIcon icon)
{
    QAction *action;
    python::object py_action = qmenu_add_action_full(self,
                                                     &action,
                                                     text,
                                                     shortcut,
                                                     icon);
    signal_manager::instance().connect(action,
                                       pyqt_signal("triggered()"),
                                       callback);
    return py_action;
}

static python::object
qmenu_add_action_full(QMenu *self,
                      const QString &text,
                      QObject &receiver,
                      const pyqt_slot &callback,
                      const QKeySequence &shortcut,
                      const QIcon &icon)
{
    QAction *action;
    python::object py_action = qmenu_add_action_full(self,
                                                     &action,
                                                     text,
                                                     shortcut,
                                                     icon);
    signal_manager::instance().connect(action,
                                       pyqt_signal("triggered()"),
                                       &receiver,
                                       callback);
    return py_action;
}

static python::object
qmenu_add_action(QMenu *self,
                 const QString &text,
                 python::object &callback,
                 const QKeySequence &shortcut)
{
    return qmenu_add_action_full(self, text, callback, shortcut, QIcon());
}

static python::object
qmenu_add_action_with_icon(QMenu *self,
                           const QIcon &icon,
                           const QString &text,
                           python::object callback,
                           const QKeySequence &shortcut)
{
    return qmenu_add_action_full(self, text, callback, shortcut, icon);
}

/**
 * Enable support a pythonic way to add menu action
 * Ex: menu.add_action("action-name", object, SLOT("slot-name"), shortcut = None, Icon = None)
 **/
static python::object
qmenu_add_action_slot(QMenu *self,
                      const QString &text,
                      QObject &receiver,
                      const pyqt_slot &callback,
                      const QKeySequence &shortcut)
{
    return qmenu_add_action_full(self,
                                 text,
                                 receiver,
                                 callback,
                                 shortcut,
                                 QIcon());
}

static python::object
qmenu_add_action_slot_with_icon(QMenu *self,
                                const QIcon &icon,
                                const QString &text,
                                QObject &receiver,
                                const pyqt_slot &callback,
                                const QKeySequence &shortcut)
{
    return qmenu_add_action_full(self,
                                 text,
                                 receiver,
                                 callback,
                                 shortcut,
                                 icon);
}
