/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __HANDLE_POLICY_HPP__
#define __HANDLE_POLICY_HPP__

#include "boost_headers.hpp"
#include "qhandle.hpp"

namespace PySide
{

/**
 * Used to create a PyObject from a Qt::HANDLE
 **/
struct PYSIDE_API make_qhandle_holder
{
    inline PyObject*
    operator()(const Qt::HANDLE& ref) const
    {
        qhandle *qh = new qhandle(const_cast<Qt::HANDLE&>(ref));
        boost::python::object py_obj(qh);
        return boost::python::incref(py_obj.ptr());
    }

#ifndef BOOST_PYTHON_NO_PY_SIGNATURES
    inline PyTypeObject const*
    get_pytype()const
    {
        return boost::python::converter::registered_pytype<qhandle>::get_pytype();
    }
#endif
};


/**
 **/
struct PYSIDE_API return_QHANDLE
{
    template<class T>
    struct apply
    {
        typedef typename boost::mpl::if_c<
            boost::is_pointer<T>::value
            , make_qhandle_holder
            , boost::python::to_python_value<qhandle>
        >::type type;
    };
};


} //namespace PySide

#endif

