/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __TYPEMANAGER_H__
#define __TYPEMANAGER_H__

#include <iostream>
#include <memory>

#include <QtCore/QDebug>
#include <QtCore/QHash>
#include <QtCore/QString>
#include <QtCore/QGenericArgument>
#include <QtCore/QSet>
#include <iostream>
#include <typeinfo>

#include <pyside_global.hpp>
#include <type_details.hpp>
#include <boost_headers.hpp>

namespace PySide
{

class PYSIDE_API type_manager
{
public:
    static type_manager& instance();
    ~type_manager();

    boost::python::object to_python(const QString &name, void *data);
    QGenericArgument to_cpp(const QString &name, const boost::python::object &obj);
    void delete_data(QGenericArgument &arg);

    template<typename T>
    void PYSIDE_LOCAL
    register_object_type(const char* type_name)
    {
        m_type_map[type_name] = type_details::create_object_type_details<T>(type_name);
    }

    template<typename T>
    void PYSIDE_LOCAL
    register_value_type(const char* type_name)
    {
        m_type_map[type_name] = type_details::create_value_type_details<T>(type_name);
    }

    template<typename T>
    void PYSIDE_LOCAL
    register_native_type(const char* type_name)
    {
        m_type_map[type_name] = type_details::create_native_type_details<T>(type_name);
    }

    template<typename T>
    void PYSIDE_LOCAL
    register_container_type(const char* type_name)
    {
        m_type_map[type_name] = type_details::create_container_type_details<T>(type_name);
    }

    // TODO Remove this function and the m_registered_converters collection
    bool PYSIDE_LOCAL
    register_converter(const char* type_name) {
        QString key(type_name);
         if (m_registered_converters.contains(key))
            return false;
         m_registered_converters << key;
         return true;
    }

    const type_details*
    get_type_details(const char* type_name)
    {
        return m_type_map[type_name];
    }


private:
    QSet<QString> m_registered_converters;
    QHash<QString, type_details* > m_type_map;
    type_manager();
    type_manager(const type_manager&);
};

} // namespace PySide

#endif

