python_cls
    /**[sphinx-begin]
     *
     *  .. method:: QApplication.setStyle(style)
     *      .. param: style - QStyle
     *
     * Sets the application's GUI style to style. Ownership of the style object is transferred to QApplication, so QApplication will delete the style object on application exit or when a new style is set and the old style is still the parent of the application object.
     * When switching application styles, the color palette is set back to the initial colors or the system defaults. This is necessary since certain styles have to adapt the color palette to be fully style-guide compliant.
     * Setting the style before a palette has been se, i.e., before creating QApplication, will cause the application to use QStyle::standardPalette() for the palette.
     * Warning: Qt style sheets are currently not supported for custom QStyle subclasses. We plan to address this in some future release.
     *
     [sphinx-end]**/
    .def("setStyle", qapplication_set_style)
    /**[sphinx-begin]
     *
     *  .. method:: QApplication.style()
     *      .. return-type: QStyle
     *
     * Returns the application's style object.
     [sphinx-end]**/
    .def("style", qapplication_style)
    .staticmethod("setStyle")
    .staticmethod("style");

// Destroy qApplication when python interperter dies
Py_AtExit(delete_qapplication_at_exit);
