/**
 * This function need be implemented manually because
 * this take ownership o QTranslator in a static function
 * and this does not supported by boost::python.
 **/
static void
_qcoreapplication_install_translator(QTranslator *t)
{
    python::object parent(PySide::ptr(qApp));
    python::object child(PySide::ptr(t));

    PySide::qptr<QCoreApplication> ptr_parent(parent.ptr());
    PySide::qptr<QTranslator> ptr_child(child.ptr());

    ptr_parent.add_child(ptr_child);

    QCoreApplication::installTranslator(t);
}

static void
_qcoreapplication_remove_translator(QTranslator *t)
{
    python::object parent(PySide::ptr(qApp));
    python::object child(PySide::ptr(t));

    PySide::qptr<QCoreApplication> ptr_parent(parent.ptr());
    PySide::qptr<QTranslator> ptr_child(child.ptr());

    ptr_parent.remove_child(ptr_child);

    QCoreApplication::removeTranslator(t);
}

/**
 * Pythonic QCoreApplication constructor
 **/
qcoreapplication_wrapper::qcoreapplication_wrapper(PyObject *py_self, const python::list &args)
    : QCoreApplication(PySide::app_argc, PySide::app_argv), wrapper(py_self)
{
}


/**
 * Avoid delete QCoreApplication before others objects
 **/
void delete_pointer(qcoreapplication_wrapper *p)
{
}

/**
 * Called at QtCore module exit
 */
void delete_qcoreapplication_at_exit() {
    if (QCoreApplication::instance()) {
        delete QCoreApplication::instance();
    }
}
