/**
 * This code is used to handle parent control in QAnimationGroup::clear because we need remove
 * all children from current QAnimationGroup instance in PySide object ownership control
 **/

static void
qanimation_group_clear_animations(QAnimationGroup &self)
{
    PySide::qptr<QAnimationGroup> ptr_parent(&self);

    //remove the old ones
    for(int i=0; i < self.animationCount(); i++) {
        python::object obj(PySide::ptr(self.animationAt(i)));
        PySide::qptr<QAbstractAnimation> ptr_item(obj.ptr());
        ptr_parent.remove_child(ptr_item);
    }

    self.clear();
}
