import unittest
import sys

from PySide.QtCore import *
from DummyBinding import DummyObject

class EmitPythonList(unittest.TestCase):

    def setUp(self):
        self.callbackCalled = False
        self.callbackArg = None

    def callback(self, arg):
        self.callbackCalled = True
        self.callbackArg = arg

    def testEmitSignal(self):
        obj = DummyObject()
        arg = [1, 2, 3]
        obj.connect(SIGNAL("intList(const QList<int>&)"), self.callback)
        obj.emit(SIGNAL("intList(const QList<int>&)"), arg)
        self.assertEqual(self.callbackArg, arg)

if __name__ == '__main__':
    unittest.main()
