/*
 * This file is part of PySide: Python for Qt
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#ifndef __DECLARE_QFLAGS_HPP__
#define __DECLARE_QFAGS_HPP__

#include <boost_headers.hpp>
#include <pyside_global.hpp>

namespace PySide
{

template< typename FLAG >
void PYSIDE_LOCAL declare_qflags(const char *flag_name)
{
    boost::python::class_< FLAG >(flag_name, boost::python::init<const FLAG&>())
        .def(boost::python::init< boost::python::optional< int > >())
        .def(boost::python::init< typename FLAG::enum_type >())
        .def(boost::python::self & int())
        .def(boost::python::self == boost::python::self)
        .def(boost::python::self == int())
        .def(boost::python::self &= int())

        .def(int_(boost::python::self))

        .def(~boost::python::self)
        .def(boost::python::self |= boost::python::self)
        .def(boost::python::self ^= boost::python::self)
        .def(boost::python::self != boost::python::self)
        .def(!boost::python::self)
        .def(boost::python::self | boost::python::self)
        .def(boost::python::self ^ boost::python::self)

        ;


    boost::python::implicitly_convertible<int, FLAG >();
}

template< typename FLAG >
void PYSIDE_LOCAL declare_int_qflags(const char *flag_name)
{
    boost::python::class_< FLAG >(flag_name, boost::python::init<const FLAG&>())
        .def(boost::python::init< boost::python::optional< int > >())
        .def(boost::python::init< typename FLAG::enum_type >())
        .def(boost::python::self & int())
        .def(boost::python::self &= int())

        .def(int_(boost::python::self))

        .def(~boost::python::self)
        .def(boost::python::self |= boost::python::self)
        .def(boost::python::self ^= boost::python::self)
        .def(!boost::python::self)
        .def(boost::python::self | boost::python::self)
        .def(boost::python::self ^ boost::python::self)

        ;


    boost::python::implicitly_convertible<typename FLAG::enum_type, FLAG >();
}

}; //namespace PySide


#endif
