//Thread support
thread_support::init();

python::def("qRegisterResourceData",
    ((bool (*)(int, const char *, const char *, const char *))qRegisterResourceData));
python::def("qUnregisterResourceData",
    ((bool (*)(int, const char *, const char *, const char *))qUnregisterResourceData));

// signal and slot functions
python::def("SIGNAL", &signal_normalizer);
python::def("SLOT", &slot_normalizer);

// qAbs is a template
python::def("qAbs", qAbs<float>);
python::def("qAbs", qAbs<int>);

/**
 * qDebug, qWarning, etc...
 * first function pointer cast is for GCC, so it can find the correct function.
 * second function pointer cast is for boost python, because it does
 * not know how to handle functions with variable number of arguments.
 **/
python::def("qDebug",
    (void (*)(const char*)) ((void (*)(const char*, ...))qDebug));
python::def("qWarning",
    (void (*)(const char*)) ((void (*)(const char*, ...))qWarning));
python::def("qFatal",
    (void (*)(const char*)) ((void (*)(const char*, ...))qFatal));
python::def("qCritical",
    (void (*)(const char*)) ((void (*)(const char*, ...))qCritical));

// Translate functions
python::def("QT_TR_NOOP", &QT_TR_NOOP_WRAPPER);
python::def("QT_TR_NOOP_UTF8", &QT_TR_NOOP_UTF8_WRAPPER);
python::def("QT_TRANSLATE_NOOP", &QT_TRANSLATE_NOOP_WRAPPER);
python::def("QT_TRANSLATE_NOOP_UTF8", &QT_TRANSLATE_NOOP_UTF8_WRAPPER);

//QtVersion macro
python::scope().attr("QT_VERSION") = QT_VERSION;
python::scope().attr("QT_VERSION_STR") = QT_VERSION_STR;

