#!/usr/bin/python2.5
import sys,time
import re

from subprocess import Popen,PIPE

from PyQt4 import QtGui,QtCore
from PyQt4.QtGui import *
from pyPianobar_ui import *

class tPandora(QtCore.QThread):

	__pyqtSignals__ = ( "stations","newsong", "showUsername", "showPassword", "oops", "second" )

	def __init__(self):
		self.sTitle = ""
		self.sArtist = ""
		self.sAlbum = ""
		self.sLike = ""
		self.last = ""
		self.playing = 0
		self.drun = 1
		self.stations = [""] 
		self.length = ""
		QtCore.QThread.__init__(self)

	def run(self):
		self.pandora = Popen("pianobar",stdout=PIPE,stdin=PIPE)
		newline = ""
		listStation = 0
		while self.drun:
			char = self.pandora.stdout.read(1)
			newline += char
			if re.match(".+Username$",newline) is not None and "Error" not in newline:
				self.emit(QtCore.SIGNAL("showUsername"), self.sTitle)
				self.last = "username"
					
			if re.match(".+Password$",newline) is not None:
				self.emit(QtCore.SIGNAL("showPassword"), self.sTitle)
				self.last = "password"

			if "Error:" in newline:
				self.emit(QtCore.SIGNAL("oops"))
				self.drun = 0

			elif char == "\n":
				output = newline.split("|>")
				newline = ""
				for line in output:
					if line == "":
						continue
					title = re.match(".+\"(.+)\".+by.+\"(.+)\".+on.+\"(.+)\"(.*)",line)
					stations = re.match("\s+(\d+)\)\s+[Q|q|\s]\s+(.+)$",line)
						
					if stations is not None:
						if len(self.stations) > int(stations.group(1)):
							self.stations[int(stations.group(1))] = stations.group(2)
						else:
							self.stations.append(stations.group(2))

						self.last = "stations"	
						self.emit(QtCore.SIGNAL("stations"), self.sTitle)
						
					
					if title is not None:
						self.sTitle = title.group(1)
						self.sArtist = title.group(2)
						self.sAlbum = title.group(3)
						if re.match(".+\<3",title.group(4)):
							self.sLike = 1
						else:
							self.sLike = 0
						
						if not self.playing:
							self.playing = 1
	
						self.last = "song"
						self.emit(QtCore.SIGNAL("newsong"), self.sTitle)
		
			elif re.match("^.+(\d+\:\d+)\/(\d+\:\d\d)$",newline):
				time = re.match("^.+(\d+\:\d+)\/(\d+\:\d\d)$",newline)
				self.length = time.group(1)+"/"+time.group(2)
				self.emit(QtCore.SIGNAL("second"))
				newline = ""
			else:
				continue

class MyForm(QtGui.QMainWindow):
	def __init__(self, parent=None):
		QtGui.QWidget.__init__(self, parent)
		self.station = 0;
		self.ui = Ui_MainWindow()
		self.ui.setupUi(self)
		self.p = tPandora()
		self.p.start()
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('newsong'), self.newsong)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('stations'), self.stations)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('oops'), self.doError)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('showUsername'), self.showUsername)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('showPassword'), self.showPassword)
		QtCore.QObject.connect(self.p, QtCore.SIGNAL('second'), self.uSecond)
		QtCore.QObject.connect(self.ui.btnLove, QtCore.SIGNAL('clicked()'), self.doLove)
		QtCore.QObject.connect(self.ui.btnHate, QtCore.SIGNAL('clicked()'), self.doHate)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('clicked()'), self.doNext)
		QtCore.QObject.connect(self.ui.btnPlay, QtCore.SIGNAL('clicked()'), self.doPlayPause)
		QtCore.QObject.connect(self.ui.btnSleep, QtCore.SIGNAL('clicked()'), self.sQuit)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('pressed()'), self.nextActive)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('released()'), self.nextInactive)
		QtCore.QObject.connect(self.ui.listStations, QtCore.SIGNAL('itemDoubleClicked(QListWidgetItem *)'), self.setStation)

	def stations(self):
		self.ui.listStations.clear()
		for station in self.p.stations:
			self.ui.listStations.addItem(station)
			self.ui.listStations.setCurrentRow(self.station)

	def setStation(self, listaItem):
		if self.p.last == "song":
			self.p.pandora.stdin.write("s")
		
		self.station = self.ui.listStations.currentRow()
		self.p.pandora.stdin.write(str(self.ui.listStations.currentRow())+"\n")
		self.ui.btnPlay.setStyleSheet("background-image: url(:/img/img/playing.png);")

	def uSecond(self):
		self.ui.lblTime.setText(self.p.length)

	def nextActive(self):
		self.ui.btnNext.setStyleSheet("background-image: url(:/img/img/skip-active.png);")

	def nextInactive(self):
		self.ui.btnNext.setStyleSheet("background-image: url(:/img/img/skip.png);")

	def newsong(self):
		self.ui.lblSong.setText(self.p.sTitle)
		self.ui.lblArtist.setText("by: " + self.p.sArtist)
		self.ui.lblAlbum.setText("on: " + self.p.sAlbum)
		if self.p.sLike:
			self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/plus-active.png);")
		else:
			self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/plus.png);")
		
	def doLove(self):
		self.p.pandora.stdin.write("+")
		self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/plus-active.png);")
		
	def doHate(self):
		self.p.pandora.stdin.write("-")

	def doNext(self):
		self.p.pandora.stdin.write("n")

	def doPlayPause(self):
		self.p.pandora.stdin.write("p")
		if self.p.last == "stations":
			self.p.pandora.stdin.write(str(self.ui.listStations.currentRow())+"\n")

		if self.p.playing:
			self.ui.btnPlay.setStyleSheet("background-image: url(:/img/img/paused.png);")
			self.p.playing = 0
		else:
			self.ui.btnPlay.setStyleSheet("background-image: url(:/img/img/playing.png);")
			self.p.playing = 1
	
	def sQuit(self):
		self.p.drun = 0
		self.p.pandora.stdin.write('\nq')
		self.p.pandora.wait()
		self.p.exit()
		self.doQuit()
	
	def doError(self):
		ok = QtGui.QMessageBox.warning( self, "Pianobar Error", "Pianobar experienced an error.  We are closing.", QtGui.QMessageBox.Ok )
		self.p.drun = 0
		self.doQuit()
		
	def doQuit(self):
		quit()


	def showUsername(self):
		username,ok = QtGui.QInputDialog.getText(self,"Username", "Pandora Username:")
		if ok:
			self.p.pandora.stdin.write(username+"\n")
		else:
			self.p.drun = 0
			self.p.pandora.stdin.write('\')
			self.doQuit()
	
	def showPassword(self):
		password,ok = QtGui.QInputDialog.getText(self,"Password", "Pandora Password:",QLineEdit.Password)
		if ok:
			self.p.pandora.stdin.write(password+"\n")
		else:
			self.p.drun = 0
			self.p.pandora.stdin.write('\')
			self.close()
			self.doQuit()

if __name__ == "__main__":
	app = QtGui.QApplication(sys.argv)
	myapp = MyForm()
	myapp.show()
	sys.exit(app.exec_())
