#! /usr/bin/env python
#! coding=utf-8

APP_TITLE="pyKake"
APP_VERSION="0.6.0"
CONFPATH = "/apps/Maemo/%s/" % APP_TITLE.lower()
LOGO = '/opt/pykake/pykake.png'

import gtk, hildon, subprocess, gobject, time, gconf, gst, threading, pango

# Global variables
CURRENT_REMOTETYPE= ""
TIME2BEEB = "" # Interwall of beebs (if counting up)
beeb = "file:/opt/pykake/sounds/bell.wav" # Sound file of beeb
alert = "file:/opt/pykake/sounds/drums.wav" # Sound file of alert

bulbStatus = False  # On/Off told is this first or second time button hitted in bulb
mod2sec = False # Told Canon (in bulbmode) should it use 2sec delay or not
timeAdded = False # Told that is there time added in Counter or not
minutes = 0 # How many minutes user wants to keep shutter open in bulb
seconds = 0.0   # If need some Seconds more in bulb mode :p
timeSeconds = 0.0 # control timers beeb time
globURI = "" # File to play
beebRun = False # Duct tape solution
gobjid = 0

# Layouting
fontLabel = pango.FontDescription("Sans 20")
fontButt = pango.FontDescription("Sans Bold 25")
fontTimer = pango.FontDescription("Monotype Bold 35")

# Texts, used in program
LICENCE = """This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public
License along with this program.   If not, see
<http://www.gnu.org/licenses/>."""

SETTINGS = """In settings you can change between camera manufacturers and interval of sound notice in Bulb timer. Sound notice is played when selected amount of time is ellapsed, default setting of this is 30 seconds. You can also turn restart notify in start up on and off."""

BASIC = """In this mode you can take photos, just click the "Shutter" button. For Canon, there is also "Activate/Deactivate 2sec mode" button, when it is activated, photos with 2 seconds interval can be taken (in other manufacturers you had to select this function from camera)."""

BULB = """\nThis is front end to take photos with Bulb. As default timer will count up and it will play sound notify when selected time is elapsed. You can also set it counting down and it will play sound when time is up. \nThe app won't send the end command to the camera automatically so you had to do it yourself, with Bulb off button. Timer don't understand 2 sec delay, so you must to count it by yourself.\n"""

VIEWER = """Viewer is only available for Olympus. You can use this to remote control your camera in View mode to zoom and change photos. This is handy if you watch pictures in TV."""

REMOTES = """Currently pyKake support following remotes from manufacturers them:\n   Canon: RC-1\n   Nikon: ML-L3\n   Olympus: RM-1\n   Pentax: RC-F"""

MESSAGE = """If this is first time you use pyKake after install, it is possible that you need to restart the device before pyKake can send infrared signals. To test this, put your camera in live view mode, aim the device to the camera and press shutter button in pyKake, if you don't se light plinking in infrared port, you need to restart."""

class pykakeGui:
    def __init__(self):
	global CURRENT_REMOTETYPE, TIME2BEEB
	miscFuncs().controlLircd("start") # Start Lirc in start-up
	# Loading needed info from gconf
	CURRENT_REMOTETYPE = miscFuncs().confReader("remote")
	TIME2BEEB = miscFuncs().confReader("beebtime")
	self.mainWindow()
	helpfile = miscFuncs().confReader("help_show")
	if helpfile != "False":
	    dialogWindows().messageDialog("open")
	if not CURRENT_REMOTETYPE and not TIME2BEEB: # Opening settings dialog, if first start
	    self.settingsDialog("open")

    # WINDOWS 
    def mainWindow(self):  # Window to select between modes
	program = hildon.Program.get_instance()
	win = hildon.StackableWindow()
	win.set_title("%s v.%s" % (APP_TITLE, APP_VERSION))
	win.connect('destroy', self.destroy)
	win.set_border_width(0)
	menu = self.mainMenu()
	win.set_app_menu(menu)
	vbox = gtk.VBox(False, 0)
	win.add(vbox)
	label = gtk.Label("Select mode:")
	label.modify_font(fontLabel)
	vbox.pack_start(label, False, True, 0)
	hbox = gtk.HBox(False, 10)
	vbox.pack_start(hbox, True, True, 0)
	self.butt1 = gtk.Button("Basic")
	self.butt1.child.modify_font(fontButt)
	self.butt1.connect('clicked', self.singleShot, None)
	hbox.pack_start(self.butt1, True, True, 0)
	self.butt2 = gtk.Button("Bulb")
	self.butt2.child.modify_font(fontButt)
	self.butt2.connect('clicked', self.bulbMode, None)
	hbox.pack_start(self.butt2, True, True, 0)
	self.butt3 = gtk.Button("Viewer")
	self.butt3.child.modify_font(fontButt)
	self.butt3.connect('clicked', self.viewerMode, None)
	vbox.pack_start(self.butt3, True, True, 0)
	win.show_all()
	if CURRENT_REMOTETYPE != "Olympus_RM-1":
	    self.butt3.hide()

    def singleShot(self, widget, data): # Mode to just take photos
	win = hildon.StackableWindow()
	win.set_title("%s v.%s" %(APP_TITLE, APP_VERSION))
	win.connect('delete_event', self.deleteChild, "single")
	win.set_border_width(0)
	menu=self.mainMenu()
	win.set_app_menu(menu)
	vbox = gtk.VBox(False, 0)
	win.add(vbox)
	label = gtk.Label("Single shoot mode")
	label.modify_font(fontLabel)
	vbox.pack_start(label, False, True, 0)
	hbox = gtk.HBox(True, 0)
	vbox.pack_start(hbox, True, True, 0)
	self.butt4 = gtk.Button("Shutter")
	self.butt4.child.modify_font(fontButt)
	self.butt4.connect('clicked', self.buttonClicked, "shutter")
	hbox.pack_start(self.butt4, True, True, 0)
	self.buttMod2sec = gtk.Button("Activate 2sec mode")
	self.buttMod2sec.child.modify_font(fontButt)
	self.buttMod2sec.connect('clicked', self.mode2sec,"5")
	hbox.pack_start(self.buttMod2sec, True, True, 0)
	win.show_all()
	if CURRENT_REMOTETYPE != "CANON-RC1/RC5":
	    self.buttMod2sec.hide()

    def bulbMode(self, widget, data): # Mode to use bulb
	win = hildon.StackableWindow()
	win.set_title("%s v.%s" %(APP_TITLE, APP_VERSION))
	win.connect('delete_event', self.deleteChild, "bulb")
	win.set_border_width(0)
	menu=self.mainMenu()
	win.set_app_menu(menu)
	vbox1 = gtk.VBox(False, 0)
	win.add(vbox1)
	label = gtk.Label("Bulb mode:")
	label.modify_font(fontLabel)
	vbox1.pack_start(label, False, True, 0)
	hbox = gtk.HBox(False, 0)
	vbox1.pack_start(hbox, True, True, 0)
	self.buttBulb = gtk.Button("Bulb On")
	self.buttBulb.child.modify_font(fontButt)
	self.buttBulb.connect('clicked', self.buttonClicked, "bulb")
	hbox.pack_start(self.buttBulb, True, True, 0)
	vbox2 = gtk.VBox(True, 0)
	hbox.pack_start(vbox2, True, True, 0)
	aspFrame = gtk.AspectFrame()
	self.timerLabel = gtk.Label("0:00")
	self.timerLabel.modify_font(fontTimer)
	self.timerLabel.set_padding(10, 5)
	aspFrame.add(self.timerLabel)
	vbox2.pack_start(aspFrame, True, True, 0)
	self.butt7 = gtk.Button("Add time")
	self.butt7.child.modify_font(fontButt)
	self.butt7.connect('clicked', self.timerDialog, win)
	vbox2.pack_start(self.butt7, True, True, 0)
	self.buttMod2sec = gtk.Button("Activate 2sec mode")
	self.buttMod2sec.child.modify_font(fontButt)
	self.buttMod2sec.connect('clicked', self.mode2sec, "8")
	vbox2.pack_start(self.buttMod2sec, True, True, 0)
	win.show_all()
	if CURRENT_REMOTETYPE != "CANON-RC1/RC5":
	    self.buttMod2sec.hide()

    def viewerMode(self,widget,data): # Mode to show photos remotely
	win = hildon.StackableWindow()
	win.set_title("%s v.%s" %(APP_TITLE, APP_VERSION))
	win.connect('delete_event', self.deleteChild, "viewer")
	win.set_border_width(0)
	menu = self.mainMenu()
	win.set_app_menu(menu)
	vbox = gtk.VBox(False, 0)
	win.add(vbox)
	label = gtk.Label("Viewer mode")
	label.modify_font(fontLabel)
	vbox.pack_start(label, False, True, 0)
	hbox1 = gtk.HBox(True, 0)
	vbox.pack_start(hbox1, True, True, 0)
	hbox2 = gtk.HBox(True, 0)
	vbox.pack_start(hbox2, True, True, 0)
	self.butt9 = gtk.Button("Zoom In")
	self.butt9.child.modify_font(fontButt)
	self.butt9.connect('clicked',self.buttonClicked, "zoomin")
	hbox1.pack_start(self.butt9, True, True, 0)
	self.butt10 = gtk.Button("Zoom Out")
	self.butt10.child.modify_font(fontButt)
	self.butt10.connect('clicked',self.buttonClicked, "zoomout")
	hbox2.pack_start(self.butt10, True, True, 0)
	self.butt11 = gtk.Button("Previous")
	self.butt11.child.modify_font(fontButt)
	self.butt11.connect('clicked', self.buttonClicked, "previous")
	hbox1.pack_start(self.butt11, True, True, 0)
	self.butt12 = gtk.Button("Next")
	self.butt12.child.modify_font(fontButt)
	self.butt12.connect('clicked', self.buttonClicked, "next")
	hbox2.pack_start(self.butt12, True, True, 0)
	win.show_all()

    # WINDOW FUNCS
    def deleteChild(self, widget, event, data):
	global mod2sec
	mod2sec = False

    def destroy(self, event):
	miscFuncs().controlLircd("stop") # Stop Lirc in shut-down
	gtk.main_quit()

    def buttControl(self):
	if CURRENT_REMOTETYPE == "Olympus_RM-1":
	    self.butt3.show()
	else:
	    self.butt3.hide()
	try:
	    if CURRENT_REMOTETYPE == "CANON-RC1/RC5":
		self.buttMod2sec.show()
	    else:
		self.buttMod2sec.hide()
	except Exception:
	    pass

    # MAIN MENU
    def mainMenu(self):
	menu = hildon.AppMenu()
	mbutt1 = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
	mbutt1.set_label("Settings")
	mbutt1.connect('clicked', self.settingsDialog)
	menu.append(mbutt1)
	mbutt2 = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
	mbutt2.set_label("About")
	mbutt2.connect('clicked', dialogWindows().aboutDialog)
	menu.append(mbutt2)
	mbutt3 = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
	mbutt3.set_label("Help")
	mbutt3.connect('clicked', dialogWindows().helpDialog)
	menu.append(mbutt3)
	menu.show_all()
	return menu
	
    def settingsDialog(self, widget):
	global CURRENT_REMOTETYPE, TIME2BEEB
	settings = gtk.Dialog("Settings", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
	save = settings.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
	vbox = gtk.VBox()
	selector = hildon.TouchSelector()
	selector.add(vbox)

	# Selecting remote
	canon = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, None)
	canon.set_label("Canon")
	canon.set_mode(False)
	nikon = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, canon)
	nikon.set_label("Nikon")
	nikon.set_mode(False)
	olympus = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, canon)
	olympus.set_label("Olympus")
	olympus.set_mode(False)
	pentax = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, canon)
	pentax.set_label("Pentax")
	pentax.set_mode(False)

	if CURRENT_REMOTETYPE == "CANON-RC1/RC5":
	    canon.set_active(True)
	elif CURRENT_REMOTETYPE == "NikonDSLR":
	    nikon.set_active(True)
	elif CURRENT_REMOTETYPE == "Olympus_RM-1":
	    olympus.set_active(True)
	elif CURRENT_REMOTETYPE == "Pentax_RC-F":
	    pentax.set_active(True)
	else:
	    canon.set_active(True) # Default

	label1 = gtk.Label("Select camera:")

	hbox1 = gtk.HBox()
	hbox1.pack_start(canon, True, True, 0)
	hbox1.pack_start(nikon, True, True, 0)
	hbox1.pack_start(olympus, True, True, 0)
	hbox1.pack_start(pentax, True, True, 0)
	vbox.pack_start(label1, False, False, 0)
	vbox.pack_start(hbox1, True, True, 0)

	# Selecting timer beeb interwall
	label2 = gtk.Label("Select time interval for beebs:")
	t30sec = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, None)
	t30sec.set_label("30 Sec")
	t30sec.set_mode(False)
	t1min = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, t30sec)
	t1min.set_label("1 Min")
	t1min.set_mode(False)
	t10min = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, t30sec)
	t10min.set_label("10 Min")
	t10min.set_mode(False)
	tOff = hildon.GtkRadioButton(gtk.HILDON_SIZE_AUTO, t30sec)
	tOff.set_label("Off")
	tOff.set_mode(False)

	if TIME2BEEB == 30:
	    t30sec.set_active(True)
	elif TIME2BEEB == 60:
	    t1min.set_active(True)
	elif TIME2BEEB == 600:
	    t10min.set_active(True)
	elif TIME2BEEB == 0:
	    tOff.set_active(True)
	else:
	    t30sec.set_active(True) # Default

	vbox.pack_start(label2, False, False, 0)
	hbox2 = gtk.HBox()
	vbox.pack_start(hbox2, True, True, 0)
	hbox2.pack_start(t30sec, True, True, 0)
	hbox2.pack_start(t1min, True, True, 0)
	hbox2.pack_start(t10min, True, True, 0)
	hbox2.pack_start(tOff, True, True, 0)
	
	label = gtk.Label("")
	vbox.pack_start(label, True, True, 0)
	bool = dialogWindows().checkStatus()
	message = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
	message.set_label("Show restart notify in start up")
	message.set_active(bool)
	message.connect("clicked", dialogWindows().checkButton)
	vbox.pack_start(message, True, True, 0)	
	
	settings.vbox.add(selector)
	settings.show_all()
	response = settings.run()

	# Adding new settings in gConf
	if response == gtk.RESPONSE_OK:
	    # Adding remote in gconf
	    cameragroup = canon.get_group()
	    label = ""
	    for button in cameragroup:
		selected = button.get_active()
		if selected == True:
		    label = button.get_label()
		    break
	    remoteDict = {"Canon":"CANON-RC1/RC5", "Nikon":"NikonDSLR", "Olympus":"Olympus_RM-1", "Pentax":"Pentax_RC-F"}
	    miscFuncs().confAdder("remote", remoteDict[label])

	    # Adding beeb time in gconf
	    timergroup = t30sec.get_group()
	    for button in timergroup:
		selected = button.get_active()
		if selected == True:
		    label = button.get_label()
		    break
	    timeDict = {"Off":0, "30 Sec":30, "1 Min":60, "10 Min":600}
	    miscFuncs().confAdder("beebtime", timeDict[label])

	    self.buttControl() # Show hide buttons, if needed

	settings.destroy()
	
    def main(self):
	gtk.main()

    # BUTTON FUNCS
    def buttonClicked(self, widget, data): # Function to direct button clicks in correct address. (To avoid all non-needed code in GUIs.)
	if data == "bulb": # This function will change outfit of bulb button between Bulb On and Bulb Off. It will modify the data send to Olympus.
	    global bulbStatus
	    if bulbStatus == False:
		self.buttBulb.set_label("Bulb Off")
		self.buttBulb.child.modify_font(fontButt)
		self.timer()
		bulbStatus = True
		if CURRENT_REMOTETYPE == "Olympus_RM-1" or CURRENT_REMOTETYPE == "Pentax_RC-F":
		    data = "bulbon"
	    else:
		self.buttBulb.set_label("Bulb On")
		self.buttBulb.child.modify_font(fontButt)
		self.timerStop()
		bulbStatus = False
		if CURRENT_REMOTETYPE == "Olympus_RM-1" or CURRENT_REMOTETYPE == "Pentax_RC-F":
		    data = "bulboff"

	if CURRENT_REMOTETYPE == "Olympus_RM-1":
	    digitalCamera().olympus(data)
	elif CURRENT_REMOTETYPE == "CANON-RC1/RC5":
	    digitalCamera().canon()
	elif CURRENT_REMOTETYPE == "Pentax_RC-F":
	    digitalCamera().pentax(data)
	else:
	    digitalCamera().oneButtonRemotes(CURRENT_REMOTETYPE)

    def mode2sec(self,widget, nmb):
	global mod2sec
	if mod2sec == False:
	    mod2sec = True
	    self.buttMod2sec.set_label("Deactivate 2 sec mode")
	    self.buttMod2sec.child.modify_font(fontButt)
	else:
	    mod2sec = False
	    self.buttMod2sec.set_label("Activate 2 sec mode")
	    self.buttMod2sec.child.modify_font(fontButt)

    def timerDialog(self, widget, win): # Dialog to add time in timer
	global minutes, seconds, timeAdded
	dialog = gtk.Dialog()
	dialog.set_transient_for(win)
	dialog.set_title("Select time!")
	dbutt = dialog.add_button(gtk.STOCK_SAVE, gtk.RESPONSE_OK)
	vbox = gtk.HBox()
	dialog.vbox.add(vbox)

	minPicker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
	minSelect = hildon.TouchSelector(text = True)
	minDict = {}
	for i in range(61):
	    minDict["%s min" %i] = int(i)
	    minSelect.append_text("%s min" %i)
	    if i == 0:
		minSelect.set_active(i, i)
	minPicker.set_selector(minSelect)
	vbox.pack_start(minPicker, True, True,0)

	secPicker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
	secSelect = hildon.TouchSelector(text = True)
	secDict = {}
	for i in range(60):
	    secDict["%s sec" %i] = int(i)
	    secSelect.append_text("%s sec" %i)
	    if i == 0:
		secSelect.set_active(i, i)
	secPicker.set_selector(secSelect)
	vbox.pack_start(secPicker, True, True, 0)

	dialog.show_all()
	response = dialog.run()

	if response == gtk.RESPONSE_OK:
	    mins = minSelect.get_current_text()
	    secs = secSelect.get_current_text()
	    if minDict[mins]+secDict[secs] > 0:
		minutes = minDict[mins]
		seconds = secDict[secs]
		timeAdded = True
		self.timerLabel.set_text("%i:%02.0f" %(minutes, seconds))
		self.timerLabel.modify_font(fontTimer)

	dialog.destroy()

    # TIMER & TIMER FUNCS
    def timer(self): # This function controls timer.
	global gobjid, timeAdded
	if timeAdded == True:
	    if gobjid == 0:
		gobjid = gobject.timeout_add(100, self.counterMinus)
	elif timeAdded == False:
		if gobjid == 0:
		    gobjid = gobject.timeout_add(100, self.counterPlus)

    def timerStop(self): # Function to stop
	global gobjid, seconds, minutes, timeAdded, timeSeconds, beebRun
	if gobjid != 0:
	    gobject.source_remove(gobjid)
	    gobjid = 0
	seconds = 0.0
	minutes = 0
	timeSeconds = 0.0
	beebRun = False
	if timeAdded == True:
	    timeAdded = False

    def counterPlus(self): # Function to count up
	global seconds, minutes, timeSeconds, globURI, beebRun
	if seconds > 59.9:
	    minutes += 1
	    seconds = 0.0
	    self.timerLabel.set_text("%i:%02.0f" %(minutes, seconds))
	    self.timerLabel.modify_font(fontTimer)
	else:
	    seconds += 0.1
	    timeSeconds +=0.1
	    self.timerLabel.set_text("%i:%02.0f" %(minutes, seconds))
	    self.timerLabel.modify_font(fontTimer)
	if TIME2BEEB != 0:
	    if timeSeconds >= 1.0 and beebRun == False and int(timeSeconds) % TIME2BEEB == 0:
		globURI = beeb
		player().start()
		beebRun = True
		if timeSeconds >= 600:
		    timeSeconds = 0.0
	return True

    def counterMinus(self): # Function to count down
	global seconds, minutes, globURI
	if minutes > 0:
	    if seconds < 0.1:
		minutes -=1
		seconds = 59.9
	    else:
		seconds -= 0.1
	elif seconds == 10.0:
		seconds -= 0.1
	elif seconds > 0.1:
	    seconds -= 0.1
	else:
	    globURI = alert
	    player().start()
	    self.timerStop()
	self.timerLabel.set_text("%i:%02.0f" %(minutes, seconds))
	self.timerLabel.modify_font(fontTimer)
	return True

class dialogWindows:
    def messageDialog(self, widget):
	message = gtk.Dialog("Important!", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
	close = message.add_button(gtk.STOCK_CLOSE, gtk.RESPONSE_DELETE_EVENT)
	vbox = gtk.VBox(False, 0)
	label = gtk.Label()
	label.set_markup(MESSAGE)
	label.set_line_wrap(True)
	vbox.pack_start(label, True, True, 0)

	bool = self.checkStatus()	
	dbutt = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
	dbutt.set_label("Show this message in start up")
	dbutt.set_active(bool)
	dbutt.connect("clicked", self.checkButton)
	vbox.pack_start(dbutt, False, False, 0)	
	
	message.vbox.add(vbox)
	message.show_all()
	response = message.run()
	if response == gtk.RESPONSE_DELETE_EVENT:
	    message.destroy()
    
    def checkStatus(self):
	bool = miscFuncs().confReader("help_show")
	if bool == "True":
	    bool = True
	elif bool == "False":
	    bool = False
	else: # Failback for if bool == None a.k.a first run.
	    bool = True
	    miscFuncs().confAdder("help_show", bool) # Adds the default boolean to gconf
	return bool

    def checkButton(self, widget):
	bool = miscFuncs().confReader("help_show")
	if bool == "True":
	    new = False
	else:
	    new = True
	miscFuncs().confAdder("help_show", new)    

    def helpDialog(self, widget):
	help = gtk.Dialog("Help", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
	
	# Settings:
	title1 = gtk.Label("Settings")
	setted = gtk.Label(SETTINGS)
	setted.set_line_wrap(True)
	
	# Basic:
	title2 = gtk.Label("Basic mode")
	basica = gtk.Label(BASIC)
	basica.set_line_wrap(True)
	
	# Bulb:
	title3 = gtk.Label("Bulb mode")
	bulber = gtk.Label(BULB)
	bulber.set_line_wrap(True)
	
	# Viewer:
	title4 = gtk.Label("Viewer mode")
	viewings = gtk.Label(VIEWER)
	viewings.set_line_wrap(True)
	
	# Support:
	title5 = gtk.Label("Supported cameras")
	remotes = gtk.Label(REMOTES)
	remotes.set_line_wrap(True)
	
	notes = gtk.Notebook()
	notes.set_tab_pos(gtk.POS_TOP)
	notes.append_page(setted, title1)
	notes.append_page(basica, title2)
	notes.append_page(bulber, title3)
	notes.append_page(viewings, title4)
	notes.append_page(remotes, title5)
	
	help.vbox.add(notes)
	help.show_all()
	response = help.run()
	help.destroy()

    def aboutDialog(self, widget):
	about = gtk.AboutDialog()
	about.set_title("About")
	about.set_name(APP_TITLE)
	about.set_version(APP_VERSION)
	about.set_copyright("Copyright 2010 Janne Pekkala")
	about.set_authors(["Janne Pekkala <yabbapappa@gmail.com>",""])
	about.set_artists(["Icon: Tomi Taipaleenmäki",""])
	about.set_logo(gtk.gdk.pixbuf_new_from_file(LOGO))
	about.set_comments("All logos and trademarks are property of their respective owners and are used for informational purposes only.")
	about.set_license(LICENCE)
	about.show_all()
	about.run()
	about.destroy()

class player (threading.Thread):
    def run(self):
	global beebRun
	player = gst.element_factory_make("playbin","player")
	player.set_property('uri', globURI)
	player.set_state(gst.STATE_PLAYING)
	time.sleep(3)
	beebRun = False

class digitalCamera: # This is class where commands from GUI are translated ready to be send to camera
    def olympus(self,rawdata):
	comDict = {"shutter":"capture" , "bulbon":"W" , "bulboff":"T" , "zoomin":"T" , "zoomout":"W" , "previous":"-" , "next":"+"}
	cmd = comDict[rawdata]
	self.remote(cmd)

    def canon(self):
	global mod2sec
	if mod2sec == True:
	    cmd = "2S"
	else:
	    cmd = "S"
	self.remote(cmd)

    def pentax(self, data):
	if data == "bulbon":
	    """ Sending start command in bulb mode """
	    self.bulbPatchPentax("start")
	elif data == "bulboff":
	    """ Sending stop command in bulb mode """
	    self.bulbPatchPentax("stop")
	else:
	    """ Sending normal shutter command. """
	    cmd = "Capture"
	    self.remote(cmd)

    def oneButtonRemotes(self, remote):
	if remote == "NikonDSLR":
	    cmd = "shutter"
	else:
	    print "There is no camera selected"
	    cmd = "ShutterError"
	self.remote(cmd)

    # COMMANDING INFRA RED
    def remote(self, code):
	remote = CURRENT_REMOTETYPE
	# Sending ir commands to camera, using Popen from subprocess and external irsend program (part of Lirc).
	arg = ["/usr/bin/irsend", "send_once", remote, code]
	shoot = subprocess.Popen (arg, stdin = subprocess.PIPE)
	shoot.stdin.close()
	shoot.wait()

    def bulbPatchPentax(self, state):
	remote = CURRENT_REMOTETYPE
	code = "Capture"
	if state == "start":
	    directive = "send_start"
	elif state == "stop":
	    directive = "send_stop"
	else:
	    directive = "send_once"
	arg = ["/usr/bin/irsend", directive, remote, code]
	shoot = subprocess.Popen (arg, stdin = subprocess.PIPE)
	shoot.stdin.close()
	shoot.wait()

class miscFuncs: # Some miscaleous functions (For the sake of simplicity
    # Lircd controller
    def controlLircd(self, cmd): # For starting and shutting down lirc in the start-up and close of program (or drive any other command you want
	arg = ["sudo","/etc/init.d/lirc", cmd]
	lircing = subprocess.Popen(arg)
	lircing.wait()

    # GCONF FUNCS
    def confReader(self, target): # To get data
	client = gconf.client_get_default()
	client.add_dir(CONFPATH, gconf.CLIENT_PRELOAD_NONE)
	try:
	    data = client.get_string(CONFPATH+target)
	except Exception:
	    try:
		data = client.get_int(CONFPATH+target)
	    except Exception:
		print "Reading feeds from gconf failed miserable"
	return data

    def confAdder(self, target, data): # To put data
	global CURRENT_REMOTETYPE, TIME2BEEB
	client = gconf.client_get_default()
	client.add_dir(CONFPATH, gconf.CLIENT_PRELOAD_NONE)
	try:
	    if type(data) != int:
		client.set_string(CONFPATH+target, str(data))
	    else:
		client.set_int(CONFPATH+target, int(data))
	except Exception:
	    print "Feeding gconf failed miserable"

	if target == "remote":
	    CURRENT_REMOTETYPE = str(data)
	elif target == "beebtime":
	    TIME2BEEB = int(data)

### Running up the program ####

if __name__ == "__main__":
    gui = pykakeGui()
    gui.main()
