#!/usr/bin/env python2.5

#
# PyGTKEditor
#
# Copyright (c) 2007 Khertan (Benoit HERVIER)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#        
# Khertan (Benoit HERVIER) khertan@khertan.net
#

import sys
import os.path
import commands
import cPickle

###############################################################################
# @brief Preferences
###############################################################################
class Preferences ():

  #############################################################################
  # @brief Initialize Preferences
  #############################################################################
  def __init__ (self):
    self.default_language="python"
    self.auto_indent=True
    self.use_space=True
    self.indent_width=2
    self.tab_width=2
    self.indent_on_tab=True
    self.show_line_numbers=False
    self.useless_space=True
    self.execute_command = 'python2.5'

  #############################################################################
  # @brief Load Preferences
  #############################################################################
  def load (self):
    try:
      file = open(os.path.expanduser("~")+"/.pygtkeditor/preferences",'r')
      prefs = cPickle.load(file)
      self.default_language=prefs[0]
      self.auto_indent=prefs[1]
      self.use_space=prefs[2]
      self.indent_width=prefs[3]
      self.tab_width=prefs[4]
      self.indent_on_tab=prefs[5]
      self.show_line_numbers=prefs[6]
      self.useless_space=prefs[7]
      self.execute_command =prefs[8]

    except:
      print "using default preferences"

  #############################################################################
  # @brief Save Preferences
  #############################################################################
  def save (self):
    file = open(os.path.expanduser("~")+"/.pygtkeditor/preferences",'w')
    prefs = (    self.default_language,
                 self.auto_indent,
                 self.use_space,
                 self.indent_width,
                 self.tab_width,
                 self.indent_on_tab,
                 self.show_line_numbers,
                 self.useless_space,
                 self.execute_command  )
    cPickle.dump(prefs,file)
