#!/usr/bin/env python

#
# PyGTKEditor
#
# Copyright (c) 2007 Khertan (Benoit HERVIER)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#        
# Khertan (Benoit HERVIER) khertan@khertan.net
#

import sys
import gtk
import gtk.glade
import hildon
import osso
import pango
#import threading
#import re
import os.path
#import commands
import cPickle
from subprocess import *
from codeeditor import *
from preferences import *
#import gtksourceview2

###############################################################################
# @brief PyGTKEditor window
###############################################################################
class pygtkeditor_window(hildon.Window):
  """
  Create PyGTKEditor window
  """

  ###############################################################################
  # @brief Init PyGTKEditor window
  ###############################################################################
  def __init__(self, app,osso_context):
    """
    Window initialisation.
    """
    self.app=app
    self.osso_context=osso_context
    hildon.Window.__init__(self)
    self.app.add_window(self)
    self.set_title ("PyGTKEditor")
    #self.connect ('destroy', self.cb_win_close)
    self.connect ('delete-event', self.cb_win_close)
    self.files_list=[]
    self.textview_list=[]
    self.connect("key-press-event", self.on_key_press)
    self.connect("window-state-event", self.on_window_state_change)
    self.window_in_fullscreen = False #The window isn't in full screen mode initially.
    self.current_folder = None

    self.last_opened_files=[]
    self.load_last_opened_files()
    self.last_goto_line="5"
    self.create_notebook()

    self.create_toolbar()
    self.create_menu()
    self.show_all()
    self.create_findtoolbar()

    #Patch from Damien Moore
    if self.osso_context:
      self.osso_rpc = osso.Rpc(osso_context)
      self.osso_rpc.set_rpc_callback("net.khertan.pygtkeditor","/net/khertan/pygtkeditor","net.khertan.pygtkeditor", self.cb_mime_open, self.osso_context)

    argv = sys.argv
    argv.pop(0)

    for arg in argv:
      self.open_file(arg)

  # @brief Respond to mime_open rpc call
  ###############################################################################
  def cb_mime_open(self, interface, method, args, user_data):
    #print 'mime open',args
    if method!='mime_open':
     return
    #print 'mime open',args
    try:
      uri=args[0]
    except:
     return
    if uri.startswith('file://'):
      self.create_textarea()
      self.open_file(uri[7:])
      self.grab_focus()

  ###############################################################################
  # @brief Refresh recently opened menu
  ###############################################################################
  def refresh_last_file_menu(self):
    for child in self.recent_opened_submenu.get_children():
      self.recent_opened_submenu.remove(child)
    #Recently opened sub menuecently opened sub menu
    for opened_file in self.last_opened_files:
      item = gtk.MenuItem (opened_file)
      item.connect ("activate", self.cb_tb_open_recent,opened_file)
      item.show ()
      self.recent_opened_submenu.append (item)    

  ###############################################################################
  # @brief Append to recently opened menu
  ###############################################################################
  def append_last_opened_files(self,filepath):
    if (filepath!="Untitled"):
      try:
        self.last_opened_files.remove(filepath)
      except:
        print ""
      self.last_opened_files.append(filepath)

      if (len(self.last_opened_files)>10):
        self.last_opened_files.reverse()
        self.last_opened_files.pop()
        self.last_opened_files.reverse()

      self.refresh_last_file_menu()
      self.save_last_opened_files()

  ###############################################################################
  # @brief Load recently opened menu
  ###############################################################################
  def load_last_opened_files(self):
    try:
      fileHandle = open('/home/user/.pygtkeditor/history', 'rb')
      try:
        self.last_opened_files = cPickle.load(fileHandle)
      finally:
        fileHandle.close()
    except:
      self.save_last_opened_files()

  ###############################################################################
  # @brief Save recently opened menu
  ###############################################################################
  def save_last_opened_files(self):
    try:
      fileHandle = open('/home/user/.pygtkeditor/history', 'wb')
      try:
        cPickle.dump(self.last_opened_files,fileHandle,1)
      except StandardError,e:
        print e
      finally:
        fileHandle.close()
    except:
      try:
        os.mkdir("/home/user/.pygtkeditor")
      except StandardError,e:
        print e
        f=file("/home/user/.pygtkeditor/history","w")
        f.close()

  ###############################################################################
  # @brief Create find toolbar
  ###############################################################################
  def create_findtoolbar(self):
    self.findToolBar = hildon.FindToolbar("Search for :")
    self.add_toolbar(self.findToolBar)

    self.findToolBar.connect("close", self.onHideFind)
    self.findToolBar.connect("search", self.onSearchFind)
    self.findToolBar.set_no_show_all(True)

  ###############################################################################
  # @brief Search callback
  ###############################################################################
  def onSearchFind(self,widget,data=None):
    text = widget.get_property("prefix")
    self.textview_list[self.notebook.get_current_page()].search(text)

  ###############################################################################
  # @brief Create global menu
  ###############################################################################
  def create_menu(self):
    self.menubar = gtk.Menu ()
    self.set_menu(self.menubar)

    accel_group = gtk.AccelGroup ()
    self.add_accel_group (accel_group)

    #Files
    fileitem = gtk.MenuItem ('_File')
    fileitem.show ()
    self.menubar.append (fileitem)

    filemenu = gtk.Menu ()
    filemenu.show ()
    fileitem.set_submenu (filemenu)

    new_menuitem = gtk.ImageMenuItem (gtk.STOCK_NEW, accel_group)
    new_menuitem.connect ("activate", self.cb_tb_new)
    new_menuitem.show ()
    filemenu.append (new_menuitem)

    open_menuitem = gtk.ImageMenuItem (gtk.STOCK_OPEN, accel_group)
    open_menuitem.connect ("activate", self.cb_tb_open)
    open_menuitem.show ()
    filemenu.append (open_menuitem)

    open_menuitem = gtk.MenuItem ("Open All")
    open_menuitem.connect ("activate", self.cb_tb_open_all)
    open_menuitem.show ()
    filemenu.append (open_menuitem)

    #Recently opened file item
    recent_opened_menuitem = gtk.MenuItem ('Open recent')
    recent_opened_menuitem.show ()
    filemenu.append(recent_opened_menuitem)
    #Recently opened sub menu
    self.recent_opened_submenu = gtk.Menu()
    recent_opened_menuitem.set_submenu (self.recent_opened_submenu)
    for opened_file in self.last_opened_files:
      item = gtk.MenuItem (opened_file)
      item.connect ("activate", self.cb_tb_open_recent,opened_file)
      item.show ()
      self.recent_opened_submenu.append (item)    

    save_menuitem = gtk.ImageMenuItem (gtk.STOCK_SAVE, accel_group)
    save_menuitem.connect ("activate", self.cb_tb_save)
    save_menuitem.show ()
    filemenu.append (save_menuitem)

    saveas_menuitem = gtk.ImageMenuItem (gtk.STOCK_SAVE_AS, accel_group)
    saveas_menuitem.connect ("activate", self.cb_tb_saveas)
    saveas_menuitem.show ()
    filemenu.append (saveas_menuitem)
    close_menuitem = gtk.ImageMenuItem (gtk.STOCK_CLOSE, accel_group)
    close_menuitem.connect ("activate", self.cb_tb_close)
    close_menuitem.show ()
    filemenu.append (close_menuitem)

    #Edition
    edititem = gtk.MenuItem ('_Edit')
    edititem.show ()
    self.menubar.append (edititem)

    editmenu = gtk.Menu ()
    editmenu.show ()
    edititem.set_submenu (editmenu)

    new_menuitem = gtk.ImageMenuItem (gtk.STOCK_UNDO, accel_group)
    new_menuitem.connect ("activate", self.cb_tb_undo)
    new_menuitem.show ()
    editmenu.append (new_menuitem)

    new_menuitem = gtk.ImageMenuItem (gtk.STOCK_REDO, accel_group)
    new_menuitem.connect ("activate", self.cb_tb_redo)
    new_menuitem.show ()
    editmenu.append (new_menuitem)

    item = gtk.SeparatorMenuItem ()
    item.show ()
    editmenu.append (item)

    new_menuitem = gtk.MenuItem ("Select All")
    new_menuitem.connect ("activate", self.cb_tb_select_all)
    new_menuitem.show ()
    editmenu.append (new_menuitem)

    item = gtk.SeparatorMenuItem ()
    item.show ()
    editmenu.append (item)

    new_menuitem = gtk.ImageMenuItem (gtk.STOCK_CUT, accel_group)
    new_menuitem.connect ("activate", self.cb_tb_cut)
    new_menuitem.show ()
    editmenu.append (new_menuitem)

    new_menuitem = gtk.ImageMenuItem (gtk.STOCK_COPY, accel_group)
    new_menuitem.connect ("activate", self.cb_tb_copy)
    new_menuitem.show ()
    editmenu.append (new_menuitem)

    new_menuitem = gtk.ImageMenuItem (gtk.STOCK_PASTE, accel_group)
    new_menuitem.connect ("activate", self.cb_tb_paste)
    new_menuitem.show ()
    editmenu.append (new_menuitem)

    item = gtk.SeparatorMenuItem ()
    item.show ()
    editmenu.append (item)

    new_menuitem = gtk.ImageMenuItem (gtk.STOCK_FIND, accel_group)
    new_menuitem.connect ("activate", self.onShowFind)
    new_menuitem.show ()
    editmenu.append (new_menuitem)

    new_menuitem = gtk.ImageMenuItem (gtk.STOCK_JUMP_TO, accel_group)
    new_menuitem.connect ("activate", self.cb_goto)
    new_menuitem.show ()
    editmenu.append (new_menuitem)

    item = gtk.SeparatorMenuItem ()
    item.show ()
    editmenu.append (item)

    language_menuitem = gtk.MenuItem ('Language')
    language_menuitem.show ()
    editmenu.append(language_menuitem)

    #Language sub menu
    self.language_submenu = gtk.Menu()
    language_menuitem.set_submenu (self.language_submenu)
    for language_id in gtksourceview2.LanguageManager().get_language_ids():
      item = gtk.MenuItem (language_id)
      item.connect ("activate", self.cb_tb_set_language,language_id)
      item.show ()
      self.language_submenu.append (item)    

   #Utilities    
    utiitem = gtk.MenuItem ('_Util')
    utiitem.show ()
    #self.menubar.append (utiitem)

    utimenu = gtk.Menu ()
    utimenu.show ()
    utiitem.set_submenu (utimenu)

    item = gtk.ImageMenuItem (gtk.STOCK_EXECUTE, accel_group)
    #item = gtk.MenuItem ('Execute')
    #item.add_accelerator('activate', accel_group,'E',gtk.gdk.CONTROL_MASK,True)
    item.connect ("activate", self.cb_tb_launch)
    item.show ()
    utimenu.append (item)

    #Help    
    helpitem = gtk.MenuItem ('_Help')
    helpitem.show ()
    self.menubar.append (helpitem)

    helpmenu = gtk.Menu ()
    helpmenu.show ()
    helpitem.set_submenu (helpmenu)

    item = gtk.ImageMenuItem (gtk.STOCK_ABOUT, accel_group)
    item.connect ("activate", self.onAbout)
    item.show ()
    helpmenu.append (item)

    item = gtk.ImageMenuItem (gtk.STOCK_PREFERENCES, accel_group)
    item.connect ("activate", self.show_preferences)
    item.show ()
    helpmenu.append (item)

    #Quit
    item = gtk.SeparatorMenuItem ()
    item.show ()
    self.menubar.append (item)

    item = gtk.ImageMenuItem (gtk.STOCK_QUIT, accel_group)
    item.connect ("activate", self.cb_win_close)
    item.show ()
    self.menubar.append (item)

  ###############################################################################
  # @brief Hide find toolbar callback
  ###############################################################################
  def onHideFind(self, widget):
    self.findToolBar.hide()
    self.textview_list[self.notebook.get_current_page()].searched_text = None
    #Terrible hack to force a redraw on self.window
    #self.hide()
    #self.show()

  ###############################################################################
  # @brief Show find toolbar callback
  ###############################################################################
  def onShowFind(self, widget):
    self.findToolBar.show()
    #Terrible hack to force a redraw on self.window
    #self.hide()
    #self.show()

  ###############################################################################
  # @brief Insert button with callback
  ###############################################################################
  def insert_with_callback (self,toolbar, stock_id, func):
    button = gtk.ToolButton (stock_id)
    toolbar.insert (button, -1)
    button.connect ('clicked', func)

  ###############################################################################
  # @brief Create Toolbar
  ###############################################################################
  def create_toolbar (self):
    toolbar = gtk.Toolbar ()
    toolbar.set_border_width (3)
    toolbar.set_orientation ('horizontal')
    toolbar.set_style ('both-horiz')
    self.insert_with_callback (toolbar, gtk.STOCK_INDENT, self.cb_tb_indent)
    self.insert_with_callback (toolbar, gtk.STOCK_UNINDENT, self.cb_tb_unindent)
    self.insert_with_callback (toolbar, 'gtk-strikethrough', self.cb_tb_comment)
    toolbar.insert(gtk.SeparatorToolItem(),-1)
    self.insert_with_callback (toolbar, 'gtk-new', self.cb_tb_new)
    self.insert_with_callback (toolbar, 'gtk-open', self.cb_tb_open_all)
    self.insert_with_callback (toolbar, 'gtk-save', self.cb_tb_save)
    toolbar.insert(gtk.SeparatorToolItem(),-1)
    self.insert_with_callback (toolbar, 'gtk-undo', self.cb_tb_undo)
    self.insert_with_callback (toolbar, 'gtk-redo', self.cb_tb_redo)
    toolbar.insert(gtk.SeparatorToolItem(),-1)
    self.insert_with_callback (toolbar, 'gtk-find', self.onShowFind)
    self.insert_with_callback (toolbar, 'gtk-cut', self.cb_tb_cut)
    self.insert_with_callback (toolbar, 'gtk-copy', self.cb_tb_copy)
    self.insert_with_callback (toolbar, 'gtk-paste', self.cb_tb_paste)
    toolbar.insert(gtk.SeparatorToolItem(),-1)
#    self.insert_with_callback (toolbar, 'gtk-help', self.cb_tb_help)
    self.insert_with_callback (toolbar, 'gtk-execute', self.cb_tb_launch)
    toolbar.insert(gtk.SeparatorToolItem(),-1)
    self.insert_with_callback (toolbar, 'gtk-close', self.cb_tb_close)
    self.add_toolbar (toolbar)

  ###############################################################################
  # @brief Select all menu call back
  ###############################################################################
  def cb_tb_select_all(self,widget):
    id_page = self.notebook.get_current_page()
    textbuffer = self.textview_list[id_page].get_buffer()
    start, end = textbuffer.get_bounds()
    textbuffer.select_range(start,end)

  ###############################################################################
  # @brief Open recent menu call back
  ###############################################################################
  def cb_tb_open_recent(self,widget,filename):
    try:
      if self.close_dialog():
        self.open_file(filename)
    except StandardError,e:
      print "Error opening '" + filename + "':\n"
      self.alert_dialog(e.__str__())
      #self.cb_tb_open(self,widget)

  ###############################################################################
  # @brief Language menu call back
  ###############################################################################
  def cb_tb_set_language(self,widget,language):
    id_page=self.notebook.get_current_page()
    self.textview_list[id_page].set_language(language)

  ###############################################################################
  # @brief Set filename to codeeditor
  ###############################################################################
  def set_filename(self,filename):
    id_page=self.notebook.get_current_page()
    self.files_list[id_page]=filename
    if filename.endswith('.c'):
      self.textview_list[id_page].set_language('c')
    elif filename.endswith('.latex'):
      self.textview_list[id_page].set_language('latex')
    elif filename.endswith('.py'):
      self.textview_list[id_page].set_language('python')
    elif filename.endswith('.tex'):
      self.textview_list[id_page].set_language('latex')
    elif filename.endswith('.rb'):
      self.textview_list[id_page].set_language('ruby')
    elif filename.endswith('.sql'):
      self.textview_list[id_page].set_language('sql')
    elif filename.endswith('.cpp'):
      self.textview_list[id_page].set_language('cpp')
    elif filename.endswith('.h'):
      self.textview_list[id_page].set_language('cpp')
    elif filename.endswith('.css'):
      self.textview_list[id_page].set_language('css')
    elif filename.endswith('.glade'):
      self.textview_list[id_page].set_language('xml')
    elif filename.endswith('.xml'):
      self.textview_list[id_page].set_language('xml')
    elif filename.endswith('.html'):
      self.textview_list[id_page].set_language('html')
    elif filename.endswith('.java'):
      self.textview_list[id_page].set_language('java')
    elif filename.endswith('.js'):
      self.textview_list[id_page].set_language('javascript')
    elif filename.endswith('.php'):
      self.textview_list[id_page].set_language('php')
    elif filename.endswith('.pl'):
      self.textview_list[id_page].set_language('perl')
    elif filename.endswith('.sh'):
      self.textview_list[id_page].set_language('sh')
    else:
      self.textview_list[id_page].set_language(None)

  ###############################################################################
  # @brief Open toolbar button callback
  ###############################################################################
  def cb_tb_open(self,widget, *args):
    if self.close_dialog():
      dialog = hildon.FileChooserDialog(self, "open")
      if (self.current_folder != None):
        dialog.set_current_folder(self.current_folderself.current_folder)

      if(dialog.run()==gtk.RESPONSE_OK) and (dialog.get_filename()!=None):
        try:
          filename=dialog.get_filename()
          dialog.destroy()
          self.open_file(filename)

        except StandardError,e:
          print e
          dialog.destroy()
          self.alert_dialog(e.__str__())
          #self.cb_tb_open(self,widget)
      else:
        dialog.destroy()

  ###############################################################################
  # @brief Open file
  ###############################################################################
  def open_file(self,filename):
    id_page = self.notebook.get_current_page()
    if (id_page<0):
      id_page=0
      self.create_textarea() 

    self.set_filename(filename)
    self.append_last_opened_files(filename)
    f = open(filename,"r")
    textbuffer = self.textview_list[id_page].get_buffer()
    textfile = f.read()
    textfile=textfile.replace("\r\n","\n")
    textfile=textfile.replace("\r","\n")
    textfile = textfile.decode()
    textbuffer.set_text(textfile)
    self.textview_list[id_page].clean_space()
    self.textview_list[id_page].saved=True
    f.close()
    self.notebook.set_tab_label_text(self.notebook.get_children()[id_page],os.path.basename(filename))
    self.current_folder = os.path.dirname(filename)

  ###############################################################################
  # @brief Open toolbar button callback
  ###############################################################################
  def cb_tb_indent(self,widget, *args):
    id_page = self.notebook.get_current_page()
    self.textview_list[id_page].indent_tab()

  def cb_tb_unindent(self,widget, *args):
    id_page = self.notebook.get_current_page()
    self.textview_list[id_page].unindent_tab() 

  def cb_tb_comment(self,widget, *args):
    id_page = self.notebook.get_current_page()
    self.textview_list[id_page].comment_text() 
  ###############################################################################
  # @brief Open toolbar button callback
  ###############################################################################
  def cb_tb_open_all(self,widget, *args):
    if self.close_dialog():
      dialog = gtk.FileChooserDialog('Open File', None, gtk.FILE_CHOOSER_ACTION_OPEN, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OPEN, gtk.RESPONSE_OK))
      dialog.set_show_hidden(True)
      if (self.current_folder != None):
        dialog.set_current_folder(self.current_folder)

      if(dialog.run()==gtk.RESPONSE_OK) and (dialog.get_filename()!=None):
        try:
          filename=dialog.get_filename()
          dialog.destroy()
          self.open_file(filename)
        except StandardError,e:
          print e
          dialog.destroy()
          #self.cb_tb_open_all(self,widget)
          self.alert_dialog(e.__str__())
      else:
        dialog.destroy()

  ###############################################################################
  # @brief Save toolbar button callback
  ###############################################################################
  def cb_tb_save(self,widget, *args):
    file=self.files_list[self.notebook.get_current_page()]
    saveIt=True
    if (file=="Untitled"):
      try:
        dialog=gtk.FileChooserDialog("save",None, gtk.FILE_CHOOSER_ACTION_SAVE, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_SAVE, gtk.RESPONSE_OK))
        if (self.current_folder != None):
          dialog.set_current_folder(self.current_folder)
        if(dialog.run()==gtk.RESPONSE_OK) and (dialog.get_filename()!=None):
          file=dialog.get_filename()
          self.current_folder = dialog.get_current_folder()
        else:
          saveIt=False
        dialog.destroy()
      except StandardError,e:
        print "Error"+e.__str__()
        self.alert_dialog(e.__str__())

    if (saveIt):
      try:
        self.notebook.set_tab_label_text(self.notebook.get_children()[self.notebook.get_current_page()],os.path.basename(file))
        self.set_filename(file)
        f = open(file,"w")
        #self.textview_list[self.notebook.get_current_page()].clean_space()
        textbuffer=self.textview_list[self.notebook.get_current_page()].get_buffer()
        f.write(textbuffer.get_text(textbuffer.get_start_iter(), textbuffer.get_end_iter()))
        f.close()
        self.textview_list[self.notebook.get_current_page()].saved=True
        note = osso.SystemNote(self.osso_context)
        result = note.system_note_infoprint("Saved")
      except StandardError,e:
        self.alert_dialog(e.__str__())
        print e

  ###############################################################################
  # @brief Save toolbar button callback
  ###############################################################################
  def cb_tb_saveas(self,widget, *args):
    file=self.files_list[self.notebook.get_current_page()]
    saveIt=True
    if (file==file):
      try:
        dialog=gtk.FileChooserDialog("save",None, gtk.FILE_CHOOSER_ACTION_SAVE, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_SAVE, gtk.RESPONSE_OK))
        if (self.current_folder != None):
          dialog.set_current_folder(self.current_folder)
        if(dialog.run()==gtk.RESPONSE_OK) and (dialog.get_filename()!=None):
          file=dialog.get_filename()
          self.current_folder = dialog.get_current_folder()
        else:
          saveIt=False
        dialog.destroy()
      except StandardError,e:
        print "Error"+e.__str__()
        self.alert_dialog(e.__str__())

    if (saveIt):
      try:
        self.notebook.set_tab_label_text(self.notebook.get_children()[self.notebook.get_current_page()],os.path.basename(file))
        self.set_filename(file)
        f = open(file,"w")
        #self.textview_list[self.notebook.get_current_page()].clean_space()
        textbuffer=self.textview_list[self.notebook.get_current_page()].get_buffer()
        f.write(textbuffer.get_text(textbuffer.get_start_iter(), textbuffer.get_end_iter()))
        f.close()
        self.textview_list[self.notebook.get_current_page()].saved=True
      except StandardError,e:
        self.alert_dialog(e.__str__())
        print e

  ###############################################################################
  # @brief Cut toolbar button callback
  ###############################################################################
  def cb_tb_cut(self,widget, *args):
    self.textview_list[self.notebook.get_current_page()].cut_to_clipboard()

  ###############################################################################
  # @brief Open toolbar button callback
  ###############################################################################
  def cb_tb_copy(self,widget, *args):
    self.textview_list[self.notebook.get_current_page()].copy_to_clipboard()

    note = osso.SystemNote(self.osso_context)
    result = note.system_note_infoprint("Copied")

  ###############################################################################
  # @brief Paste toolbar button callback
  ###############################################################################
  def cb_tb_paste(self,widget, *args):
    self.textview_list[self.notebook.get_current_page()].paste_from_clipboard()

  ###############################################################################
  # @brief Undo toolbar button callback
  ###############################################################################
  def cb_tb_undo(self,widget, *args):
    self.textview_list[self.notebook.get_current_page()].undo()

  ###############################################################################
  # @brief Redo toolbar button callback
  ###############################################################################
  def cb_tb_redo(self,widget, *args):
    self.textview_list[self.notebook.get_current_page()].redo()

  ###############################################################################
  # @brief Close toolbar button callback
  ###############################################################################
  def close_tab(self):
    id_page = self.notebook.get_current_page()
    self.notebook.remove_page(id_page)
    self.textview_list.pop(id_page)
    self.files_list.pop(id_page)

  ###############################################################################
  # @brief Close all toolbar button callback
  ###############################################################################
  def close_all_tab(self):
    pass
    #for file in self.files_list:
    #  self.append_last_opened_files(file)

  ###############################################################################
  # @brief Launch toolbar button callback
  ###############################################################################
  def cb_tb_launch(self,widget,*args):

    fileHandle = open('/tmp/pygtkeditor.tmp', 'w')
    fileHandle.write('#!/bin/sh\n')
    fileHandle.write('cd '+os.path.dirname(self.files_list[self.notebook.get_current_page()])+' \n')
    fileHandle.write(self.textview_list[self.notebook.get_current_page()].get_language()+" \'"+self.files_list[self.notebook.get_current_page()] + '\'\n')
    fileHandle.write('read -p "Press ENTER to continue ..." foo')
    fileHandle.write('\nexit')
    fileHandle.close()
    commands.getoutput("chmod 777 /tmp/pygtkeditor.tmp")
    #commands.getoutput("/usr/bin/osso-xterm /tmp/pygtkeditor.tmp")
    Popen('/usr/bin/osso-xterm /tmp/pygtkeditor.tmp',shell=True,stdout=None)

    note = osso.SystemNote(self.osso_context)
    result = note.system_note_infoprint("Launching "+ self.files_list[self.notebook.get_current_page()] +" ...")

  ###############################################################################
  # @brief Help toolbar button callback
  ###############################################################################
  def cb_tb_help(self,widget,*args):
   textbuffer=self.textview_list[self.notebook.get_current_page()].get_buffer()
   try:  
     start,end = textbuffer.get_selection_bounds()
     cmd = textbuffer.get_text(start,end)    
     res = repr(dir(cmd))
     result_Window = resultWindow(res,self.app)
     result = result_Window.run()
   except:
     print "No Selection"

  #############################################################################
  # @brief Close Dialog
  #############################################################################
  def close_dialog(self):
    answer = False
    id_page = self.notebook.get_current_page()
    if self.notebook.get_current_page()>=0:
      if (not self.textview_list[id_page].saved):
        dialog = gtk.MessageDialog(self,
                    gtk.DIALOG_MODAL,
                    gtk.MESSAGE_QUESTION,
                    gtk.BUTTONS_YES_NO,
                    "Do you really want to close this not saved file ?")
        rc = dialog.run ()
        if rc == gtk.RESPONSE_YES:
          answer = True

        dialog.destroy ()
      else:
        answer = True
    else:
      answer = True
    return answer

  #############################################################################
  # @brief Toolbar close callback
  #############################################################################
  def cb_tb_close(self,widget, *args):
    if self.close_dialog():
      self.close_tab()

  #############################################################################
  # @brief Main Window state changed callback
  #############################################################################
  def on_window_state_change(self, widget, event, *args):
    if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
      self.window_in_fullscreen = True
    else:
      self.window_in_fullscreen = False

  #############################################################################
  # @brief Toolbar new callback
  #############################################################################
  def cb_tb_new(self, widget,  *args):
    self.create_textarea()

  #############################################################################
  # @brief Main Window keypressed callback
  #############################################################################
  def on_key_press(self, widget, event, *args):
    if event.keyval == gtk.keysyms.F6:
    # The "Full screen" hardware key has been pressed
      if self.window_in_fullscreen:
        self.unfullscreen ()
      else:
        self.fullscreen ()
    elif event.keyval == gtk.keysyms.F8:
      #print "moins"
      self.textview_list[self.notebook.get_current_page()].decrease_font_size()
    elif event.keyval == gtk.keysyms.F7:
      #print "plus"
      self.textview_list[self.notebook.get_current_page()].increase_font_size()

  #############################################################################
  # @brief Main Window close callback
  #############################################################################
  def cb_win_close(self,widget,data=None):
    dialog = gtk.MessageDialog(self,
                    gtk.DIALOG_MODAL,
                    gtk.MESSAGE_QUESTION,
                    gtk.BUTTONS_YES_NO,
                    "Do you really want to quit?")
    rc = dialog.run ()
    dialog.destroy ()

    if rc == gtk.RESPONSE_YES:
      self.close_all_tab()
      self.app.remove_window(self)
      gtk.main_quit ()
    return True

  #############################################################################
  # @brief Goto CallBack
  #############################################################################
  def cb_goto(self,widget,*data):
    self.last_goto_line = self.show_dialog(self.last_goto_line)
    if self.last_goto_line<>None:
      textview = self.textview_list[self.notebook.get_current_page()]
      start_line_iter=textview.get_buffer().get_iter_at_line(int(self.last_goto_line)-1)
      end_line_iter=textview.get_buffer().get_iter_at_line(int(self.last_goto_line))
      textview.scroll_to_iter(start_line_iter,0)
      textview.get_buffer().apply_tag_by_name ("search_hilight",start_line_iter , end_line_iter)
      textview.get_buffer().set_modified(False)

  #############################################################################
  # @brief Show a simple dialog
  #############################################################################
  def show_dialog(self, name):
    """This function shows the category dialog.
    @param name - string - The name to display in
    category dialog by default.
    @returns - If OK is pressed the name typed on the
    dialog. If Cancel is pressed None is returned.
    """
    name_return = None

    #load the dialog from the glade file
    wTree = gtk.glade.XML("/usr/lib/pygtkeditor/pygtkeditor.glade", "gotoDialog")
    #Get the actual dialog widget
    dlg = wTree.get_widget("gotoDialog")
    #Get all of the Entry Widgets and set their text
    enName = wTree.get_widget("enName")
    enName.set_text(name)
    enName.set_position(-1)
    enName.select_region(0, -1)

    #run the dialog and store the response
    result = dlg.run()
    if (result==gtk.RESPONSE_OK):
      #get the value of the entry fields
      name_return = enName.get_text()
      #we are done with the dialog, destroy it
    dlg.destroy()

    #return the result
    return name_return

  #############################################################################
  # @brief Show a simple dialog
  #############################################################################
  def show_preferences(self, name):
    """This function shows the category dialog.
    @param name - string - The name to display in
    category dialog by default.
    @returns - If OK is pressed the name typed on the
    dialog. If Cancel is pressed None is returned.
    """
    name_return = None
    prefs = Preferences()
    prefs.load()
    #load the dialog from the glade file
    wTree = gtk.glade.XML("/usr/lib/pygtkeditor/pygtkeditor.glade", "preferencesDialog")
    #Get the actual dialog widget
    dlg = wTree.get_widget("preferencesDialog")
    #Get all of the Entry Widgets and set their text
    pf_indent_width = wTree.get_widget("pf_indent_width")
    pf_indent_width.set_text(prefs.indent_width.__str__())
    pf_tab_width = wTree.get_widget("pf_tab_width")
    pf_tab_width.set_text(prefs.tab_width.__str__())
    pf_indent_on_tab = wTree.get_widget("pf_indent_on_tab")
    pf_indent_on_tab.set_state(prefs.indent_on_tab)
    pf_space_instead_tabs = wTree.get_widget("pf_space_instead_tabs")
    pf_space_instead_tabs.set_state(prefs.use_space)
    pf_auto_indent = wTree.get_widget("pf_auto_indent")
    pf_auto_indent.set_state(prefs.auto_indent)
    pf_show_line_numbers = wTree.get_widget("pf_show_line_numbers")
    pf_show_line_numbers.set_state(prefs.show_line_numbers)
    pf_defaultlanguage = wTree.get_widget("pf_defaultlanguage")
    pf_useless_space = wTree.get_widget("pf_useless_space")
    pf_useless_space.set_state(prefs.useless_space)
    language_list = gtk.ListStore(str)
    for language_id in gtksourceview2.LanguageManager().get_language_ids():
      language_list.append([language_id.__str__()])
    #language_list.sort()
    #TODO Set default language prefs in GUI
    #language_list.set_value(prefs.default_language)
#    self._eventeditor_edit_frequency.set_active(0)

    pf_defaultlanguage.set_model( language_list )
    print prefs.default_language
    try:
      pf_defaultlanguage.set_active(gtksourceview2.LanguageManager().get_language_ids().index(prefs.default_language))
    except:
        prefs.default_language='python'
    cell = gtk.CellRendererText()
    pf_defaultlanguage.pack_start( cell, True )
    pf_defaultlanguage.add_attribute( cell, "text", 0)

    #run the dialog and store the response
    result = dlg.run()
    if (result==gtk.RESPONSE_OK):
      prefs.tab_width=int(pf_tab_width.get_text())
      prefs.indent_width=int(pf_indent_width.get_text())
      prefs.indent_on_tab=pf_indent_on_tab.state
      prefs.use_space=pf_space_instead_tabs.state
      prefs.auto_indent=pf_auto_indent.state
      prefs.show_line_numbers=pf_show_line_numbers.state
      prefs.useless_space=pf_useless_space.state
      try:
#       prefs.default_language=gtksourceview2.LanguageManager().get_language_ids()[
        prefs.default_language=language_list.get_value(language_list.get_iter(pf_defaultlanguage.get_active()),0)
      except:
        prefs.default_language='python'

      #TODO GET Default language from GUI
      #prefs.default_language=language_list.get_value()
      prefs.save()
      #name_return = enName.get_text()
      #we are done with the dialog, destroy it
    dlg.destroy()

    #return the result
    return name_return

  #############################################################################
  # @brief Notebook init
  #############################################################################
  def create_notebook(self):
    self.notebook = gtk.Notebook()
    self.add(self.notebook)

  #############################################################################
  # @brief TextArea init
  #############################################################################
  def create_textarea (self):
    l = gtk.Label('Untitled')
    l.set_text_with_mnemonic('Untitled')
    scrolledwindow = gtk.ScrolledWindow (None, None)
    scrolledwindow.show ()
    scrolledwindow.set_policy ('automatic', 'automatic')
    textview = CodeEditor ()
    self.textview_list.append(textview)
    self.files_list.append("Untitled")
    scrolledwindow.add (textview)
    self.notebook.append_page(scrolledwindow, l)
    self.notebook.show_all()
    buffer = textview.get_buffer()

    self.notebook.set_current_page(len(self.files_list)-1)
    #buffer.connect ('modified-changed', callback_buffer_modified)
    #buffer.connect ('changed', callback_buffer_modified)

  #############################################################################
  # @brief About
  #############################################################################
  def onAbout(self, widget):
    dialog = gtk.AboutDialog()
    dialog.set_name("PyGTKEditor")
    dialog.set_logo_icon_name("pygtkeditor")
    dialog.set_authors(("Benoit HERVIER\n aka Khertan","","Thanks to :","Alterego for his help","Damien Moore for his patch"))
    dialog.set_comments('A source code editor for Maemo')
    dialog.set_version("v2.4.0")
    dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
    dialog.set_copyright("By Benoit HERVIER (aka Khertan)")
    dialog.set_website("http://khertan.net/")
    dialog.connect ("response", lambda d, r: d.destroy())
    dialog.show()

  #############################################################################
  # @brief Error alert dialog
  #############################################################################
  def alert_dialog(self,message):
    dialog = gtk.MessageDialog(self,
                    gtk.DIALOG_MODAL,
                    gtk.MESSAGE_ERROR,
                    gtk.BUTTONS_OK,
                    message)
    rc = dialog.run ()
    dialog.destroy ()

#############################################################################
# @brief ResultWindow : Class to show help
#############################################################################
class resultWindow:
  """This class is used to show help"""

  #############################################################################
  # @brief Init
  #############################################################################
  def __init__(self, result,app):
    """Initialize the class."""
    self.result = result
    self.app = app

  #############################################################################
  # @brief Run
  #############################################################################
  def run(self):
    win = hildon.Window()

    self.app.add_window(win)
    win.set_title ("PyGTKEditor")
    text_view = gtk.TextView()
    text_view.set_editable(False)
    text_view.set_wrap_mode(True)
    win.add(text_view)
    text_view.get_buffer().set_text(self.result)

    win.show_all()

  #############################################################################
  # @brief Close callback
  #############################################################################
  def on_close(self,widget):
    win.hide()