#!/usr/bin/env python

import dbus
import dbus.service
import dbus.mainloop.glib
import gobject

class SomeObject(dbus.service.Object):
    def __init__(self, *args, **kwargs):
        super(SomeObject, self).__init__(*args, **kwargs)
        self.foo = 'bar'
        self.baz = 'qux'
        
    @dbus.service.method("de.cryptobitch.muelli.Pwnitter",
                         in_signature='s', out_signature='as')
    def HelloWorld(self, hello_message="default"):
        print (str(hello_message))
        return ["Hello", " from example-service.py", "with unique name",
                session_bus.get_unique_name()]

    @dbus.service.method(dbus.PROPERTIES_IFACE,
                         in_signature='s', out_signature='a{sv}')
    def GetAll(self, interface):
        if interface == 'de.cryptobitch.muelli.Pwnitter':
            return { 'foo': dbus.types.String(self.foo),
                   }
        else:
            raise dbus.exceptions.DBusException(
                'com.example.UnknownInterface',
                'The Foo object does not implement the %s interface'
                    % interface)


    @dbus.service.method(dbus.PROPERTIES_IFACE,
                         in_signature='ss', out_signature='v')
    def Get(self, interface, propname):
        try:
            value = self.__dict__[propname]
        except:
            raise
        return value

    @dbus.service.method(dbus.PROPERTIES_IFACE,
                         in_signature='ssv', out_signature='')
    def Set(self, interface, propname, value):
        self.__dict__[propname] = value

    @dbus.service.signal(dbus.PROPERTIES_IFACE,
                         signature='sa{sv}as')
    def PropertiesChanged(self, interface_name, changed_properties,
                          invalidated_properties):
        pass

    
if __name__ == '__main__':
    dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

    session_bus = dbus.SystemBus()
    name = dbus.service.BusName("de.cryptobitch.muelli.Pwnitter", session_bus)
    object = SomeObject(session_bus, '/Pwnitter')

    mainloop = gobject.MainLoop()
    print "Running example service."
    mainloop.run()
