#!/usr/bin/env python

import dbus
import dbus.service
import dbus.mainloop.glib
import gobject

class SomeObject(dbus.service.Object):
    @dbus.service.method("de.cryptobitch.muelli.Pwnitter",
                         in_signature='s', out_signature='as')
    def HelloWorld(self, hello_message="default"):
        print (str(hello_message))
        return ["Hello", " from example-service.py", "with unique name",
                session_bus.get_unique_name()]
    @dbus.service.method("de.cryptobitch.muelli.Pwnitter",
                         in_signature='', out_signature='')
    def EmitSignal(self):
        self.MessageSent('foo')
    
    @dbus.service.signal("de.cryptobitch.muelli.Pwnitter")                
    def MessageSent(self,who):
        print 'emitting'
    
    def emit_and_true(self):
        self.MessageSent('always')
        return True
if __name__ == '__main__':
    dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

    session_bus = dbus.SystemBus()
    name = dbus.service.BusName("de.cryptobitch.muelli.Pwnitter", session_bus)
    object = SomeObject(session_bus, '/Pwnitter')

    mainloop = gobject.MainLoop()
    gobject.timeout_add(5 * 1000, object.emit_and_true)
    print "Running example service."
    mainloop.run()
