/****************************************************************************
2
**
3
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
4
** All rights reserved.
5
** Contact: Nokia Corporation (qt-info@nokia.com)
6
**
7
** This file is part of the examples of the Qt Toolkit.
8
**
9
** $QT_BEGIN_LICENSE:LGPL$
10
** No Commercial Usage
11
** This file contains pre-release code and may not be distributed.
12
** You may use this file in accordance with the terms and conditions
13
** contained in the Technology Preview License Agreement accompanying
14
** this package.
15
**
16
** GNU Lesser General Public License Usage
17
** Alternatively, this file may be used under the terms of the GNU Lesser
18
** General Public License version 2.1 as published by the Free Software
19
** Foundation and appearing in the file LICENSE.LGPL included in the
20
** packaging of this file.  Please review the following information to
21
** ensure the GNU Lesser General Public License version 2.1 requirements
22
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
23
**
24
** In addition, as a special exception, Nokia gives you certain additional
25
** rights.  These rights are described in the Nokia Qt LGPL Exception
26
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
27
**
28
** If you have questions regarding the use of this file, please contact
29
** Nokia at qt-info@nokia.com.

** $QT_END_LICENSE$

****************************************************************************/


#ifndef PROXYSWITCHER_H

#define PROXYSWITCHER_H

#include <QtGui/qlabel.h>

#include <QtGui/qinputdialog.h>

#include <QtGui/qpainter.h>

#include "gconfitem.h"

class ProxySwitcher : public QWidget

{

    Q_OBJECT


public:

	GConfItem *lastUsed;

	GConfItem *mode;

	GConfItem *http_port;
	GConfItem *http_host;

	
	GConfItem *auto_url;
	GConfItem *ftp_port;
	GConfItem *secure_port;
	GConfItem *secure_host;

	GConfItem *ftp_host;
	GConfItem *rtsp_port;
	GConfItem *rtsp_host;

	QVariant lastUsedNetworkName;
	//gconf key for last used network
	QString GCONF_KEY_DIR_CON;
	QString GCONF_KEY_LAST_USED;
	//gconf key for actualy used wireless key
	QString	GCONF_KEY_WIRE_NAME;

	//gconf key for wireless directory plus current name
	QString GCONF_KEY_DIR_WIRE_NAME;

	
	//gconf proxy mode key
	QString GCONF_KEY_PROXY_MODE;
	
	// http proxy keys

	QString GCONF_KEY_PROXY_PORT;

	QString GCONF_KEY_PROXY_HOST;

	
	//system proxy keys
	QString GCONF_KEY_PROXY_AUTO_URL;
	QString GCONF_KEY_PROXY_FTP_PORT;
	QString GCONF_KEY_PROXY_SECUR_PORT;
	QString GCONF_KEY_PROXY_SECUR_HOST;
	
	QString GCONF_KEY_PROXY_FTP_HOST;
	QString GCONF_KEY_PROXY_RTSP_PORT;
	QString GCONF_KEY_PROXY_RTSP_HOST;
	
	QPixmap button[2];
        QPixmap proxyButton[3];
	int buttonState;
        int proxyState;

    ProxySwitcher()

        : QWidget()

    {
	
	button[0].load("/etc/hildon/theme/images/ApplicationShortcutApplet.png");
	button[1].load("/etc/hildon/theme/images/ApplicationShortcutAppletPressed.png");
	proxyButton[0].load("/opt/proxyswitcher/manual.png");
	proxyButton[1].load("/opt/proxyswitcher/none.png");
	proxyButton[2].load("/opt/proxyswitcher/auto.png");
	
	//gconf key for last used network
 	GCONF_KEY_DIR_CON = "/system/osso/connectivity/IAP";
	GCONF_KEY_LAST_USED = GCONF_KEY_DIR_CON + "/last_used_network";
	lastUsed = new GConfItem(GCONF_KEY_LAST_USED,this);
	lastUsedNetworkName = lastUsed->value();
	
	


	setupGConfKeys();

        setAttribute(Qt::WA_TranslucentBackground);
        QVariant var = mode->value();
	
	buttonState = 0;

        if(var.toString() == "MANUAL"){
            proxyState = 0;
        }else if(var.toString() == "NONE"){
            proxyState = 1;
        }else if(var.toString() == "AUTO"){
            proxyState = 2;
	}
    
     }
    QRectF boundingRect() const{


          return QRectF(QWidget::x(), QWidget::y(), 96, 96);
    }

    QSize sizeHint() const{

        QSize newSize = QWidget::sizeHint();
        newSize.setHeight(96);
        newSize.setWidth(96);
        return newSize;

    }

    void mouseReleaseEvent(QMouseEvent * event){
     	
   	buttonState = 0;
     	QWidget::mouseReleaseEvent(event);
     	QWidget::update();
	}

    void checkSetCurrentUsedConnection(){
		lastUsed = new GConfItem(GCONF_KEY_LAST_USED,this);
		QVariant temp = lastUsed->value();		
		if(lastUsedNetworkName.toString() != temp.toString()){
		lastUsedNetworkName=temp;
		setupGConfKeys();
		}
	}

    void setupGConfKeys(){
		//gconf key for actualy used wireless key
	GCONF_KEY_WIRE_NAME = GCONF_KEY_DIR_CON + lastUsedNetworkName.toString();
	
	// proxy mode keys

	GCONF_KEY_PROXY_MODE = GCONF_KEY_WIRE_NAME + "/proxytype";

	// http proxy keys
	
	GCONF_KEY_PROXY_PORT = GCONF_KEY_WIRE_NAME + "/proxy_http_port";
	//GCONF_KEY_PROXY_AUTH_PASS = GCONF_KEY_WIRE_NAME + "/authentication_password";
	//GCONF_KEY_PROXY_AUTH_USER = GCONF_KEY_WIRE_NAME + "/authentication_user";
	GCONF_KEY_PROXY_HOST = GCONF_KEY_WIRE_NAME + "/http_proxy";
	//GCONF_KEY_PROXY_USE_AUTH = GCONF_KEY_WIRE_NAME + "/use_authentication";
	
	//system proxy keys
	GCONF_KEY_PROXY_AUTO_URL = GCONF_KEY_WIRE_NAME + "/autoconf_url";
	GCONF_KEY_PROXY_FTP_PORT = GCONF_KEY_WIRE_NAME + "/proxy_ftp_port";
	GCONF_KEY_PROXY_SECUR_PORT = GCONF_KEY_WIRE_NAME + "/proxy_https_port";
	GCONF_KEY_PROXY_SECUR_HOST = GCONF_KEY_WIRE_NAME + "/proxy_https";
	GCONF_KEY_PROXY_FTP_HOST = GCONF_KEY_WIRE_NAME + "/proxy_ftp";
	GCONF_KEY_PROXY_RTSP_PORT = GCONF_KEY_WIRE_NAME + "/proxy_rtsp_port";
	GCONF_KEY_PROXY_RTSP_HOST = GCONF_KEY_WIRE_NAME + "/proxy_rtsp";
		//system proxy keys
	GCONF_KEY_PROXY_AUTO_URL = GCONF_KEY_WIRE_NAME + "/autoconf_url";
	GCONF_KEY_PROXY_FTP_PORT = GCONF_KEY_WIRE_NAME + "/proxy_ftp_port";
	GCONF_KEY_PROXY_SECUR_PORT = GCONF_KEY_WIRE_NAME + "/proxy_https_port";
	GCONF_KEY_PROXY_SECUR_HOST = GCONF_KEY_WIRE_NAME + "/proxy_https";
	GCONF_KEY_PROXY_FTP_HOST = GCONF_KEY_WIRE_NAME + "/proxy_ftp";
	GCONF_KEY_PROXY_RTSP_PORT = GCONF_KEY_WIRE_NAME + "/proxy_rtsp_port";
	GCONF_KEY_PROXY_RTSP_HOST = GCONF_KEY_WIRE_NAME + "/proxy_rtsp";

	mode = new GConfItem(GCONF_KEY_PROXY_MODE,this);
	
	http_port = new GConfItem(GCONF_KEY_PROXY_PORT,this);

	http_host = new GConfItem(GCONF_KEY_PROXY_HOST,this);

	
	auto_url = new GConfItem(GCONF_KEY_PROXY_AUTO_URL,this);
	ftp_port = new GConfItem(GCONF_KEY_PROXY_FTP_PORT,this);
	secure_port = new GConfItem(GCONF_KEY_PROXY_SECUR_PORT,this);
	secure_host = new GConfItem(GCONF_KEY_PROXY_SECUR_HOST,this);

	ftp_host = new GConfItem(GCONF_KEY_PROXY_FTP_HOST,this);

	rtsp_port = new GConfItem(GCONF_KEY_PROXY_RTSP_PORT,this);
	rtsp_host = new GConfItem(GCONF_KEY_PROXY_RTSP_HOST,this);
	}

    void mousePressEvent ( QMouseEvent * ev ) {


	checkSetCurrentUsedConnection();
	QVariant var = mode->value();

        QString proxyEnabled = var.toString();
	buttonState = 1;
	
        if(proxyEnabled=="MANUAL"){
            proxyState = 1;
            proxyEnabled = "NONE";
        }else if(proxyEnabled=="NONE"){
            proxyState = 2;
            proxyEnabled = "AUTO";
        }else if(proxyEnabled =="AUTO"){
            proxyState = 0;
            proxyEnabled = "MANUAL";
        }

        var = proxyEnabled;

	mode->set(var);
        
        if(var.toString() == "MANUAL"){
            proxyState = 0;
        }else if(var.toString() == "NONE"){
            proxyState = 1;
        }else if(var.toString() == "AUTO"){
            proxyState = 2;
	}
		
		QWidget::update();
	}

public slots:

    void showSettingsDialog()

    {

	//mode = new GConfItem(GCONF_KEY_PROXY_MODE,this);
	
	
	//http_auth_pass = new GConfItem(GCONF_KEY_PROXY_AUTH_PASS,this);
	//http_auth_user = new GConfItem(GCONF_KEY_PROXY_AUTH_USER,this);
	
	//http_use_auth = new GConfItem(GCONF_KEY_PROXY_USE_AUTH,this);
	
	//auto_url = new GConfItem(GCONF_KEY_PROXY_AUTO_URL,this);


	//socks_host = new GConfItem(GCONF_KEY_PROXY_SOCKS_HOST,this);
	//socks_port = new GConfItem(GCONF_KEY_PROXY_SOCKS_PORT,this);
	


	if(proxyState == 0){
	        
		//http host
		bool isOk = false;
	
		QVariant local_http_host = http_host->value();
        
		local_http_host = QInputDialog::getText(this, tr("current url if avalible"),tr("Please enter your http proxy url."),
		QLineEdit::Normal,local_http_host.toString(), &isOk);

        	if (isOk){ 

			
			
			http_host->set(local_http_host);
		}
		//http port
		isOk = false;		

		QVariant local_http_port = http_port->value();
        
		local_http_port = QInputDialog::getInt(this, tr("current url if avalible"),tr("Please enter your http proxy port."),
		local_http_host.toInt(),1,65535,1, &isOk);

        	if (isOk){ 

			
			
			http_port->set(local_http_host);
		}
		
		//secure host
		isOk = false;
		
		QVariant local_secure_host = secure_host->value();
        
		local_secure_host = QInputDialog::getText(this, tr("Current url"),tr("Please enter the url for the proxy."),
		QLineEdit::Normal,local_secure_host.toString(), &isOk);

        	if (isOk) secure_host->set(local_secure_host);
		
		//secure port
		isOk = false;		

		QVariant local_secure_port = secure_port->value();
        
		local_secure_port = QInputDialog::getInt(this, tr("current url if avalible"),tr("Please enter your http proxy port."),
		local_secure_port.toInt(),1,65535,1, &isOk);

        	if (isOk) secure_port->set(local_secure_port);
		


		//ftp host
		isOk = false;
		
		QVariant local_ftp_host = ftp_host->value();
        
		local_ftp_host = QInputDialog::getText(this, tr("Ftp Host"),tr("Please enter your proxy's ftp url."),
		QLineEdit::Normal,local_ftp_host.toString(), &isOk);

        	if (isOk) ftp_host->set(local_ftp_host);
		
		//ftp port
		isOk = false;		

		QVariant local_ftp_port = ftp_port->value();
        
		local_ftp_port = QInputDialog::getInt(this, tr("Ftp Port"),tr("Please enter your proxy's ftp port."),
		local_ftp_port.toInt(),1,65535,1, &isOk);

        	if (isOk) ftp_port->set(local_ftp_port);
		
		//rtsp host
		isOk = false;
		
		QVariant local_rtsp_host = rtsp_host->value();
        
		local_rtsp_host = QInputDialog::getText(this, tr("rtsp Host"),tr("Please enter your proxy's rtsp url."),
		QLineEdit::Normal,local_rtsp_host.toString(), &isOk);

        	if (isOk) rtsp_host->set(local_rtsp_host);
		
		//rtsp port
		isOk = false;		

		QVariant local_rtsp_port = rtsp_port->value();
        
		local_rtsp_port = QInputDialog::getInt(this, tr("RTSP Port"),tr("Please enter your proxy's rtsp port."),
		local_rtsp_port.toInt(),1,65535,1, &isOk);

        	if (isOk) rtsp_port->set(local_rtsp_port);

	}else if(proxyState == 2){
		//auto_url = new GConfItem(GCONF_KEY_PROXY_AUTO_URL,this);
		
		bool isOk = false;
		
		QVariant local_auto_host = auto_url->value();
        
		local_auto_host = QInputDialog::getText(this, tr("Auto Configure Host"),tr("Please enter your proxy's auto configure url."),
		QLineEdit::Normal,local_auto_host.toString(), &isOk);

        	if (isOk) auto_url->set(local_auto_host);
	}



            //setText(newText);

    }


protected:


    void paintEvent(QPaintEvent *event)

    {

        QPainter p(this);

        p.setBrush(QColor(0, 0, 0, 128));

        p.setPen(Qt::NoPen);
        p.drawPixmap(rect(),button[buttonState]);
	p.drawPixmap(rect(),proxyButton[proxyState]);
        //p.drawRoundedRect(rect(), 25, 25);

        p.end();

        QWidget::paintEvent(event);

    }

};

#endif
