#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include <QLibraryInfo>

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    QSettings settings;
    ui->heightBox->setValue(settings.value("profilechangerwidget/height").toInt());
    ui->widthBox->setValue(settings.value("profilechangerwidget/width").toInt());
    ui->spinBoxOpacity->setValue(settings.value("profilechangerwidget/opacity").toInt());
    ui->checkBoxNextProfile->setChecked(settings.value("profilechangerwidget/showNextProfile").toBool());
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept()
{
    QSettings settings;
    if (ui->heightBox->text().isEmpty() || ui->widthBox->text().isEmpty()) {
        this->showInformation(tr("Fields cannot be empty!"));
        return;
    }

    settings.setValue("profilechangerwidget/width", ui->widthBox->value());
    settings.setValue("profilechangerwidget/height", ui->heightBox->value());
    settings.setValue("profilechangerwidget/opacity", ui->spinBoxOpacity->value());
    settings.setValue("profilechangerwidget/showNextProfile", ui->checkBoxNextProfile->isChecked());
    emit settingsChanged();
    this->close();
}

void SettingsDialog::showAbout()
{
    QDialog *aboutDialog = new QDialog(0);
    aboutDialog->setAttribute(Qt::WA_DeleteOnClose);
    aboutDialog->setWindowTitle(tr("About Profile Changer Widget"));
    QLabel *aboutText = new QLabel(aboutDialog);
    QString about;
    about.append(tr("Profile Changer Widget"));
    about.append("\n");
    about.append(tr("Small widget intended to enable an easy change between general and silent profiles."));
    about.append("\n\n");
    about.append(tr("Version:"));
    about.append(" ");
    about.append(QApplication::applicationVersion());
    about.append(", ");
    about.append(QString::fromUtf8("© 2012 Harald Schmitt\n"));
    aboutText->setText(about);
    aboutText->setWordWrap(true);
    QScrollArea *aboutScroll = new QScrollArea(aboutDialog);
    QVBoxLayout *scrollLayout = new QVBoxLayout(aboutScroll);
    scrollLayout->addWidget(aboutText);
    QVBoxLayout *layout = new QVBoxLayout(aboutDialog);
    layout->addWidget(aboutScroll);
    aboutDialog->setLayout(layout);
    aboutDialog->show();
    this->close();
}

void SettingsDialog::on_buttonAbout_clicked()
{
    this->showAbout();
}

void SettingsDialog::on_buttonQa_clicked()
{
    this->openBrowser("http://maemo.org/packages/view/profile-changer-widget/");
    this->close();
}

void SettingsDialog::on_buttonDonate_clicked()
{
    //TODO
    //this->openBrowser("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=");
    //this->close();
    this->showInformation("ToDo");
}

void SettingsDialog::on_buttonBox_accepted()
{
    this->accept();
}

void SettingsDialog::on_buttonBox_rejected()
{
    this->close();
}

void SettingsDialog::openBrowser(QString url)
{
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.osso_browser", // --dest
        "/com/nokia/osso_browser/request", // destination object path
        "com.nokia.osso_browser", // message name (w/o method)
        "load_url" // method
    );
    msg << url;
    msg = QDBusConnection::systemBus().call(msg);

}

void SettingsDialog::showInformation(QString info)
{
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "org.freedesktop.Notifications", // --dest
        "/org/freedesktop/Notifications", // destination object path
        "org.freedesktop.Notifications", // message name (w/o method)
        "SystemNoteInfoprint" // method
    );
    msg << info;
    msg = QDBusConnection::sessionBus().call(msg);

}
