#include "profilechangerwidget.h"
#include "ui_profilechangerwidget.h"

const QString iconSilent = "/usr/share/icons/hicolor/48x48/hildon/statusarea_silent.png";
const QString iconGeneral = "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel4.png";

ProfileChangerWidget::ProfileChangerWidget (QWidget *parent) :
QMainWindow(parent, Qt::FramelessWindowHint),
    ui(new Ui::ProfileChangerWidget)
{
    ui->setupUi(this);
    QPalette palette;
    setAttribute(Qt::WA_TranslucentBackground);
    ui->centralWidget->setAttribute(Qt::WA_TranslucentBackground);
    ui->switchButton->setAttribute(Qt::WA_TranslucentBackground);
    palette.setColor(QPalette::Base, Qt::transparent);
    ui->centralWidget->setPalette(palette);
    QSettings settings;
    if (!settings.contains("profilechangerwidget/width"))
        settings.setValue("profilechangerwidget/width", 96);
    if (!settings.contains("profilechangerwidget/height"))
        settings.setValue("profilechangerwidget/height", 96);

    connect(ui->switchButton, SIGNAL(clicked()), this, SLOT(onChangeProfileClicked()));
    this->reloadSettings();
}

ProfileChangerWidget::~ProfileChangerWidget()
{
    delete ui;
}

QString ProfileChangerWidget::getProfileName() {
    QString profileName = "";
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.profiled", // --dest
        "/com/nokia/profiled", // destination object path
        "com.nokia.profiled", // message name (w/o method)
        "get_profile" // method
    );
    msg = QDBusConnection::sessionBus().call(msg);

    if (msg.type() == QDBusMessage::ErrorMessage) {
        QErrorMessage* err = new QErrorMessage();
        err->showMessage(msg.errorMessage());
    } else if(msg.type() == QDBusMessage::ReplyMessage) {
        profileName = msg.arguments().at(0).toString();
    }
    return profileName;
}

void ProfileChangerWidget::setProfile(QString profileName) {
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.profiled", // --dest
        "/com/nokia/profiled", // destination object path
        "com.nokia.profiled", // message name (w/o method)
        "set_profile" // method
    );
    msg << profileName;
    msg = QDBusConnection::sessionBus().call(msg);
}
void ProfileChangerWidget::refreshIcon() {
    QString profileName = this->getProfileName();

    if ( profileName == "silent" ) {
        showIconGeneral();
    }
    else {
        showIconSilent(); 
    }
}
    

void ProfileChangerWidget::showIconSilent() {
    ui->switchButton->setIcon(QIcon(iconSilent));    
}

void ProfileChangerWidget::showIconGeneral() {
    ui->switchButton->setIcon(QIcon(iconGeneral));    
}

void ProfileChangerWidget::switchProfile() {
    QString profileName = this->getProfileName();
    if ( profileName == "silent" ) {
        this->setProfile("general");
    }
    else {
        this->setProfile("silent");
    }
}  

void ProfileChangerWidget::onChangeProfileClicked() {
    switchProfile();
    refreshIcon();
}

void ProfileChangerWidget::onShowSettingsDialog()
{
    SettingsDialog *dialog = new SettingsDialog(0);
    connect(dialog, SIGNAL(settingsChanged()), this, SLOT(reloadSettings()));
    dialog->show();
}

void ProfileChangerWidget::onHomeScreenChanged(bool isOnCurrentHomescreen)
{
    if(isOnCurrentHomescreen)
        refreshIcon();
}

void ProfileChangerWidget::reloadSettings()
{
    QSettings settings;
    this->setGeometry(this->x(), this->y(),
                      settings.value("profilechangerwidget/width").toInt(),
                      settings.value("profilechangerwidget/height").toInt());
    ui->switchButton->setStyleSheet("background-color: rgba(0, 0, 0, 70%); \
     border-style: outset; \
     border-width: 0px; \
     border-radius: 10px; \
     border-color: rgba(0, 0, 0, 70%); \
     font: bold 14px; \
     min-width: 48px; \
     width: " + settings.value("profilechangerwidget/width").toString() +  "px; \
     height: " + settings.value("profilechangerwidget/height").toString() +  "px; \
     padding: 6px;");
    this->refreshIcon();
}

