#ifndef PROFILECHANGERWIDGET_H
#define PROFILECHANGERWIDGET_H

#include <QDBusInterface>
#include <QErrorMessage>
#include <QtGui/qpainter.h>
#include <QTimer>
#include <QIcon>
#include <QSettings>


class ProfileChangerWidget : public QWidget
{
    Q_OBJECT

private:
    QIcon *iconSilent;
    QIcon *iconGeneral;
    QIcon *iconCurrent;

public:
    explicit ProfileChangerWidget(QWidget *parent = 0);
    ~ProfileChangerWidget();
    QSize minimumSizeHint() const {
        return QSize(48, 48);
    }

    QSize sizeHint() const {
        return QSize(48, 48);
    }



public slots:
    void onShowSettingsDialog();
    void onChangeProfileClicked();
    void reloadSettings();

protected:
    void paintEvent(QPaintEvent *event);

private:
    QString getProfileName();
    void setProfile(QString profileName);
    void switchProfile();
    void showIconSilent();
    void showIconGeneral();
    void refreshIcon();
};

#endif // PROFILECHANGERWIDGET_H

