#define DEBUG 1
#define OSSOLOG_SYSLOG 1
#include <osso-log.h>

#include "profilechangerwidget.h"

const QString iconSilentPath = "/usr/share/icons/hicolor/48x48/hildon/statusarea_silent.png";
const QString iconGeneralPath = "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel4.png";

ProfileChangerWidget::ProfileChangerWidget(QWidget *parent) :
        QWidget(parent) {
    setAttribute(Qt::WA_TranslucentBackground);
    if (!QSettings().contains("profilechangerwidget/width"))
        QSettings().setValue("profilechangerwidget/width", 48);
    if (!QSettings().contains("profilechangerwidget/height"))
        QSettings().setValue("profilechangerwidget/height", 48);

    iconGeneral = new QIcon(iconGeneralPath);
    iconSilent = new QIcon(iconSilentPath);
    iconCurrent = iconGeneral;
//    qWarning("profile-changer-widget connect onChangeProfileClicked");
//    connect(ui->switchButton, SIGNAL(clicked()), this, SLOT(onChangeProfileClicked()));
//    qWarning("profile-changer-widget connect reload");
    this->reloadSettings();
}

ProfileChangerWidget::~ProfileChangerWidget()
{
}

QString ProfileChangerWidget::getProfileName() {
    QString profileName = "";
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.profiled", // --dest
        "/com/nokia/profiled", // destination object path
        "com.nokia.profiled", // message name (w/o method)
        "get_profile" // method
    );
    msg = QDBusConnection::systemBus().call(msg);

    if (msg.type() == QDBusMessage::ErrorMessage) {
        QErrorMessage* err = new QErrorMessage();
        err->showMessage(msg.errorMessage());
    } else if(msg.type() == QDBusMessage::ReplyMessage) {
        profileName = msg.arguments().at(0).toString();
    }
    return profileName;
}

void ProfileChangerWidget::setProfile(QString profileName) {
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.profiled", // --dest
        "/com/nokia/profiled", // destination object path
        "com.nokia.profiled", // message name (w/o method)
        "set_profile" // method
    );
    msg << profileName;
    msg = QDBusConnection::systemBus().call(msg);
}
void ProfileChangerWidget::refreshIcon() {
    QString profileName = this->getProfileName();

    if ( profileName == "silent" ) {
        showIconSilent(); 
    }
    else {
        showIconGeneral();
    }
}
    

void ProfileChangerWidget::showIconSilent() {
    iconCurrent = iconSilent;
    repaint();
}

void ProfileChangerWidget::showIconGeneral() {
    iconCurrent = iconGeneral;
    repaint();
}

void ProfileChangerWidget::switchProfile() {
    QString profileName = this->getProfileName();
    if ( profileName == "silent" ) {
        this->setProfile("general");
    }
    else {
        this->setProfile("silent");
    }
}  

void ProfileChangerWidget::onChangeProfileClicked() {
    switchProfile();
    refreshIcon();
}

void ProfileChangerWidget::onShowSettingsDialog()
{
//    SettingsDialog *dialog = new SettingsDialog(0);
//    connect(dialog, SIGNAL(settingsChanged()), this, SLOT(reloadSettings()));
//    dialog->show();
}

void ProfileChangerWidget::reloadSettings()
{
    this->setGeometry(this->x(), this->y(),
                      QSettings().value("profilechangerwidget/width").toInt(),
                      QSettings().value("profilechangerwidget/height").toInt());
    this->refreshIcon();
}
void ProfileChangerWidget::paintEvent(QPaintEvent *event) {
    Q_UNUSED(event);

    QRect r = rect();
    QPainter p(this);
    p.setBrush(QColor(0, 0, 0, 150));
    p.setPen(Qt::NoPen);
    p.drawRoundedRect(rect(), 15, 15);
    QRect iconrect = QRect(r.x(), 10, r.width(), 50);

    iconCurrent->paint(&p, iconrect);

    }
