#include <string>
#include <QInputDialog>
#include <QPainter>
#include <QGridLayout>
#include <QToolButton>
#include <QSettings>
#include <libprofile.h>

#include "profilechangerwidget.h"

using namespace std;

char iconNames[][128] = {
    "/usr/share/icons/hicolor/48x48/hildon/statusarea_silent.png",
    "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel4.png"
};

ProfileChangerWidget::ProfileChangerWidget (QWidget *parent)
    : QWidget(parent)
{
    // reset settings to defaults
//    AdvSettingsDlg asd(this);
    setAttribute(Qt::WA_TranslucentBackground);

    layout = new QGridLayout(this);

    settings = new QSettings(this);
            
    button = new QToolButton(this);
    refreshIcon();
    
    button->setSizePolicy(QSizePolicy::MinimumExpanding,
            QSizePolicy::MinimumExpanding);
    layout->addWidget(button, 0%2, 0/2);

    connect(button, SIGNAL(clicked()), this, SLOT(changeProfile()));
    setContentsMargins(0, 0, 0, 0);
    layout->setContentsMargins(0, 0, 0, 0);
    setLayout(layout);
    setAttribute(Qt::WA_TranslucentBackground);
    setAttribute(Qt::WA_OpaquePaintEvent);
    resize();
}

ProfileChangerWidget::~ProfileChangerWidget()
{
    delete settings;
}

void ProfileChangerWidget::refreshIcon() {
    if ( string( profile_get_profile() ) == "silent" ) {
        changeIcon(1); 
    }
    else {
        changeIcon(0);
    }
}
    

void ProfileChangerWidget::changeIcon(unsigned index) {
    button->setIcon(QIcon(QString(
        settings->value(QString("buttonIcon") + QString::number(0),  
        iconNames[index]).toString())));    
}

void ProfileChangerWidget::switchProfile() {
    if ( string(profile_get_profile()) == "silent" ) {
        profile_set_profile("general");
    }
    else {
        profile_set_profile("silent");
    }
}  

void ProfileChangerWidget::changeProfile() {
    switchProfile();
    refreshIcon();
}

void ProfileChangerWidget::paintEvent(QPaintEvent *)
{
    int bgAlpha = settings->value("bgAlpha", "192").toInt();
    QPainter p(this);
    p.fillRect(rect(), QColor(0, 0, 0, bgAlpha));
    p.end();
}

void ProfileChangerWidget::resize()
{
    int w = settings->value("width", "48").toInt();
    int h = settings->value("height", "48").toInt();
    if (w < 1)
        w = 48;
    if (h < 1)
        h = 48;
    QWidget::resize(w, h);
}


