#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <stdlib.h>
#include <unistd.h>


#define DESKTOP_BASE_DIR_ACTIVE   "/usr/share/applications/hildon-status-menu/"
#define DESKTOP_BASE_DIR_DISABLED "/usr/share/applications/hildon-status-menu/disabled/"
#define START_UP_ANIMATION_FILE "/usr/share/hildon-welcome/media/Hands-v32-h264.avi"
#define START_UP_ANIMATION_FILE_DISABLED "/usr/share/hildon-welcome/media/Hands-v32-h264.avi.disabled"

#define POWA_MOVE_UTIL "/usr/bin/powamove"

gboolean
applet_toggled(GtkWidget *this, gpointer data)
{
    gchar *name = (gchar*)data;
    gboolean active = hildon_check_button_get_active(HILDON_CHECK_BUTTON(this));
    pid_t execpid;

    execpid = fork(); 

    if (execpid == 0)
    {
        //Only child does work - move files
        
        if (active) {
            //g_rename (g_strdup_printf("%s%s", DESKTOP_BASE_DIR_DISABLED, name), g_strdup_printf("%s%s", DESKTOP_BASE_DIR_ACTIVE, name));
            execl(POWA_MOVE_UTIL, POWA_MOVE_UTIL, g_strdup_printf("%s%s", DESKTOP_BASE_DIR_DISABLED, name), g_strdup_printf("%s%s", DESKTOP_BASE_DIR_ACTIVE, name), NULL);
        } else {
            //g_rename (g_strdup_printf("%s%s", DESKTOP_BASE_DIR_ACTIVE, name), g_strdup_printf("%s%s", DESKTOP_BASE_DIR_DISABLED, name));
            execl(POWA_MOVE_UTIL, POWA_MOVE_UTIL, g_strdup_printf("%s%s", DESKTOP_BASE_DIR_ACTIVE, name), g_strdup_printf("%s%s", DESKTOP_BASE_DIR_DISABLED, name), NULL);
        }
        exit(0);
    }
    
    return TRUE;
}

gboolean
nokia_hands_toggled_cb(GtkWidget *this, gpointer data)
{
    pid_t execpid;
    gboolean active = hildon_check_button_get_active(HILDON_CHECK_BUTTON(this));

    execpid = fork(); 

    if (execpid != 0) 
    {
        //Parent thread - do the UI part
        if (active)
        {
            gtk_button_set_label(GTK_BUTTON(this), "Nokia Hands enabled");
            printf("Going to enable Nokia hands");
            //g_rename (START_UP_ANIMATION_FILE_DISABLED, START_UP_ANIMATION_FILE);
        } else {
            gtk_button_set_label(GTK_BUTTON(this), "Nokia Hands disabled");
            printf("Going to disable Nokia hands");
            //g_rename (START_UP_ANIMATION_FILE, START_UP_ANIMATION_FILE_DISABLED);
        }
    } else {
        //Child thread - execute the mover and exit
        if (active) {
            execl(POWA_MOVE_UTIL, POWA_MOVE_UTIL, START_UP_ANIMATION_FILE_DISABLED, START_UP_ANIMATION_FILE, NULL);
        } else {
            execl(POWA_MOVE_UTIL, POWA_MOVE_UTIL, START_UP_ANIMATION_FILE, START_UP_ANIMATION_FILE_DISABLED, NULL);
        }
        exit(0);
    }
    return TRUE;        
}


void
read_applets(GtkWidget *vb, gboolean dis)
{
    const gchar *name;
    GDir *dir = NULL;
    
    if (dis)
        dir = g_dir_open(DESKTOP_BASE_DIR_DISABLED, 0, NULL);
    else
        dir = g_dir_open(DESKTOP_BASE_DIR_ACTIVE, 0, NULL);

    if (!dir) return;

    name = g_dir_read_name(dir);
    while (name)
    {
        if (g_str_has_suffix(name, ".desktop") == TRUE) 
        {
            GKeyFile *k = g_key_file_new();
            gchar *file;

            if (dis)
                file = g_strconcat(DESKTOP_BASE_DIR_DISABLED, name, NULL);
            else
                file = g_strconcat(DESKTOP_BASE_DIR_ACTIVE, name, NULL);
            if (g_key_file_load_from_file(k, file, G_KEY_FILE_NONE, NULL))
            {
                GtkWidget *b = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
                gtk_button_set_label(GTK_BUTTON(b), g_key_file_get_string(k, "Desktop Entry", "Name", NULL));
                gtk_widget_show(b);
                if (dis)
                    hildon_check_button_set_active(HILDON_CHECK_BUTTON(b), FALSE);
                else
                    hildon_check_button_set_active(HILDON_CHECK_BUTTON(b), TRUE);
                gtk_box_pack_start(GTK_BOX(vb), b, TRUE, TRUE, 0);
                g_signal_connect(G_OBJECT(b), "toggled", G_CALLBACK(applet_toggled), g_strdup(name));
            }
            g_free(file);
            g_key_file_free(k);
        }
        name =  g_dir_read_name(dir);
    } 

    
}

GtkWidget*
show_nokiahands_page(void)
{
    GtkWidget *temp;
    GtkWidget *checkb;
    GtkWidget* w = hildon_stackable_window_new();
    gtk_window_set_title(GTK_WINDOW(w), "Nokia Hands");

    GtkWidget *vb = gtk_vbox_new(FALSE, 0);
    GtkWidget *hb = gtk_hbox_new(TRUE, 0);
    
    temp = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vb), temp, TRUE, TRUE, 0);

    if (g_file_test(START_UP_ANIMATION_FILE, G_FILE_TEST_EXISTS) == TRUE)
    {
        checkb = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
        gtk_button_set_label(GTK_BUTTON(checkb), "Nokia Hands enabled");
        hildon_check_button_set_active(HILDON_CHECK_BUTTON(checkb), TRUE);
        gtk_box_pack_start(GTK_BOX(hb), checkb, TRUE, TRUE, 40);
        gtk_signal_connect(GTK_OBJECT(checkb), "toggled", G_CALLBACK(nokia_hands_toggled_cb), NULL);
    } else if (g_file_test(START_UP_ANIMATION_FILE_DISABLED, G_FILE_TEST_EXISTS) == TRUE) {
        checkb = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
        gtk_button_set_label(GTK_BUTTON(checkb), "Nokia Hands disabled");
        hildon_check_button_set_active(HILDON_CHECK_BUTTON(checkb), FALSE);
        gtk_box_pack_start(GTK_BOX(hb), checkb, TRUE, TRUE, 40);
        gtk_signal_connect(GTK_OBJECT(checkb), "toggled", G_CALLBACK(nokia_hands_toggled_cb), NULL);
    } else {
        GtkWidget *l = gtk_label_new("ERROR -  Nokia hands animation file not found");
        gtk_box_pack_start(GTK_BOX(hb), l, TRUE, TRUE, 0);
    }

    gtk_box_pack_start(GTK_BOX(vb), hb, FALSE, TRUE, 0);
    temp = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vb), temp, TRUE, TRUE, 0);

    gtk_container_add(GTK_CONTAINER (w), vb);
    
    gtk_widget_show_all(w);

    return (w);
}

GtkWidget*
show_applets_page(void)
{
    GtkWidget *w = hildon_stackable_window_new();
    gtk_window_set_title(GTK_WINDOW(w), "Status applets");

    GtkWidget *pa = hildon_pannable_area_new();
    gtk_widget_show(pa);
    GtkWidget *vb = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vb);
    hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(pa), vb);

    read_applets(vb, FALSE);
    read_applets(vb, TRUE);
    
    gtk_container_add(GTK_CONTAINER (w), pa);

    gtk_widget_show_all(w);

    return (w);
}


int
main (int argc, char *argv[])
{
    GtkWidget *temp, *b;

    hildon_gtk_init (&argc, &argv);

    GtkWidget *w = hildon_stackable_window_new(); 
    gtk_window_set_title(GTK_WINDOW(w), "Powatool");

    GtkWidget *hb = gtk_hbox_new(TRUE, 5);
    GtkWidget *vb = gtk_vbox_new(FALSE, 5);

    temp = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hb), temp, TRUE, TRUE, 0);
    
    b = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, 0);
    hildon_button_set_text(HILDON_BUTTON(b), "Nokia hands", "");
    gtk_signal_connect(GTK_OBJECT(b), "clicked", G_CALLBACK(show_nokiahands_page), NULL);
    gtk_box_pack_start(GTK_BOX(hb), b, FALSE, TRUE, 0);

    b = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, 0);
    hildon_button_set_text(HILDON_BUTTON(b), "Status bar", "");
    gtk_signal_connect(GTK_OBJECT(b), "clicked", G_CALLBACK(show_applets_page), NULL);
    gtk_box_pack_start(GTK_BOX(hb), b, FALSE, TRUE, 0);

    temp = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hb), temp, TRUE, TRUE, 0);

    temp = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vb), temp, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vb), hb, FALSE, TRUE, 0);
    temp = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vb), temp, TRUE, TRUE, 0);

    gtk_container_add(GTK_CONTAINER(w), vb);
    
    gtk_widget_show_all(w);
    
    gtk_signal_connect(GTK_OBJECT(w), "destroy", G_CALLBACK(gtk_main_quit), NULL);

    gtk_main();

	return 0;
}
