/*
  Copyright (C) 2011  Sakari Hyoty

  This file is part of Pomodoro.

  Pomodoro is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pomodoro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.
  */

#include <QPushButton>
#include <QFileDialog>

#include "sounddialog.h"
#include "ui_sounddialog.h"
#include "pomodoroconfig.h"

SoundDialog::SoundDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SoundDialog)
{
    qDebug("SoundDialog::SoundDialog");

    ui->setupUi(this);

    connect(ui->browseButton, SIGNAL(clicked()), this, SLOT(browse()));
    connect(ui->buttonBox->button(QDialogButtonBox::RestoreDefaults), SIGNAL(clicked()),
            this, SLOT(reset()));
}

SoundDialog::~SoundDialog()
{
    qDebug("SoundDialog::~SoundDialog");

    delete ui;
}

void SoundDialog::browse()
{
    QString filePath = QFileDialog::getOpenFileName(
            this, tr("Select alarm tone"),
            QDir::homePath(),
            "Audio files (*.wav *.mp3)",
            0, QFileDialog::ReadOnly);

    if (!filePath.isEmpty()) {
        ui->audioFileLineEdit->setText(filePath);

        if (filePath != POMODORO_FILE_ALERT) {
            ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(true);
            ui->buttonBox->button(QDialogButtonBox::RestoreDefaults)->setEnabled(true);
        } else {
            ui->buttonBox->button(QDialogButtonBox::RestoreDefaults)->setEnabled(false);
        }
    }
}

void SoundDialog::show(QString currentAudioFile)
{
    qDebug("SoundDialog::show");

    ui->audioFileLineEdit->setText(currentAudioFile);
    ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(false);

    if (currentAudioFile != POMODORO_FILE_ALERT)
        ui->buttonBox->button(QDialogButtonBox::RestoreDefaults)->setEnabled(true);
    else
        ui->buttonBox->button(QDialogButtonBox::RestoreDefaults)->setEnabled(false);

    QDialog::show();
}

void SoundDialog::reset()
{
    ui->audioFileLineEdit->setText(POMODORO_FILE_ALERT);
    ui->buttonBox->button(QDialogButtonBox::RestoreDefaults)->setEnabled(false);
    ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(true);
}

void SoundDialog::accept()
{
    qDebug("SoundDialog::accept");

    QDialog::accept();

    if (ui->audioFileLineEdit->text() != POMODORO_FILE_ALERT)
        emit alarmFileChanged(ui->audioFileLineEdit->text());
    else
        emit alarmFileReset();

    QString empty;
    ui->audioFileLineEdit->setText(empty);
}

void SoundDialog::reject()
{
    qDebug("SoundDialog::reject");

    QDialog::reject();

    QString empty;
    ui->audioFileLineEdit->setText(empty);
}
