/*
  Copyright (C) 2010  Sakari Hyoty

  This file is part of Pomodoro.

  Pomodoro is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pomodoro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.
  */

#ifndef TASKDIALOG_H
#define TASKDIALOG_H

#include <QDialog>

namespace Ui {
    class TaskDialog;
}

class TaskDialog : public QDialog {
    Q_OBJECT
public:
    TaskDialog(QWidget *parent = 0);
    ~TaskDialog();

public slots:
    void show(); // reimplemented from QDialog
    void accept(); // reimplemented from QDialog
    void reject(); // reimplemented from QDialog
    void taskNameChanged(QString newName);

signals:
    void newTask(QString taskName, int estimate);

protected:
    void changeEvent(QEvent *e);

private:
    Ui::TaskDialog *ui;
};

#endif // TASKDIALOG_H
