/*
  Copyright (C) 2010  Sakari Hyoty

  This file is part of Pomodoro.

  Pomodoro is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pomodoro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.
  */

#ifndef POMODOROTIMER_H
#define POMODOROTIMER_H

#include <QObject>

class PomodoroTimer : public QObject
{
    Q_OBJECT
    Q_PROPERTY(int pomodoroLength READ lengthInSeconds);

public:
    explicit PomodoroTimer(QObject *parent = 0);
    ~PomodoroTimer(); // virtual

    int lengthInSeconds() const;
    bool isStarted() const;

signals:
    void started(int lengthInSeconds);
    void stopped(bool finished);
    void secondsElapsed(int secondsElapsed);
    void secondsLeft(int secondsLeft);

public slots:
    void start();
    void stop(bool signal = true);
    void setLength(int seconds);

protected:
    void timerEvent(QTimerEvent *event);

private:
    int pomodoroLength;
    int elapsed;
    int timerId;
};

#endif // POMODOROTIMER_H
