/*
  Copyright (C) 2010  Sakari Hyoty

  This file is part of Pomodoro.

  Pomodoro is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pomodoro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.
  */

#include "pomodorotimer.h"

PomodoroTimer::PomodoroTimer(QObject *parent) :
    QObject(parent),
    pomodoroLength(0),
    elapsed(0),
    timerId(-1)
{
}

PomodoroTimer::~PomodoroTimer()
{
    stop();
}

int PomodoroTimer::lengthInSeconds() const
{
    return pomodoroLength;
}

bool PomodoroTimer::isStarted() const
{
    return timerId != -1;
}

void PomodoroTimer::start()
{
    stop();
    timerId = startTimer(1000); // msec
    emit started(pomodoroLength);
    emit secondsElapsed(elapsed);
}

void PomodoroTimer::stop(bool signal)
{
    if (timerId != -1) {
        killTimer(timerId);
        timerId = -1;

        if (signal)
            emit stopped(!static_cast<bool>(pomodoroLength - elapsed));
        elapsed = 0;
    }
}

void PomodoroTimer::setLength(int seconds)
{
    pomodoroLength = seconds;
}

void PomodoroTimer::timerEvent(QTimerEvent */*event*/)
{
    qDebug("PomodoroTimer::timerEvent");
    elapsed++;

    emit secondsElapsed(elapsed);
    emit secondsLeft(pomodoroLength - elapsed);

    if (elapsed == pomodoroLength) {
        stop();
    }
}
