/*
  Copyright (C) 2010  Sakari Hyoty

  This file is part of Pomodoro.

  Pomodoro is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pomodoro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.
  */

#ifndef POMODOROMODEL_H
#define POMODOROMODEL_H

#include <QAbstractTableModel>
#include <QVector>
#include <QDate>

struct PomodoroTask;

class PomodoroModel : public QAbstractTableModel
{
    Q_OBJECT

public:
    explicit PomodoroModel(QObject *parent = 0);
    ~PomodoroModel(); // virtual

    // from QAbstractItemModel
    int rowCount(const QModelIndex &parent) const;
    int columnCount(const QModelIndex &parent) const;
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    QModelIndex index(int row, int column, const QModelIndex &parent) const;

    // custom model methods
    bool loadModel();
    bool saveModel();

    QModelIndex newTask(QString taskName, int estimate);
    void deleteTask(const QModelIndex &index);
    void taskCompleted(const QModelIndex &index);
    bool isTaskCompleted(const QModelIndex &index);

    void pomodoroCompleted(const QModelIndex &index);
    void pomodoroInterrupted(const QModelIndex &index, bool internalInterruption);

private:
    PomodoroTask *task(const QModelIndex &index);

private:
    QVector<PomodoroTask> pomodoroVector;
    int taskIdRunner;
    bool dirty;
};

#endif // POMODOROMODEL_H
