#ifndef DATA_LOCATION_H
#define DATA_LOCATION_H

#include "../Data.h"

namespace Data {
  class Location : public ::Base::Data
  {
  public:
    class LocationType : public ::Base::Type
    {
    public:
      enum Attribute
      {
        street  = 0,
        city    = 1,
        zip     = 2,
        state   = 3,
        country = 4
      };

    public:
      LocationType();

      unsigned long GetMaxAttribute() const;
      bool IsPrimaryType() const;

      ::Base::DataPtr Create() const;
    };

  public:
    static LocationType *locationType;

  public:
    std::wstring street;
    std::wstring city;
    std::wstring zip;
    std::wstring state;
    std::wstring country;

  public:
    Location();

    std::wstring GetDisplayText() const;

    void SetAttribute(::Base::Id id, const std::wstring& value);
    std::wstring GetAttribute(::Base::Id id) const;
  };

  typedef Location *LocationPtr;
}

#endif
