#include "Data.h"

namespace Base {
  /*static Id GetNextId()
  {
    static Id currentId=1;
    Id res;

    res=currentId;
    currentId++;

    return res;
  }*/

  std::map<std::wstring,TypePtr> Type::typeNameMap;
  std::list<TypePtr>             Type::typeList;

  void Type::RegisterType(TypePtr type)
  {
    typeList.push_back(type);
    typeNameMap[type->GetName()]=type;
  }

  TypePtr Type::GetTypeByName(const std::wstring& name)
  {
    std::map<std::wstring,TypePtr>::iterator iter;

    iter=typeNameMap.find(name);

    if (iter!=typeNameMap.end()) {
      return iter->second;
    }
    else {
      return NULL;
    }
  }

  TypePtr Type::GetTypeByIndex(size_t index)
  {
    std::list<TypePtr>::const_iterator iter;
    size_t                             current;

    current=0;
    iter=typeList.begin();
    while (current!=index) {
      iter++;
      current++;

      assert(iter!=typeList.end());
    }

    return *iter;
  }

  Type::Type(const std::wstring& name)
  : name(name)
  {
    // no code
  }

  Type::~Type()
  {
    // no code
  }

  std::wstring Type::GetName() const
  {
    return name;
  }

  void Type::RegisterAttribute(const std::wstring& name, Id id)
  {
    attrIds[name]=id;
    attrNames[id]=name;
  }

  bool Type::GetIdFromName(const std::wstring& name, Id &id)
  {
    std::map<std::wstring,Id>::iterator iter;

    iter=attrIds.find(name);
    if (iter!=attrIds.end()) {
      id=iter->second;
      return true;
    }
    else {
      return false;
    }
  }

  bool Type::GetNameFromId(Id id, std::wstring& name)
  {
    std::map<Id,std::wstring>::iterator iter;

    iter=attrNames.find(id);
    if (iter!=attrNames.end()) {
      name=iter->second;
      return true;
    }
    else {
      return false;
    }
  }


  Data::Data(TypePtr type)
  : id(0),type(type),state(created)
  {
    // no code
  }

  Data::~Data()
  {
    // no code
  }

  bool Data::IsGreater(Data* other) const
  {
    return type->GetName()>other->type->GetName();
  }

  void Data::SetId(Id id)
  {
    this->id=id;
  }

  Id Data::GetId() const
  {
    return id;
  }

  TypePtr Data::GetType() const
  {
    return type;
  }

  void Data::PostLoadCallback()
  {
    // no code
  }

  void Data::SetState(State state)
  {
    this->state=state;
  }

  Data::State Data::GetState() const
  {
    return state;
  }

  bool Data::IsRegistered() const
  {
    return state==registered;
  }

  bool Data::IsSaveable() const
  {
    return true;
  }

  void Data::LinkData(const std::wstring& name, DataPtr other)
  {
    LinkPtr link;

    link=new Link(name,this,other);

    links.push_back(link);
    other->links.push_back(link);
  }

  const LinkList& Data::GetLinks() const
  {
    return links;
  }

  const LinkList& Data::GetLinks()
  {
    return links;
  }

  size_t Data::GetLinkCount() const
  {
    return links.size();
  }

  void Data::Remove(LinkPtr link)
  {
    links.remove(link);
  }

  bool Data::IsMultilineAttribute(Id /*id*/) const
  {
    return false;
  }

  Link::Link(const std::wstring& name, DataPtr first, DataPtr second)
  : name(name),first(first),second(second)
  {
    //no code
  }

  DataPtr Link::GetFirst() const
  {
    return first;
  }

  DataPtr Link::GetSecond() const
  {
    return second;
  }

  std::wstring Link::GetName() const
  {
    return name;
  }

  void Link::SetName(const std::wstring& name)
  {
    this->name=name;
  }

}
