#include "Location.h"

#include "../Database.h"

#include "../Data/Location.h"

#include <Lum/Base/Util.h>

#include <Lum/Model/Selection.h>

#include <Lum/Label.h>

#include <iostream>

namespace Views {

  Location::Location()
  : DataView(L"Location")
  {
    street=new Lum::Model::String();
    city=new Lum::Model::String();
    zip=new Lum::Model::String();
    state=new Lum::Model::String();
    country=new Lum::Model::String();

    RegisterModel(street);
    RegisterModel(city);
    RegisterModel(zip);
    RegisterModel(state);
    RegisterModel(country);
  }

  void Location::RegisterDataViews(Lum::Tab*& tab)
  {
    tab->Add(L"Location",
             Lum::VPanel::Create(true,true)
             ->Add(Lum::Label::Create(true,false)
                   ->AddLabel(L"Street",Lum::String::Create(street,true,false))
                   ->AddLabel(L"City",Lum::String::Create(city,true,false))
                   ->AddLabel(L"ZIP",Lum::String::Create(zip,true,false))
                   ->AddLabel(L"State",Lum::String::Create(state,true,false))
                   ->AddLabel(L"Country",Lum::String::Create(country,true,false))));

    DataView::RegisterDataViews(tab);
  }

  void Location::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==saveAction && saveAction->IsFinished()) {
      if (!location->IsRegistered()) {
        database->Insert(location);

        if (viewData->RequestsLink()) {
          viewData->linkData->LinkData(viewData->linkName,location);
          viewData->ClearLinkInfo();
          RefreshLinkTable();
        }
      }
      Save();
    }
    else if (IsRegisteredModel(model)) {
      if (!city->Empty()) {
        saveAction->Enable();
      }
      else {
        saveAction->Disable();
      }
    }
    else {
      DataView::Resync(model,msg);
    }
  }

  void Location::Load(DataPtr viewData)
  {
    SetViewData(viewData);

    location=dynamic_cast< ::Data::Location*>(viewData->data);

    assert(location!=NULL);

    street->Set(location->street);
    city->Set(location->city);
    zip->Set(location->zip);
    state->Set(location->state);
    country->Set(location->country);

    DataView::Load(viewData);
  }

  void Location::Vanish()
  {
    DataView::Vanish();

    location=NULL;
  }

  void Location::Save()
  {
    location->street=street->Get();
    location->city=city->Get();
    location->zip=zip->Get();
    location->state=state->Get();
    location->country=country->Get();
  }
}
