#ifndef VIEWS_DATES_H
#define VIEWS_DATES_H

#include "../GUI.h"

#include <list>

#include <Lum/Model/Table.h>

#include <Lum/Panel.h>
#include <Lum/Table.h>

#include "../Data/Date.h"

namespace Views {

  class DatesEntry
  {
  public:
    ::Data::DatePtr     date;
    Lum::Base::Calendar startDate;
    Lum::Base::Calendar endDate;

  public:
    DatesEntry(::Data::DatePtr date,
               const Lum::Base::Calendar& startDate,
               const Lum::Base::Calendar& endDate)
    : date(date),startDate(startDate),endDate(endDate)
    {
      // no code
    }
  };

  typedef Lum::Model::StdTable<DatesEntry*>     DatesEntryModel;
  typedef Lum::Base::Reference<DatesEntryModel> DatesEntryModelRef;

  class Dates : public ::Base::View
  {
  private:
    Lum::Model::ActionRef    viewAction;
    Lum::Model::ActionRef    addAction;
    Lum::Model::ActionRef    deleteAction;
    DatesEntryModelRef       model;
    Lum::Table               *table;
    Lum::Panel               *top;

  private:
    void AddEntryIfInFuture(::Data::DatePtr date,
                            const Lum::Base::Calendar& now,
                            const Lum::Base::Calendar& startDate,
                            const Lum::Base::Calendar& endDate);
    void FillList();

  public:
    Dates();
    ~Dates();

    bool VisitChildren(Lum::Visitor &visitor, bool onlyVisible);

    void CalcSize();
    void Layout();

    void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

    void Load(DataPtr data);
    void Vanish();
  };

}

#endif
