#include "Selector.h"

#include "../GUI.h"

#include <iostream>

#include <Lum/Base/Util.h>

#include <Lum/Model/Selection.h>

#include <Lum/TableView.h>

namespace Views {

  DefaultSelector::DefaultSelector()
  : View(L"Selectors"),model(NULL),table(NULL)
  {
    doubleClickAction=new Lum::Model::Action;
    Observe(doubleClickAction);

    model=new Lum::Model::StringTable();

    table=new Lum::Table();
    table->SetModel(model);
    table->SetSelection(new Lum::Model::SingleLineSelection());
    table->SetDoubleClickAction(doubleClickAction);
  }

  DefaultSelector::~DefaultSelector()
  {
    delete table;
  }

  bool DefaultSelector::VisitChildren(Lum::Visitor &visitor, bool onlyVisible)
  {
    if (table!=NULL) {
      return visitor.Visit(table);
    }

    return true;
  }

  void DefaultSelector::CalcSize()
  {
    table->SetParent(this);
    table->SetFlex(true,true);

    table->CalcSize();

    width=table->GetOWidth();
    height=table->GetOHeight();
    minWidth=table->GetOMinWidth();
    minHeight=table->GetOMinHeight();
    maxWidth=table->GetOMaxWidth();
    maxHeight=table->GetOMaxHeight();

    View::CalcSize();
  }

  void DefaultSelector::Layout()
  {
    table->Resize(width,height);
    table->Move(x,y);

    View::Layout();
  }

  void DefaultSelector::RegisterSelector(::Base::ViewPtr view)
  {
    views.push_back(view);
  }

  void DefaultSelector::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==doubleClickAction && doubleClickAction->IsFinished()) {
      if (table->GetTableView()->GetSelection()->HasSelection()) {
        size_t line;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(table->GetTableView()->GetSelection())->GetLine();
        GUI::GetInstance()->ShowView(this->model->GetString(1,line),NULL);
      }
    }
    else {
      View::Resync(model,msg);
    }
  }

  void DefaultSelector::Load(::Base::View::DataPtr data)
  {
    std::list< ::Base::ViewPtr>::const_iterator iter;

    model->Off();

    iter=views.begin();
    while (iter!=views.end()) {
      model->Append((*iter)->GetName());

      iter++;
    }

    model->On();
  }

  void DefaultSelector::Vanish()
  {
    model->Clear();
  }

}
