#ifndef VIEWS_SELECTOR_H
#define VIEWS_SELECTOR_H

#include "../View.h"

#include <list>

#include <Lum/Model/Action.h>
#include <Lum/Model/Table.h>

#include <Lum/Table.h>

namespace Views {

  class DefaultSelector : public ::Base::View
  {
  private:
    Lum::Model::ActionRef       doubleClickAction;
    Lum::Model::StringTableRef  model;
    Lum::Table                  *table;
    std::list< ::Base::ViewPtr> views;

  public:
    DefaultSelector();
    ~DefaultSelector();

    bool VisitChildren(Lum::Visitor &visitor, bool onlyVisible);

    void CalcSize();
    void Layout();

    void RegisterSelector(::Base::ViewPtr view);

    void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

    void Load(::Base::View::DataPtr data);
    void Vanish();
  };

  typedef DefaultSelector *DefaultSelectorPtr;
}

#endif
