#include "Note.h"

#include "../Database.h"

#include "../Data/Note.h"

#include <Lum/Base/Util.h>

#include <Lum/Edit/Edit.h>

#include <Lum/Model/Selection.h>

#include <Lum/View.h>

#include <iostream>

namespace Views {

  Note::Note()
  : DataView(L"Note")
  {
    text=new Lum::Edit::Text();

    RegisterModel(text);
  }

  void Note::RegisterDataViews(Lum::Tab*& tab)
  {
    Lum::Edit::Edit *edit;

    panel=Lum::VPanel::Create(true,true);

    edit=new Lum::Edit::Edit();
    edit->SetFlex(true,true);
    edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
    edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
    edit->SetModel(text);

    panel->Add(Lum::View::Create(edit,true,true));

    tab->Add(L"Note",panel);

    DataView::RegisterDataViews(tab);
  }

  void Note::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==saveAction && saveAction->IsFinished()) {
      if (!note->IsRegistered()) {
        database->Insert(note);

        if (viewData->RequestsLink()) {
          viewData->linkData->LinkData(viewData->linkName,note);
          viewData->ClearLinkInfo();
          RefreshLinkTable();
        }
      }
      Save();
    }
    else if (IsRegisteredModel(model)) {
      if (text->GetSize()>0) {
        saveAction->Enable();
      }
      else {
        saveAction->Disable();
      }
    }
    else {
      DataView::Resync(model,msg);
    }
  }

  void Note::Load(DataPtr viewData)
  {
    SetViewData(viewData);

    note=dynamic_cast< ::Data::Note*>(viewData->data);

    assert(note!=NULL);

    text->SetText(note->text);

    DataView::Load(viewData);
  }

  void Note::Vanish()
  {
    DataView::Vanish();

    note=NULL;
  }

  void Note::Save()
  {
    note->text=text->GetText();
  }
}
