#include "MSISDN.h"

#include <assert.h>

namespace Data {
  MSISDN::MSISDNType *MSISDN::msisdnType=new MSISDN::MSISDNType();

  MSISDN::MSISDNType::MSISDNType()
  : Type(L"MSISDN")
  {
    RegisterAttribute(L"msisdn",msisdn);
  }

  unsigned long MSISDN::MSISDNType::GetMaxAttribute() const
  {
    return msisdn;
  }

  bool MSISDN::MSISDNType::IsPrimaryType() const
  {
    return false;
  }

  ::Base::DataPtr MSISDN::MSISDNType::Create() const
  {
    return new MSISDN;
  }

  MSISDN::MSISDN()
   : Data(msisdnType)
  {
    // no code
  }

  bool MSISDN::IsGreater(Data* other) const
  {
    MSISDN* tmp=dynamic_cast<MSISDN*>(other);

    if (tmp==NULL) {
      return false;
    }

    return msisdn>tmp->msisdn;
  }

  std::wstring MSISDN::GetDisplayText() const
  {
    return msisdn;
  }

  void MSISDN::SetAttribute(::Base::Id id, const std::wstring& value)
  {
    switch (id) {
    case MSISDNType::msisdn:
      msisdn=value;
      break;
    default:
      assert(false);
    }
  }

  std::wstring MSISDN::GetAttribute(Base::Id id) const
  {
    switch (id) {
    case MSISDNType::msisdn:
      return msisdn;
    default:
      assert(false);
    }
  }
}
