#include "customtablewidget.h"
#include <QtGui>
#include "tableitem.h"
#include "ctworkingthread.h"

//
//  Number of table columns
//
const int CustomTableWidget::colomnNo = 5;

CustomTableWidget::CustomTableWidget(QWidget *parent) :
    QTableWidget(parent)
{
    verticalHeader()->hide();
    horizontalHeader()->hide();

    verticalHeader()->setResizeMode( QHeaderView::ResizeToContents );
    horizontalHeader()->setResizeMode( QHeaderView::Stretch );
    //horizontalHeader()->setResizeMode( QHeaderView::ResizeToContents );


    resizeRowsToContents();
    resizeColumnsToContents();

    this->setColumnCount( CustomTableWidget::colomnNo );

    this->setSelectionMode( QAbstractItemView::NoSelection );

    this->setProperty("FingerScrollable", true);

    this->setShowGrid( false );

    //
    // ToDo: delete in destructor
    //
    wthread = new CTWorkingThread( this );


    connect( wthread,
             SIGNAL( imageProcessed(int, int, const QImage & ) ),
             this,
             SLOT( refreshTableWidgetPicture(int, int, const QImage & ) ) );
    connect( this,
             SIGNAL( cellClicked( int, int ) ),
             this,
             SLOT( itemDoubleClicked( int, int ) ) );

}

CustomTableWidget::~CustomTableWidget( )
{
    wthread->terminate();
    wthread->wait();
    wthread->deleteLater();

    this->clear();
}

bool
CustomTableWidget::populateCustomTableWidget( const QString &dirPath )
{
     QDir dir( dirPath );

    if( !dir.exists() )
        return false;

    //
    //    Update current Path, stop the working thread, clear the old items
    //
    this->currentPath = dirPath;
    emit  pathUpdated( this->currentPath );

    disconnect( wthread,
             SIGNAL( imageProcessed(int, int, const QImage & ) ),
             this,
             SLOT( refreshTableWidgetPicture(int, int, const QImage & ) ) );

    wthread->terminate();
    wthread->deleteLater();
    wthread = new CTWorkingThread( this );

    this->clear();
    this->setRowCount(0);

    QStringList fileList;
    //
    //    Get subdirs
    //
    qDebug() << dirPath;
    if( !dirPath.compare( "/home/user/MyDocs") )
    {
        dir.setFilter( QDir::Dirs | QDir::NoDotAndDotDot | QDir::Hidden );
    }
    else
    {
        dir.setFilter( QDir::Dirs | QDir::NoDotAndDotDot );
    }

    fileList << dir.entryList();

    //
    //    Get Files ( time modif order )
    //
    dir.setSorting( QDir::Time );
    QStringList nameFilters;
    nameFilters << "*.bmp" << "*.gif" << "*.jpg" << "*.jpeg" << "*.mng" << "*.png"
                << "*.pbm" << "*.pgm" << "*.ppm" << "*.tiff" << "*.xbm" << "*.xpm" << "*.svg";

    dir.setFilter( QDir::AllEntries );
    dir.setNameFilters( nameFilters );
    fileList << dir.entryList();


    int fileListNo = fileList.size();

    if( !fileListNo )
    {
        return true;
    }
    qDebug() << "No of Files and folders" << fileListNo;
    int rowCountNo = fileListNo / CustomTableWidget::colomnNo + 1;

    //
    //  Set the table rows
    //
    this->setRowCount( rowCountNo );

    //
    //  Prepair the tempImage
    //
    QPixmap tempImage = QPixmap( ":/CustomDialog/tempImage.png" );


    //
    //  Create first table cell and
    //  Start the working thread
    //
    TableItem *tableItem = new TableItem( tempImage,
                                          fileList.at(0), this );

    this->setCellWidget( 0 ,
                         0,
                         tableItem );

    connect( wthread,
             SIGNAL( imageProcessed(int, int, const QImage & ) ),
             this,
             SLOT( refreshTableWidgetPicture(int, int, const QImage & ) ) );
    wthread->prepairToStart( dirPath,
                             fileList );
    wthread->start();




    //
    //  Create the rest of table content
    //
    int cellNo = this->columnCount() * this->rowCount();
    for( int i = fileListNo; i< cellNo; i++ )
    {
        this->setCellWidget( i / CustomTableWidget::colomnNo ,
                             i % CustomTableWidget::colomnNo,
                             new QWidget( this ) );


    }

    for( int i = 1; i< fileListNo; i++ )
    {

        TableItem *tableItem = new TableItem( tempImage,
                                              fileList.at(i), this );

        this->setCellWidget( i / CustomTableWidget::colomnNo ,
                             i % CustomTableWidget::colomnNo,
                             tableItem );


    }

    return true;
}



void
CustomTableWidget::refreshTableWidgetPicture( int i,
                                              int j,
                                              const QImage &picture)
{
    if( this->cellWidget( i, j ) )
    {
        TableItem *tableItem = dynamic_cast< TableItem *>(this->cellWidget(i,j));

        if( tableItem )
            tableItem->getPictureLabel()->setPixmap( QPixmap::fromImage( picture ) );
    }

}

void
CustomTableWidget::itemDoubleClicked( int i,
                                      int j )
{

    if( this->cellWidget( i, j ) )
    {
        TableItem *tableItem = dynamic_cast< TableItem* >( this->cellWidget( i, j ) );
        if( !tableItem )
            return;

        QString absolutePath = this->currentPath + QDir::separator() +
                               tableItem->getFullName();
        QDir tempDir = QDir( absolutePath );
        if( tempDir.exists() )
        {
            this->populateCustomTableWidget( tempDir.absolutePath() );
        }
        else
        {
            qDebug() << "emit a finish dialog signal";
            emit pictureSelected( this->currentPath + QDir::separator() + tableItem->getFullName() );
        }
    }

}

void
CustomTableWidget::tWcdUp()
{
    QDir dir( currentPath );
    if( dir.cdUp() )
    {
        this->populateCustomTableWidget( dir.absolutePath() );
    }
}

void
CustomTableWidget::refreshTable()
{
    populateCustomTableWidget( this->currentPath );
}
